/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Arrays;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.OrdinalValue;
import org.junit.Assert;
import org.junit.Test;

public class FieldValueTest {
    @Test
    public void categoricalString() {
        FieldValue zero = FieldValueTest.create(DataType.STRING, OpType.CATEGORICAL, "0");
        FieldValue one = FieldValueTest.create(DataType.STRING, OpType.CATEGORICAL, "1");
        Assert.assertEquals((Object)0, (Object)zero.asInteger());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)zero.asBoolean());
        Assert.assertEquals((Object)1, (Object)one.asInteger());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)one.asBoolean());
    }

    @Test
    public void ordinalString() {
        OrdinalValue loud = new OrdinalValue(DataType.STRING, (Object)"loud");
        OrdinalValue louder = new OrdinalValue(DataType.STRING, (Object)"louder");
        OrdinalValue insane = new OrdinalValue(DataType.STRING, (Object)"insane");
        Assert.assertTrue((boolean)louder.equalsString("louder"));
        Assert.assertTrue((boolean)louder.equalsValue(FieldValueTest.create(DataType.STRING, OpType.CATEGORICAL, "louder")));
        Assert.assertTrue((boolean)louder.equalsValue(FieldValueTest.create(DataType.STRING, OpType.ORDINAL, "louder")));
        louder.setOrdering(null);
        Assert.assertTrue((louder.compareToString("loud") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareToString("louder") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareToString("insane") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareToValue((FieldValue)loud) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareToValue((FieldValue)louder) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareToValue((FieldValue)insane) > 0 ? 1 : 0) != 0);
        louder.setOrdering(Arrays.asList("loud", "louder", "insane"));
        Assert.assertTrue((louder.compareToString("loud") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareToString("louder") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareToString("insane") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareToValue((FieldValue)loud) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareToValue((FieldValue)louder) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareToValue((FieldValue)insane) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void continuousInteger() {
        FieldValue zero = FieldValueTest.create(DataType.INTEGER, OpType.CONTINUOUS, 0);
        Assert.assertTrue((zero.compareToString("-1") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("-1.5") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("0.0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("1") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("1.5") < 0 ? 1 : 0) != 0);
    }

    @Test
    public void categoricalInteger() {
        FieldValue zero = FieldValueTest.create(DataType.INTEGER, OpType.CATEGORICAL, 0);
        try {
            zero.compareToString("0");
            Assert.fail();
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
    }

    @Test
    public void categoricalBoolean() {
        FieldValue zero = FieldValueTest.create(DataType.BOOLEAN, OpType.CATEGORICAL, false);
        FieldValue one = FieldValueTest.create(DataType.BOOLEAN, OpType.CATEGORICAL, true);
        Assert.assertTrue((zero.compareToString("0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("0.0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((one.compareToString("0") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("1") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((one.compareToString("1") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((one.compareToString("1.0") == 0 ? 1 : 0) != 0);
    }

    @Test
    public void categoricalDaysSinceDate() {
        FieldValue period = FieldValueTest.create(DataType.DATE_DAYS_SINCE_1960, OpType.CATEGORICAL, "1960-01-03");
        Assert.assertEquals((Object)2, (Object)period.asInteger());
    }

    @Test
    public void categoricalSecondsSinceDate() {
        FieldValue period = FieldValueTest.create(DataType.DATE_TIME_SECONDS_SINCE_1960, OpType.CATEGORICAL, "1960-01-03T03:30:03");
        Assert.assertEquals((Object)185403, (Object)period.asInteger());
    }

    private static FieldValue create(DataType dataType, OpType opType, Object value) {
        return FieldValueUtil.create((DataType)dataType, (OpType)opType, (Object)value);
    }
}

