/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Sets;
import org.dmg.pmml.Node;
import org.jpmml.evaluator.NodeScoreDistribution;
import org.junit.Assert;
import org.junit.Test;

public class NodeClassificationMapTest {
    @Test
    public void getProbability() {
        Node node = new Node().setScore("ham");
        ImmutableBiMap entityRegistry = ImmutableBiMap.of((Object)"1", (Object)node);
        NodeScoreDistribution classification = new NodeScoreDistribution((BiMap)entityRegistry, node);
        Assert.assertEquals((Object)"1", (Object)classification.getEntityId());
        Assert.assertTrue((boolean)classification.isEmpty());
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"ham"}), (Object)classification.getCategoryValues());
        Assert.assertEquals((Object)1.0, (Object)classification.getProbability("ham"));
        Assert.assertEquals((Object)0.0, (Object)classification.getProbability("spam"));
        classification.put("ham", Double.valueOf(0.75));
        classification.put("spam", Double.valueOf(0.25));
        Assert.assertFalse((boolean)classification.isEmpty());
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"ham", "spam"}), (Object)classification.getCategoryValues());
        Assert.assertEquals((Object)0.75, (Object)classification.getProbability("ham"));
        Assert.assertEquals((Object)0.25, (Object)classification.getProbability("spam"));
    }
}

