/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Map;
import org.dmg.pmml.Array;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.False;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.PMMLManagerTest;
import org.jpmml.evaluator.PredicateUtil;
import org.jpmml.evaluator.VirtualEvaluationContext;
import org.junit.Assert;
import org.junit.Test;

public class PredicateUtilTest {
    @Test
    public void evaluateSimplePredicate() {
        FieldName age = new FieldName("age");
        SimplePredicate simplePredicate = new SimplePredicate(age, SimplePredicate.Operator.IS_MISSING);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, age, 30));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, age, null));
        simplePredicate.setOperator(SimplePredicate.Operator.IS_NOT_MISSING);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, age, 30));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, age, null));
        simplePredicate.setValue("30");
        simplePredicate.setOperator(SimplePredicate.Operator.EQUAL);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, age, 30));
        Assert.assertEquals(null, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, age, null));
        simplePredicate.setOperator(SimplePredicate.Operator.NOT_EQUAL);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, age, 30));
        Assert.assertEquals(null, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, age, null));
        simplePredicate.setOperator(SimplePredicate.Operator.LESS_THAN);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, age, 30));
        simplePredicate.setOperator(SimplePredicate.Operator.LESS_OR_EQUAL);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, age, 30));
        simplePredicate.setOperator(SimplePredicate.Operator.GREATER_OR_EQUAL);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, age, 30));
        simplePredicate.setOperator(SimplePredicate.Operator.GREATER_THAN);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, age, 30));
    }

    @Test
    public void evaluateBooleanSimplePredicate() {
        FieldName flag = new FieldName("flag");
        SimplePredicate simplePredicate = new SimplePredicate(flag, SimplePredicate.Operator.EQUAL).setValue("true");
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, flag, true));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, flag, false));
        simplePredicate.setOperator(SimplePredicate.Operator.NOT_EQUAL);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, flag, true));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, flag, false));
        simplePredicate.setValue("0.5");
        simplePredicate.setOperator(SimplePredicate.Operator.LESS_OR_EQUAL);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, flag, true));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, flag, false));
        simplePredicate.setOperator(SimplePredicate.Operator.GREATER_THAN);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, flag, true));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, flag, false));
    }

    @Test
    public void evaluateSurrogateCompoundPredicate() {
        FieldName temperature = new FieldName("temperature");
        FieldName humidity = new FieldName("humidity");
        CompoundPredicate temperaturePredicate = new CompoundPredicate(CompoundPredicate.BooleanOperator.AND).addPredicates(new Predicate[]{new SimplePredicate(temperature, SimplePredicate.Operator.LESS_THAN).setValue("90"), new SimplePredicate(temperature, SimplePredicate.Operator.GREATER_THAN).setValue("50")});
        SimplePredicate humidityPredicate = new SimplePredicate(humidity, SimplePredicate.Operator.GREATER_OR_EQUAL).setValue("80");
        CompoundPredicate compoundPredicate = new CompoundPredicate(CompoundPredicate.BooleanOperator.SURROGATE).addPredicates(new Predicate[]{temperaturePredicate, humidityPredicate});
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)compoundPredicate, temperature, 70, humidity, null));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)compoundPredicate, temperature, 40, humidity, null));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)compoundPredicate, temperature, 100, humidity, null));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)compoundPredicate, temperature, null, humidity, 90));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)compoundPredicate, temperature, null, humidity, 70));
        Assert.assertEquals(null, (Object)PredicateUtilTest.evaluate((Predicate)compoundPredicate, temperature, null, humidity, null));
    }

    @Test
    public void evaluateBooleanCompoundPredicate() {
        CompoundPredicate compoundPredicate = new CompoundPredicate().addPredicates(new Predicate[]{new True(), new False()});
        compoundPredicate.setBooleanOperator(CompoundPredicate.BooleanOperator.AND);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)compoundPredicate, new Object[0]));
        compoundPredicate.setBooleanOperator(CompoundPredicate.BooleanOperator.OR);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)compoundPredicate, new Object[0]));
        compoundPredicate.setBooleanOperator(CompoundPredicate.BooleanOperator.XOR);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)compoundPredicate, new Object[0]));
    }

    @Test
    public void evaluateSimpleSetPredicate() {
        FieldName fruit = new FieldName("fruit");
        SimpleSetPredicate simpleSetPredicate = new SimpleSetPredicate(fruit, SimpleSetPredicate.BooleanOperator.IS_IN, new Array(Array.Type.STRING, "apple orange"));
        Assert.assertEquals(null, (Object)PredicateUtilTest.evaluate((Predicate)simpleSetPredicate, fruit, null));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)simpleSetPredicate, fruit, "apple"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)simpleSetPredicate, fruit, "pineapple"));
        simpleSetPredicate.setBooleanOperator(SimpleSetPredicate.BooleanOperator.IS_NOT_IN);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)simpleSetPredicate, fruit, "apple"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)simpleSetPredicate, fruit, "pineapple"));
    }

    @Test
    public void evaluateTrue() {
        True truePredicate = new True();
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)truePredicate, new Object[0]));
    }

    @Test
    public void evaluateFalse() {
        False falsePredicate = new False();
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)falsePredicate, new Object[0]));
    }

    @Test
    public void binaryAnd() {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtil.binaryAnd((Boolean)Boolean.TRUE, (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtil.binaryAnd((Boolean)Boolean.TRUE, (Boolean)Boolean.FALSE));
        Assert.assertEquals(null, (Object)PredicateUtil.binaryAnd((Boolean)Boolean.TRUE, null));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtil.binaryAnd((Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtil.binaryAnd((Boolean)Boolean.FALSE, (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtil.binaryAnd((Boolean)Boolean.FALSE, null));
        Assert.assertEquals(null, (Object)PredicateUtil.binaryAnd(null, (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtil.binaryAnd(null, (Boolean)Boolean.FALSE));
        Assert.assertEquals(null, (Object)PredicateUtil.binaryAnd(null, null));
    }

    @Test
    public void binaryOr() {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtil.binaryOr((Boolean)Boolean.TRUE, (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtil.binaryOr((Boolean)Boolean.TRUE, (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtil.binaryOr((Boolean)Boolean.TRUE, null));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtil.binaryOr((Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtil.binaryOr((Boolean)Boolean.FALSE, (Boolean)Boolean.FALSE));
        Assert.assertEquals(null, (Object)PredicateUtil.binaryOr((Boolean)Boolean.FALSE, null));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtil.binaryOr(null, (Boolean)Boolean.TRUE));
        Assert.assertEquals(null, (Object)PredicateUtil.binaryOr(null, (Boolean)Boolean.FALSE));
        Assert.assertEquals(null, (Object)PredicateUtil.binaryOr(null, null));
    }

    @Test
    public void binaryXor() {
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtil.binaryXor((Boolean)Boolean.TRUE, (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtil.binaryXor((Boolean)Boolean.TRUE, (Boolean)Boolean.FALSE));
        Assert.assertEquals(null, (Object)PredicateUtil.binaryXor((Boolean)Boolean.TRUE, null));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtil.binaryXor((Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtil.binaryXor((Boolean)Boolean.FALSE, (Boolean)Boolean.FALSE));
        Assert.assertEquals(null, (Object)PredicateUtil.binaryXor((Boolean)Boolean.FALSE, null));
        Assert.assertEquals(null, (Object)PredicateUtil.binaryXor(null, (Boolean)Boolean.TRUE));
        Assert.assertEquals(null, (Object)PredicateUtil.binaryXor(null, (Boolean)Boolean.FALSE));
        Assert.assertEquals(null, (Object)PredicateUtil.binaryXor(null, null));
    }

    private static Boolean evaluate(Predicate predicate, Object ... objects) {
        Map<FieldName, ?> arguments = PMMLManagerTest.createArguments(objects);
        return PredicateUtilTest.evaluate(predicate, arguments);
    }

    private static Boolean evaluate(Predicate predicate, Map<FieldName, ?> arguments) {
        VirtualEvaluationContext context = new VirtualEvaluationContext();
        context.declareAll(arguments);
        return PredicateUtil.evaluate((Predicate)predicate, (EvaluationContext)context);
    }
}

