/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.visitors;

import java.lang.reflect.Field;
import java.util.List;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Visitable;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.visitors.InvalidFeatureInspector;
import org.jpmml.model.ReflectionUtil;
import org.junit.Assert;
import org.junit.Test;

public class InvalidFeatureInspectorTest {
    @Test
    public void inspect() throws Exception {
        DataDictionary dataDictionary = new DataDictionary().setNumberOfFields(Integer.valueOf(1));
        Field field = ReflectionUtil.getField((Object)dataDictionary, (String)"dataFields");
        Assert.assertNull((Object)ReflectionUtil.getFieldValue((Field)field, (Object)dataDictionary));
        List dataFields = dataDictionary.getDataFields();
        Assert.assertEquals((long)0L, (long)dataFields.size());
        Assert.assertNotNull((Object)ReflectionUtil.getFieldValue((Field)field, (Object)dataDictionary));
        PMML pmml = new PMML(null, null, dataDictionary);
        InvalidFeatureInspector inspector = new InvalidFeatureInspector();
        try {
            inspector.applyTo((Visitable)pmml);
            Assert.fail();
        }
        catch (InvalidFeatureException ife) {
            List exceptions = inspector.getExceptions();
            String[] features = new String[]{"PMML@version", "PMML/Header", "DataDictionary", "DataDictionary/DataField"};
            Assert.assertEquals((long)features.length, (long)exceptions.size());
            for (int i = 0; i < exceptions.size(); ++i) {
                InvalidFeatureException exception = (InvalidFeatureException)((Object)exceptions.get(i));
                Assert.assertEquals((Object)features[i], (Object)exception.getMessage());
            }
            Assert.assertEquals((Object)"PMML@version", (Object)ife.getMessage());
        }
    }
}

