/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.Computable;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.TypeUtil;

public class Classification
implements Computable {
    private Map<String, Double> map = new LinkedHashMap<String, Double>();
    private Object result = null;
    private Type type = null;
    private static final Ordering<Double> BIGGER_IS_BETTER = Ordering.natural();
    private static final Ordering<Double> SMALLER_IS_BETTER = Ordering.natural().reverse();

    protected Classification(Type type) {
        this.setType(type);
    }

    @Override
    public Object getResult() {
        if (this.result == null) {
            throw new EvaluationException();
        }
        return this.result;
    }

    void computeResult(DataType dataType) {
        Map.Entry<String, Double> entry = this.getWinner();
        if (entry == null) {
            throw new EvaluationException();
        }
        Object result = TypeUtil.parseOrCast(dataType, entry.getKey());
        this.setResult(result);
    }

    void setResult(Object result) {
        this.result = result;
    }

    public String toString() {
        Objects.ToStringHelper helper = this.toStringHelper();
        return helper.toString();
    }

    protected Objects.ToStringHelper toStringHelper() {
        Objects.ToStringHelper helper = Objects.toStringHelper((Object)this).add("result", this.getResult()).add(this.getType().entryKey(), this.entrySet());
        return helper;
    }

    Double get(String key) {
        Double value = this.map.get(key);
        if (value == null) {
            Type type = this.getType();
            return type.getDefault();
        }
        return value;
    }

    Double put(String key, Double value) {
        return this.map.put(key, value);
    }

    void putAll(Map<String, Double> values) {
        this.map.putAll(values);
    }

    boolean isEmpty() {
        return this.map.isEmpty();
    }

    Map.Entry<String, Double> getWinner() {
        return Classification.getWinner(this.getType(), this.entrySet());
    }

    List<Map.Entry<String, Double>> getWinnerRanking() {
        return Classification.getWinnerList(this.getType(), this.entrySet());
    }

    List<String> getWinnerKeys() {
        return Classification.entryKeys(this.getWinnerRanking());
    }

    List<Double> getWinnerValues() {
        return Classification.entryValues(this.getWinnerRanking());
    }

    Double sumValues() {
        return Classification.sum(this.map);
    }

    void normalizeValues() {
        Classification.normalize(this.map);
    }

    Set<String> keySet() {
        return this.map.keySet();
    }

    Set<Map.Entry<String, Double>> entrySet() {
        return this.map.entrySet();
    }

    public Type getType() {
        return this.type;
    }

    private void setType(Type type) {
        this.type = type;
    }

    static Map.Entry<String, Double> getWinner(Type type, Collection<Map.Entry<String, Double>> entries) {
        Ordering<Map.Entry<String, Double>> ordering = Classification.createOrdering(type);
        try {
            return (Map.Entry)ordering.max(entries);
        }
        catch (NoSuchElementException nsee) {
            return null;
        }
    }

    static List<Map.Entry<String, Double>> getWinnerList(Type type, Collection<Map.Entry<String, Double>> entries) {
        Ordering ordering = Classification.createOrdering(type).reverse();
        return ordering.sortedCopy(entries);
    }

    static Ordering<Map.Entry<String, Double>> createOrdering(final Type type) {
        Comparator<Map.Entry<String, Double>> comparator = new Comparator<Map.Entry<String, Double>>(){

            @Override
            public int compare(Map.Entry<String, Double> left, Map.Entry<String, Double> right) {
                return type.compare(left.getValue(), right.getValue());
            }
        };
        return Ordering.from((Comparator)comparator);
    }

    public static <K, V> List<K> entryKeys(List<Map.Entry<K, V>> entries) {
        Function function = new Function<Map.Entry<K, V>, K>(){

            public K apply(Map.Entry<K, V> entry) {
                return entry.getKey();
            }
        };
        return Lists.transform(entries, (Function)function);
    }

    public static <K, V> List<V> entryValues(List<Map.Entry<K, V>> entries) {
        Function function = new Function<Map.Entry<K, V>, V>(){

            public V apply(Map.Entry<K, V> entry) {
                return entry.getValue();
            }
        };
        return Lists.transform(entries, (Function)function);
    }

    public static <K> Double sum(Map<K, Double> map) {
        return Classification.sum(map, null);
    }

    private static <K> Double sum(Map<K, Double> map, Function<Double, Double> function) {
        double sum = 0.0;
        Collection<Double> values = map.values();
        for (Double value : values) {
            if (function != null) {
                value = (Double)function.apply((Object)value);
            }
            sum += value.doubleValue();
        }
        return sum;
    }

    public static <K> void normalize(Map<K, Double> map) {
        Classification.normalize(map, null);
    }

    public static <K> void normalizeSoftMax(Map<K, Double> map) {
        Function<Double, Double> function = new Function<Double, Double>(){

            public Double apply(Double value) {
                return Math.exp(value);
            }
        };
        Classification.normalize(map, function);
    }

    private static <K> void normalize(Map<K, Double> map, Function<Double, Double> function) {
        double sum = Classification.sum(map, function);
        Set<Map.Entry<K, Double>> entries = map.entrySet();
        for (Map.Entry entry : entries) {
            Double value = (Double)entry.getValue();
            if (function != null) {
                value = (Double)function.apply((Object)value);
            }
            entry.setValue(value / sum);
        }
    }

    static /* synthetic */ Ordering access$000() {
        return BIGGER_IS_BETTER;
    }

    static /* synthetic */ Ordering access$100() {
        return SMALLER_IS_BETTER;
    }

    public static enum Type implements Comparator<Double>
    {
        PROBABILITY((Ordering<Double>)Classification.access$000(), (Range<Double>)Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0))),
        CONFIDENCE((Ordering<Double>)Classification.access$000(), (Range<Double>)Range.atLeast((Comparable)Double.valueOf(0.0))),
        DISTANCE(Classification.access$100(), Range.atLeast((Comparable)Double.valueOf(0.0))){

            @Override
            public double getDefault() {
                return Double.POSITIVE_INFINITY;
            }
        }
        ,
        SIMILARITY((Ordering<Double>)Classification.access$000(), (Range<Double>)Range.atLeast((Comparable)Double.valueOf(0.0))),
        VOTE((Ordering<Double>)Classification.access$000(), (Range<Double>)Range.atLeast((Comparable)Double.valueOf(0.0)));

        private Ordering<Double> ordering;
        private Range<Double> range;

        private Type(Ordering<Double> ordering, Range<Double> range) {
            this.setOrdering(ordering);
            this.setRange(range);
        }

        @Override
        public int compare(Double left, Double right) {
            if (left == null || right == null) {
                throw new EvaluationException();
            }
            Ordering<Double> ordering = this.getOrdering();
            return ordering.compare((Object)left, (Object)right);
        }

        public double getDefault() {
            return 0.0;
        }

        public boolean isValid(Double value) {
            Range<Double> range = this.getRange();
            return range.contains((Comparable)value);
        }

        protected String entryKey() {
            String name = this.name();
            return name.toLowerCase() + "_entries";
        }

        public Ordering<Double> getOrdering() {
            return this.ordering;
        }

        private void setOrdering(Ordering<Double> ordering) {
            this.ordering = ordering;
        }

        public Range<Double> getRange() {
            return this.range;
        }

        private void setRange(Range<Double> range) {
            this.range = range;
        }
    }
}

