/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collection;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.TypeUtil;

public class ContinuousValue
extends FieldValue {
    ContinuousValue(DataType dataType, Object value) {
        super(dataType, value);
    }

    @Override
    public OpType getOpType() {
        return OpType.CONTINUOUS;
    }

    @Override
    public int compareToString(String string) {
        try {
            return super.compareToString(string);
        }
        catch (NumberFormatException nfeDefault) {
            Object value;
            try {
                value = TypeUtil.parse(DataType.DOUBLE, string);
            }
            catch (NumberFormatException nfeDouble) {
                throw nfeDefault;
            }
            return TypeUtil.compare(DataType.DOUBLE, this.asNumber(), value);
        }
    }

    @Override
    public int compareToValue(FieldValue value) {
        return super.compareToValue(value);
    }

    public static ContinuousValue create(DataType dataType, Object value) {
        if (value instanceof Collection) {
            return new ContinuousValue(dataType, value);
        }
        switch (dataType) {
            case INTEGER: {
                return new ContinuousInteger((Integer)value);
            }
            case FLOAT: {
                return new ContinuousFloat((Float)value);
            }
            case DOUBLE: {
                return new ContinuousDouble((Double)value);
            }
        }
        return new ContinuousValue(dataType, value);
    }

    private static class ContinuousDouble
    extends ContinuousValue
    implements FieldValue.Scalar<Double> {
        ContinuousDouble(Double value) {
            super(DataType.DOUBLE, value);
        }

        @Override
        public Number asNumber() {
            return this.getValue();
        }

        @Override
        public Double getValue() {
            return (Double)super.getValue();
        }
    }

    private static class ContinuousFloat
    extends ContinuousValue
    implements FieldValue.Scalar<Float> {
        ContinuousFloat(Float value) {
            super(DataType.FLOAT, value);
        }

        @Override
        public Number asNumber() {
            return this.getValue();
        }

        @Override
        public Float getValue() {
            return (Float)super.getValue();
        }
    }

    private static class ContinuousInteger
    extends ContinuousValue
    implements FieldValue.Scalar<Integer> {
        ContinuousInteger(Integer value) {
            super(DataType.INTEGER, value);
        }

        @Override
        public Integer asInteger() {
            return this.getValue();
        }

        @Override
        public Number asNumber() {
            return this.getValue();
        }

        @Override
        public Integer getValue() {
            return (Integer)super.getValue();
        }
    }
}

