/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningField;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.ModelEvaluator;

public class ModelEvaluationContext
extends EvaluationContext {
    private ModelEvaluationContext parent = null;
    private ModelEvaluator<?> modelEvaluator = null;
    private boolean compatible = false;

    public ModelEvaluationContext(ModelEvaluationContext parent, ModelEvaluator<?> modelEvaluator) {
        this.setParent(parent);
        this.setModelEvaluator(modelEvaluator);
    }

    @Override
    public FieldValue evaluate(FieldName name) {
        Map.Entry<FieldName, FieldValue> entry = this.getFieldEntry(name);
        if (entry != null) {
            return entry.getValue();
        }
        Iterator<ModelEvaluationContext> parents = this.getCompatibleParents();
        while (parents.hasNext()) {
            ModelEvaluationContext parent = parents.next();
            entry = parent.getFieldEntry(name);
            if (entry == null) continue;
            FieldValue value = entry.getValue();
            this.declare(name, value);
            return value;
        }
        EvaluationContext.Result<DerivedField> result = this.resolveDerivedField(name);
        if (result != null) {
            FieldValue value = ExpressionUtil.evaluate(result.getElement(), (EvaluationContext)this);
            this.declare(name, value);
            parents = this.getCompatibleParents();
            while (parents.hasNext()) {
                ModelEvaluationContext parent = parents.next();
                parent.declare(name, value);
                if (!result.getContext().equals(parent)) continue;
                break;
            }
            return value;
        }
        throw new MissingFieldException(name);
    }

    @Override
    public FieldValue createFieldValue(FieldName name, Object value) {
        ModelEvaluator<?> modelEvaluator = this.getModelEvaluator();
        MiningField miningField = modelEvaluator.getMiningField(name);
        if (miningField == null) {
            throw new EvaluationException();
        }
        return EvaluatorUtil.prepare(modelEvaluator, name, value);
    }

    @Override
    public EvaluationContext.Result<DerivedField> resolveDerivedField(FieldName name) {
        ModelEvaluator<?> modelEvaluator = this.getModelEvaluator();
        DerivedField derivedField = modelEvaluator.getLocalDerivedField(name);
        if (derivedField == null) {
            ModelEvaluationContext parent = this.getParent();
            if (parent != null) {
                return parent.resolveDerivedField(name);
            }
            derivedField = modelEvaluator.getDerivedField(name);
        }
        return this.createResult(derivedField);
    }

    @Override
    public EvaluationContext.Result<DefineFunction> resolveFunction(String name) {
        ModelEvaluator<?> modelEvaluator = this.getModelEvaluator();
        DefineFunction defineFunction = modelEvaluator.getFunction(name);
        return this.createResult(defineFunction);
    }

    Iterator<ModelEvaluationContext> getCompatibleParents() {
        Iterator<ModelEvaluationContext> result = new Iterator<ModelEvaluationContext>(){
            private ModelEvaluationContext parent;
            {
                this.parent = this.getParent(ModelEvaluationContext.this);
            }

            @Override
            public boolean hasNext() {
                return this.parent != null;
            }

            @Override
            public ModelEvaluationContext next() {
                ModelEvaluationContext result = this.parent;
                if (result == null) {
                    throw new NoSuchElementException();
                }
                this.parent = this.getParent(result);
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private ModelEvaluationContext getParent(ModelEvaluationContext context) {
                ModelEvaluationContext parent = context.getParent();
                if (parent != null) {
                    if (!context.isCompatible()) {
                        return null;
                    }
                    return parent;
                }
                return null;
            }
        };
        return result;
    }

    void computeDifference() {
        ModelEvaluationContext parent = this.getParent();
        if (parent != null) {
            this.setCompatible(ModelEvaluationContext.isSubset(this.getFields(), parent.getFields()));
        } else {
            this.setCompatible(false);
        }
    }

    public ModelEvaluationContext getParent() {
        return this.parent;
    }

    private void setParent(ModelEvaluationContext parent) {
        this.parent = parent;
    }

    public ModelEvaluator<?> getModelEvaluator() {
        return this.modelEvaluator;
    }

    private void setModelEvaluator(ModelEvaluator<?> modelEvaluator) {
        this.modelEvaluator = modelEvaluator;
    }

    boolean isCompatible() {
        return this.compatible;
    }

    private void setCompatible(boolean compatible) {
        this.compatible = compatible;
    }

    private static <K, V> boolean isSubset(Map<K, V> left, Map<K, V> right) {
        Set<Map.Entry<K, V>> entries = left.entrySet();
        for (Map.Entry entry : entries) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!right.containsKey(key)) {
                return false;
            }
            boolean equal = Objects.equals(value, right.get(key));
            if (equal) continue;
            return false;
        }
        return true;
    }
}

