/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldUsageType;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Target;
import org.dmg.pmml.Targets;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.TypeDefinitionField;
import org.dmg.pmml.VerificationField;
import org.dmg.pmml.VerificationFields;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.IndexableUtil;
import org.jpmml.evaluator.InlineTableUtil;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelManager;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.VerificationUtil;

public abstract class ModelEvaluator<M extends Model>
extends ModelManager<M>
implements Evaluator {
    private Map<FieldName, DataField> dataFields = Collections.emptyMap();
    private Map<FieldName, DerivedField> derivedFields = Collections.emptyMap();
    private Map<String, DefineFunction> functions = Collections.emptyMap();
    private Map<FieldName, MiningField> miningFields = Collections.emptyMap();
    private ListMultimap<EnumSet<FieldUsageType>, FieldName> miningFieldNames = ImmutableListMultimap.of();
    private Map<FieldName, DerivedField> localDerivedFields = Collections.emptyMap();
    private Map<FieldName, Target> targets = Collections.emptyMap();
    private Map<FieldName, OutputField> outputFields = Collections.emptyMap();
    private static final LoadingCache<DataDictionary, Map<FieldName, DataField>> dataFieldCache = CacheUtil.buildLoadingCache(new CacheLoader<DataDictionary, Map<FieldName, DataField>>(){

        public Map<FieldName, DataField> load(DataDictionary dataDictionary) {
            return IndexableUtil.buildMap(dataDictionary.getDataFields());
        }
    });
    private static final LoadingCache<TransformationDictionary, Map<FieldName, DerivedField>> derivedFieldCache = CacheUtil.buildLoadingCache(new CacheLoader<TransformationDictionary, Map<FieldName, DerivedField>>(){

        public Map<FieldName, DerivedField> load(TransformationDictionary transformationDictionary) {
            return IndexableUtil.buildMap(transformationDictionary.getDerivedFields());
        }
    });
    private static final LoadingCache<TransformationDictionary, Map<String, DefineFunction>> functionCache = CacheUtil.buildLoadingCache(new CacheLoader<TransformationDictionary, Map<String, DefineFunction>>(){

        public Map<String, DefineFunction> load(TransformationDictionary transformationDictionary) {
            return IndexableUtil.buildMap(transformationDictionary.getDefineFunctions());
        }
    });
    private static final LoadingCache<MiningSchema, Map<FieldName, MiningField>> miningFieldCache = CacheUtil.buildLoadingCache(new CacheLoader<MiningSchema, Map<FieldName, MiningField>>(){

        public Map<FieldName, MiningField> load(MiningSchema miningSchema) {
            return IndexableUtil.buildMap(miningSchema.getMiningFields());
        }
    });
    private static final LoadingCache<MiningSchema, ListMultimap<EnumSet<FieldUsageType>, FieldName>> miningFieldNameCache = CacheUtil.buildLoadingCache(new CacheLoader<MiningSchema, ListMultimap<EnumSet<FieldUsageType>, FieldName>>(){

        public ListMultimap<EnumSet<FieldUsageType>, FieldName> load(MiningSchema miningSchema) {
            return ImmutableListMultimap.copyOf((Multimap)ModelEvaluator.parseMiningFieldNames(miningSchema.getMiningFields()));
        }
    });
    private static final LoadingCache<LocalTransformations, Map<FieldName, DerivedField>> localDerivedFieldCache = CacheUtil.buildLoadingCache(new CacheLoader<LocalTransformations, Map<FieldName, DerivedField>>(){

        public Map<FieldName, DerivedField> load(LocalTransformations localTransformations) {
            return IndexableUtil.buildMap(localTransformations.getDerivedFields());
        }
    });
    private static final LoadingCache<Targets, Map<FieldName, Target>> targetCache = CacheUtil.buildLoadingCache(new CacheLoader<Targets, Map<FieldName, Target>>(){

        public Map<FieldName, Target> load(Targets targets) {
            return IndexableUtil.buildMap(targets.getTargets());
        }
    });
    private static final LoadingCache<Output, Map<FieldName, OutputField>> outputFieldCache = CacheUtil.buildLoadingCache(new CacheLoader<Output, Map<FieldName, OutputField>>(){

        public Map<FieldName, OutputField> load(Output output) {
            return IndexableUtil.buildMap(output.getOutputFields());
        }
    });
    private static final LoadingCache<ModelVerification, VerificationBatch> batchCache = CacheUtil.buildLoadingCache(new CacheLoader<ModelVerification, VerificationBatch>(){

        public VerificationBatch load(ModelVerification modelVerification) {
            return ModelEvaluator.parseModelVerification(modelVerification);
        }
    });
    protected static final EnumSet<FieldUsageType> INPUT_TYPES = EnumSet.of(FieldUsageType.ACTIVE, FieldUsageType.GROUP, FieldUsageType.ORDER);

    public ModelEvaluator(PMML pmml, Class<? extends M> clazz) {
        this(pmml, ModelEvaluator.selectModel(pmml, clazz));
    }

    public ModelEvaluator(PMML pmml, M model) {
        super(pmml, model);
        Output output;
        Targets targets;
        LocalTransformations localTransformations;
        MiningSchema miningSchema;
        TransformationDictionary transformationDictionary;
        DataDictionary dataDictionary = pmml.getDataDictionary();
        if (dataDictionary.hasDataFields()) {
            this.dataFields = CacheUtil.getValue(dataDictionary, dataFieldCache);
        }
        if ((transformationDictionary = pmml.getTransformationDictionary()) != null && transformationDictionary.hasDerivedFields()) {
            this.derivedFields = CacheUtil.getValue(transformationDictionary, derivedFieldCache);
        }
        if (transformationDictionary != null && transformationDictionary.hasDefineFunctions()) {
            this.functions = CacheUtil.getValue(transformationDictionary, functionCache);
        }
        if ((miningSchema = model.getMiningSchema()).hasMiningFields()) {
            this.miningFields = CacheUtil.getValue(miningSchema, miningFieldCache);
        }
        if (miningSchema.hasMiningFields()) {
            this.miningFieldNames = CacheUtil.getValue(miningSchema, miningFieldNameCache);
        }
        if ((localTransformations = model.getLocalTransformations()) != null && localTransformations.hasDerivedFields()) {
            this.localDerivedFields = CacheUtil.getValue(localTransformations, localDerivedFieldCache);
        }
        if ((targets = model.getTargets()) != null) {
            this.targets = CacheUtil.getValue(targets, targetCache);
        }
        if ((output = model.getOutput()) != null) {
            this.outputFields = CacheUtil.getValue(output, outputFieldCache);
        }
    }

    public abstract Map<FieldName, ?> evaluate(ModelEvaluationContext var1);

    @Override
    public DataField getDataField(FieldName name) {
        if (name == null) {
            return this.getDataField();
        }
        return this.dataFields.get(name);
    }

    protected DataField getDataField() {
        Object model = this.getModel();
        MiningFunctionType miningFunction = model.getFunctionName();
        switch (miningFunction) {
            case REGRESSION: {
                return new DataField(null, OpType.CONTINUOUS, DataType.DOUBLE);
            }
            case CLASSIFICATION: 
            case CLUSTERING: {
                return new DataField(null, OpType.CATEGORICAL, DataType.STRING);
            }
        }
        return null;
    }

    @Override
    public DerivedField getDerivedField(FieldName name) {
        return this.derivedFields.get(name);
    }

    @Override
    public DefineFunction getFunction(String name) {
        return this.functions.get(name);
    }

    @Override
    public MiningField getMiningField(FieldName name) {
        if (name == null) {
            return null;
        }
        return this.miningFields.get(name);
    }

    @Override
    protected List<FieldName> getMiningFields(EnumSet<FieldUsageType> types) {
        List result = this.miningFieldNames.get(types);
        if (result != null) {
            return result;
        }
        return super.getMiningFields(types);
    }

    @Override
    public DerivedField getLocalDerivedField(FieldName name) {
        return this.localDerivedFields.get(name);
    }

    @Override
    public Target getTarget(FieldName name) {
        if (name == null) {
            return null;
        }
        return this.targets.get(name);
    }

    @Override
    public OutputField getOutputField(FieldName name) {
        return this.outputFields.get(name);
    }

    @Override
    public FieldValue prepare(FieldName name, Object value) {
        DataField dataField = this.getDataField(name);
        MiningField miningField = this.getMiningField(name);
        if (dataField == null || miningField == null) {
            throw new EvaluationException();
        }
        return FieldValueUtil.prepare(dataField, miningField, value);
    }

    @Override
    public void verify() {
        Object model = this.getModel();
        ModelVerification modelVerification = model.getModelVerification();
        if (modelVerification == null) {
            return;
        }
        VerificationBatch batch = CacheUtil.getValue(modelVerification, batchCache);
        List<Map<FieldName, Object>> records = batch.getRecords();
        List<FieldName> activeFields = this.getActiveFields();
        List<FieldName> groupFields = this.getGroupFields();
        if (groupFields.size() == 1) {
            FieldName groupField = groupFields.get(0);
            records = EvaluatorUtil.groupRows(groupField, records);
        } else if (groupFields.size() > 1) {
            throw new EvaluationException();
        }
        List<FieldName> targetFields = this.getTargetFields();
        List<FieldName> outputFields = this.getOutputFields();
        Sets.SetView intersection = Sets.intersection(batch.keySet(), (Set)ImmutableSet.copyOf(outputFields));
        for (Map<FieldName, Object> record : records) {
            VerificationField verificationField;
            HashMap<FieldName, FieldValue> arguments = new HashMap<FieldName, FieldValue>();
            for (FieldName activeField : activeFields) {
                arguments.put(activeField, EvaluatorUtil.prepare(this, activeField, record.get(activeField)));
            }
            Map result = this.evaluate(arguments);
            if (intersection.size() > 0) {
                for (FieldName outputField : outputFields) {
                    verificationField = (VerificationField)batch.get(outputField);
                    if (verificationField == null) continue;
                    this.verify(record.get(outputField), result.get(outputField), verificationField.getPrecision(), verificationField.getZeroThreshold());
                }
                continue;
            }
            for (FieldName targetField : targetFields) {
                verificationField = (VerificationField)batch.get(targetField);
                if (verificationField == null) continue;
                this.verify(record.get(targetField), EvaluatorUtil.decode(result.get(targetField)), verificationField.getPrecision(), verificationField.getZeroThreshold());
            }
        }
    }

    private void verify(Object expected, Object actual, double precision, double zeroThreshold) {
        boolean acceptable;
        if (expected == null) {
            return;
        }
        if (!(actual instanceof Collection)) {
            DataType dataType = TypeUtil.getDataType(actual);
            expected = TypeUtil.parseOrCast(dataType, expected);
        }
        if (!(acceptable = VerificationUtil.acceptable(expected, actual, precision, zeroThreshold))) {
            throw new EvaluationException();
        }
    }

    public ModelEvaluationContext createContext(ModelEvaluationContext parent) {
        return new ModelEvaluationContext(parent, this);
    }

    @Override
    public Map<FieldName, ?> evaluate(Map<FieldName, ?> arguments) {
        List<FieldName> names = this.getMiningFields(INPUT_TYPES);
        ModelEvaluationContext context = this.createContext(null);
        context.declareAll(names, arguments);
        return this.evaluate(context);
    }

    TypeDefinitionField resolveField(FieldName name) {
        DataField result = this.getDataField(name);
        if (result == null) {
            result = this.resolveDerivedField(name);
        }
        return result;
    }

    DerivedField resolveDerivedField(FieldName name) {
        DerivedField result = this.getDerivedField(name);
        if (result == null) {
            result = this.getLocalDerivedField(name);
        }
        return result;
    }

    public <V> V getValue(LoadingCache<M, V> cache) {
        Object model = this.getModel();
        return CacheUtil.getValue(model, cache);
    }

    public <V> V getValue(Callable<? extends V> loader, Cache<M, V> cache) {
        Object model = this.getModel();
        return CacheUtil.getValue(model, loader, cache);
    }

    private static <M extends Model> M selectModel(PMML pmml, Class<? extends M> clazz) {
        List models = pmml.getModels();
        Iterable filteredModels = Iterables.filter((Iterable)models, clazz);
        Model model = (Model)Iterables.getFirst((Iterable)filteredModels, null);
        if (model == null) {
            throw new InvalidFeatureException((PMMLObject)pmml);
        }
        return (M)model;
    }

    private static ListMultimap<EnumSet<FieldUsageType>, FieldName> parseMiningFieldNames(List<MiningField> miningFields) {
        LinkedHashSet<EnumSet> keys = new LinkedHashSet<EnumSet>();
        keys.addAll(Arrays.asList(ModelManager.ACTIVE_TYPES, ModelManager.GROUP_TYPES, ModelManager.ORDER_TYPES, ModelManager.TARGET_TYPES));
        keys.addAll(Arrays.asList(INPUT_TYPES));
        ArrayListMultimap result = ArrayListMultimap.create();
        for (MiningField miningField : miningFields) {
            for (EnumSet key : keys) {
                if (!key.contains(miningField.getUsageType())) continue;
                result.put((Object)key, (Object)miningField.getName());
            }
        }
        return result;
    }

    private static VerificationBatch parseModelVerification(ModelVerification modelVerification) {
        VerificationBatch result = new VerificationBatch();
        VerificationFields verificationFields = modelVerification.getVerificationFields();
        if (verificationFields == null) {
            throw new InvalidFeatureException((PMMLObject)modelVerification);
        }
        for (VerificationField verificationField : verificationFields) {
            result.put(FieldName.create((String)verificationField.getField()), verificationField);
        }
        InlineTable inlineTable = modelVerification.getInlineTable();
        if (inlineTable == null) {
            throw new InvalidFeatureException((PMMLObject)modelVerification);
        }
        Table<Integer, String, String> table = InlineTableUtil.getContent(inlineTable);
        ArrayList records = new ArrayList();
        Set rowKeys = table.rowKeySet();
        for (Integer rowKey : rowKeys) {
            Map row = table.row((Object)rowKey);
            LinkedHashMap record = new LinkedHashMap();
            for (VerificationField verificationField : verificationFields) {
                String field = verificationField.getField();
                String column = verificationField.getColumn();
                if (column == null) {
                    column = field;
                }
                if (!row.containsKey(column)) continue;
                record.put(FieldName.create((String)field), row.get(column));
            }
            records.add(record);
        }
        Integer recordCount = modelVerification.getRecordCount();
        if (recordCount != null && recordCount.intValue() != records.size()) {
            throw new InvalidFeatureException((PMMLObject)inlineTable);
        }
        result.setRecords(records);
        return result;
    }

    private static class VerificationBatch
    extends LinkedHashMap<FieldName, VerificationField> {
        private List<Map<FieldName, Object>> records = null;

        private VerificationBatch() {
        }

        public List<Map<FieldName, Object>> getRecords() {
            return this.records;
        }

        private void setRecords(List<Map<FieldName, Object>> records) {
            this.records = records;
        }
    }
}

