/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.PMMLObject;
import org.xml.sax.Locator;

public abstract class PMMLException
extends RuntimeException {
    private PMMLObject context = null;

    public PMMLException() {
    }

    public PMMLException(String message) {
        super(message);
    }

    public PMMLException(PMMLObject context) {
        this.setContext(context);
    }

    public PMMLException(String message, PMMLObject context) {
        super(message);
        this.setContext(context);
    }

    void ensureContext(PMMLObject parentContext) {
        PMMLObject context = this.getContext();
        if (context == null) {
            this.setContext(parentContext);
        }
    }

    @Override
    public String toString() {
        String message;
        StringBuilder sb = new StringBuilder();
        Class<?> clazz = this.getClass();
        sb.append(clazz.getName());
        PMMLObject context = this.getContext();
        if (context != null) {
            int lineNumber = -1;
            Locator locator = context.getLocator();
            if (locator != null) {
                lineNumber = locator.getLineNumber();
            }
            if (lineNumber != -1) {
                sb.append(" ").append("(at or around line ").append(lineNumber).append(")");
            }
        }
        if ((message = this.getLocalizedMessage()) != null) {
            sb.append(":");
            sb.append(" ").append(message);
        }
        return sb.toString();
    }

    public PMMLObject getContext() {
        return this.context;
    }

    private void setContext(PMMLObject context) {
        this.context = context;
    }
}

