/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.visitors;

import java.util.Arrays;
import java.util.HashMap;
import org.dmg.pmml.Array;
import org.dmg.pmml.False;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.Visitable;
import org.jpmml.evaluator.ArrayUtil;
import org.jpmml.model.visitors.PredicateFilterer;

public class PredicateInterner
extends PredicateFilterer {
    private ElementHashMap<SimplePredicate> simplePredicateCache = new ElementHashMap<SimplePredicate>(){

        @Override
        public ElementKey createKey(SimplePredicate simplePredicate) {
            Object[] content = new Object[]{simplePredicate.getField(), simplePredicate.getOperator(), simplePredicate.getValue()};
            return new ElementKey(content);
        }
    };
    private ElementHashMap<SimpleSetPredicate> simpleSetPredicateCache = new ElementHashMap<SimpleSetPredicate>(){

        @Override
        public ElementKey createKey(SimpleSetPredicate simpleSetPredicate) {
            Array array = simpleSetPredicate.getArray();
            Object[] content = new Object[]{simpleSetPredicate.getField(), simpleSetPredicate.getBooleanOperator(), ArrayUtil.getContent(array)};
            return new ElementKey(content);
        }
    };
    private ElementHashMap<True> truePredicateCache = new ElementHashMap<True>(){

        @Override
        public ElementKey createKey(True truePredicate) {
            return ElementKey.EMPTY;
        }
    };
    private ElementHashMap<False> falsePredicateCache = new ElementHashMap<False>(){

        @Override
        public ElementKey createKey(False falsePredicate) {
            return ElementKey.EMPTY;
        }
    };

    public Predicate filter(Predicate predicate) {
        return this.intern(predicate);
    }

    public void applyTo(Visitable visitable) {
        this.reset();
        super.applyTo(visitable);
    }

    public void reset() {
        this.simplePredicateCache.clear();
        this.simpleSetPredicateCache.clear();
        this.truePredicateCache.clear();
        this.falsePredicateCache.clear();
    }

    public Predicate intern(Predicate predicate) {
        if (predicate != null && predicate.hasExtensions()) {
            return predicate;
        }
        if (predicate instanceof SimplePredicate) {
            return this.intern((SimplePredicate)predicate);
        }
        if (predicate instanceof SimpleSetPredicate) {
            return this.intern((SimpleSetPredicate)predicate);
        }
        if (predicate instanceof True) {
            return this.intern((True)predicate);
        }
        if (predicate instanceof False) {
            return this.intern((False)predicate);
        }
        return predicate;
    }

    private SimplePredicate intern(SimplePredicate simplePredicate) {
        return this.simplePredicateCache.intern(simplePredicate);
    }

    private SimpleSetPredicate intern(SimpleSetPredicate simpleSetPredicate) {
        return this.simpleSetPredicateCache.intern(simpleSetPredicate);
    }

    private True intern(True truePredicate) {
        return this.truePredicateCache.intern(truePredicate);
    }

    private False intern(False falsePredicate) {
        return this.falsePredicateCache.intern(falsePredicate);
    }

    private static abstract class ElementHashMap<E extends PMMLObject>
    extends HashMap<ElementKey, E> {
        private ElementHashMap() {
        }

        public abstract ElementKey createKey(E var1);

        public E intern(E object) {
            ElementKey key = this.createKey(object);
            Object value = (PMMLObject)this.get(key);
            if (value == null) {
                value = object;
                this.put(key, value);
            }
            return (E)value;
        }
    }

    private static class ElementKey {
        private Object[] content = null;
        public static final ElementKey EMPTY = new ElementKey(new Object[0]);

        private ElementKey(Object[] content) {
            this.setContent(content);
        }

        public int hashCode() {
            Object[] content = this.getContent();
            return Arrays.hashCode(content);
        }

        public boolean equals(Object object) {
            if (object instanceof ElementKey) {
                ElementKey that = (ElementKey)object;
                return Arrays.equals(this.getContent(), that.getContent());
            }
            return false;
        }

        public Object[] getContent() {
            return this.content;
        }

        private void setContent(Object[] content) {
            this.content = content;
        }
    }
}

