/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Range;
import org.dmg.pmml.Interval;
import org.jpmml.evaluator.DiscretizationUtil;
import org.junit.Assert;
import org.junit.Test;

public class DiscretizationUtilTest {
    @Test
    public void boundedRange() {
        Range<Double> open = DiscretizationUtilTest.toRange(Interval.Closure.OPEN_OPEN, -1.0, 1.0);
        Assert.assertFalse((boolean)open.contains((Comparable)Double.valueOf(-1.7976931348623157E308)));
        Assert.assertFalse((boolean)open.contains((Comparable)Double.valueOf(-1.0)));
        Assert.assertTrue((boolean)open.contains((Comparable)Double.valueOf(0.0)));
        Assert.assertFalse((boolean)open.contains((Comparable)Double.valueOf(1.0)));
        Assert.assertFalse((boolean)open.contains((Comparable)Double.valueOf(Double.MAX_VALUE)));
        Range<Double> openClosed = DiscretizationUtilTest.toRange(Interval.Closure.OPEN_CLOSED, -1.0, 1.0);
        Assert.assertFalse((boolean)openClosed.contains((Comparable)Double.valueOf(-1.7976931348623157E308)));
        Assert.assertFalse((boolean)openClosed.contains((Comparable)Double.valueOf(-1.0)));
        Assert.assertTrue((boolean)openClosed.contains((Comparable)Double.valueOf(0.0)));
        Assert.assertTrue((boolean)openClosed.contains((Comparable)Double.valueOf(1.0)));
        Assert.assertFalse((boolean)openClosed.contains((Comparable)Double.valueOf(Double.MAX_VALUE)));
        Range<Double> closedOpen = DiscretizationUtilTest.toRange(Interval.Closure.CLOSED_OPEN, -1.0, 1.0);
        Assert.assertFalse((boolean)closedOpen.contains((Comparable)Double.valueOf(-1.7976931348623157E308)));
        Assert.assertTrue((boolean)closedOpen.contains((Comparable)Double.valueOf(-1.0)));
        Assert.assertTrue((boolean)closedOpen.contains((Comparable)Double.valueOf(0.0)));
        Assert.assertFalse((boolean)closedOpen.contains((Comparable)Double.valueOf(1.0)));
        Assert.assertFalse((boolean)closedOpen.contains((Comparable)Double.valueOf(Double.MAX_VALUE)));
        Range<Double> closed = DiscretizationUtilTest.toRange(Interval.Closure.CLOSED_CLOSED, -1.0, 1.0);
        Assert.assertFalse((boolean)closed.contains((Comparable)Double.valueOf(-1.7976931348623157E308)));
        Assert.assertTrue((boolean)closed.contains((Comparable)Double.valueOf(-1.0)));
        Assert.assertTrue((boolean)closed.contains((Comparable)Double.valueOf(0.0)));
        Assert.assertTrue((boolean)closed.contains((Comparable)Double.valueOf(1.0)));
        Assert.assertFalse((boolean)closed.contains((Comparable)Double.valueOf(Double.MAX_VALUE)));
    }

    @Test
    public void unboundedRange() {
        Range<Double> lessThan = DiscretizationUtilTest.toRange(Interval.Closure.OPEN_OPEN, null, 0.0);
        Assert.assertTrue((boolean)lessThan.contains((Comparable)Double.valueOf(-1.7976931348623157E308)));
        Assert.assertFalse((boolean)lessThan.contains((Comparable)Double.valueOf(0.0)));
        Assert.assertFalse((boolean)lessThan.contains((Comparable)Double.valueOf(Double.MAX_VALUE)));
        Range<Double> atMost = DiscretizationUtilTest.toRange(Interval.Closure.OPEN_CLOSED, null, 0.0);
        Assert.assertTrue((boolean)atMost.contains((Comparable)Double.valueOf(-1.7976931348623157E308)));
        Assert.assertTrue((boolean)atMost.contains((Comparable)Double.valueOf(0.0)));
        Assert.assertFalse((boolean)atMost.contains((Comparable)Double.valueOf(Double.MAX_VALUE)));
        Range<Double> greaterThan = DiscretizationUtilTest.toRange(Interval.Closure.OPEN_OPEN, 0.0, null);
        Assert.assertFalse((boolean)greaterThan.contains((Comparable)Double.valueOf(-1.7976931348623157E308)));
        Assert.assertFalse((boolean)greaterThan.contains((Comparable)Double.valueOf(0.0)));
        Assert.assertTrue((boolean)greaterThan.contains((Comparable)Double.valueOf(Double.MAX_VALUE)));
        Range<Double> atLeast = DiscretizationUtilTest.toRange(Interval.Closure.CLOSED_OPEN, 0.0, null);
        Assert.assertFalse((boolean)atLeast.contains((Comparable)Double.valueOf(-1.7976931348623157E308)));
        Assert.assertTrue((boolean)atLeast.contains((Comparable)Double.valueOf(0.0)));
        Assert.assertTrue((boolean)atLeast.contains((Comparable)Double.valueOf(Double.MAX_VALUE)));
    }

    private static Range<Double> toRange(Interval.Closure closure, Double leftMargin, Double rightMargin) {
        return DiscretizationUtil.toRange((Interval)DiscretizationUtilTest.createInterval(closure, leftMargin, rightMargin));
    }

    private static Interval createInterval(Interval.Closure closure, Double leftMargin, Double rightMargin) {
        Interval result = new Interval(closure).setLeftMargin(leftMargin).setRightMargin(rightMargin);
        return result;
    }
}

