/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldUsageType;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Target;
import org.dmg.pmml.Targets;
import org.jpmml.evaluator.Consumer;
import org.jpmml.evaluator.IndexableUtil;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.PMMLManager;

public class ModelManager<M extends Model>
extends PMMLManager
implements Consumer {
    private M model = null;
    protected static final EnumSet<FieldUsageType> ACTIVE_TYPES = EnumSet.of(FieldUsageType.ACTIVE);
    protected static final EnumSet<FieldUsageType> GROUP_TYPES = EnumSet.of(FieldUsageType.GROUP);
    protected static final EnumSet<FieldUsageType> ORDER_TYPES = EnumSet.of(FieldUsageType.ORDER);
    protected static final EnumSet<FieldUsageType> TARGET_TYPES = EnumSet.of(FieldUsageType.PREDICTED, FieldUsageType.TARGET);

    public ModelManager(PMML pmml, M model) {
        super(pmml);
        this.setModel((Model)Objects.requireNonNull(model));
        MiningSchema miningSchema = model.getMiningSchema();
        if (miningSchema == null) {
            throw new InvalidFeatureException((PMMLObject)model);
        }
    }

    @Override
    public String getSummary() {
        return null;
    }

    @Override
    public MiningFunctionType getMiningFunction() {
        M model = this.getModel();
        return model.getFunctionName();
    }

    @Override
    public List<FieldName> getActiveFields() {
        return this.getMiningFields(ACTIVE_TYPES);
    }

    @Override
    public List<FieldName> getGroupFields() {
        return this.getMiningFields(GROUP_TYPES);
    }

    @Override
    public List<FieldName> getOrderFields() {
        return this.getMiningFields(ORDER_TYPES);
    }

    @Override
    public List<FieldName> getTargetFields() {
        return this.getMiningFields(TARGET_TYPES);
    }

    @Override
    public FieldName getTargetField() {
        M model = this.getModel();
        List<FieldName> targetFields = this.getTargetFields();
        if (targetFields.size() < 1) {
            return null;
        }
        if (targetFields.size() > 1) {
            MiningSchema miningSchema = model.getMiningSchema();
            throw new InvalidFeatureException("Too many target fields", (PMMLObject)miningSchema);
        }
        return targetFields.get(0);
    }

    @Override
    public MiningField getMiningField(FieldName name) {
        M model = this.getModel();
        MiningSchema miningSchema = model.getMiningSchema();
        return (MiningField)IndexableUtil.find(miningSchema.getMiningFields(), name);
    }

    protected List<FieldName> getMiningFields(EnumSet<FieldUsageType> fieldUsageTypes) {
        M model = this.getModel();
        MiningSchema miningSchema = model.getMiningSchema();
        ArrayList<FieldName> result = new ArrayList<FieldName>();
        List miningFields = miningSchema.getMiningFields();
        for (MiningField miningField : miningFields) {
            FieldUsageType fieldUsageType = miningField.getUsageType();
            if (!fieldUsageTypes.contains(fieldUsageType)) continue;
            result.add(miningField.getName());
        }
        return result;
    }

    public DerivedField getLocalDerivedField(FieldName name) {
        M model = this.getModel();
        LocalTransformations localTransformations = model.getLocalTransformations();
        if (localTransformations != null && localTransformations.hasDerivedFields()) {
            return (DerivedField)IndexableUtil.find(localTransformations.getDerivedFields(), name);
        }
        return null;
    }

    @Override
    public Target getTarget(FieldName name) {
        M model = this.getModel();
        Targets targets = model.getTargets();
        if (targets != null) {
            return (Target)IndexableUtil.find(targets.getTargets(), name);
        }
        return null;
    }

    @Override
    public List<FieldName> getOutputFields() {
        M model = this.getModel();
        Output output = model.getOutput();
        if (output == null) {
            return Collections.emptyList();
        }
        ArrayList<FieldName> result = new ArrayList<FieldName>();
        List outputFields = output.getOutputFields();
        for (OutputField outputField : outputFields) {
            result.add(outputField.getName());
        }
        return result;
    }

    @Override
    public OutputField getOutputField(FieldName name) {
        M model = this.getModel();
        Output output = model.getOutput();
        if (output != null) {
            return (OutputField)IndexableUtil.find(output.getOutputFields(), name);
        }
        return null;
    }

    public M getModel() {
        return this.model;
    }

    private void setModel(M model) {
        this.model = model;
    }
}

