/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.PMML;
import org.jpmml.evaluator.Batch;
import org.jpmml.evaluator.BatchUtil;
import org.jpmml.evaluator.CsvUtil;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.model.ImportFilter;
import org.jpmml.model.JAXBUtil;
import org.xml.sax.InputSource;

public abstract class ArchiveBatch
implements Batch {
    private String name = null;
    private String dataset = null;

    public ArchiveBatch(String name, String dataset) {
        this.setName(name);
        this.setDataset(dataset);
    }

    public abstract InputStream open(String var1);

    public Evaluator getEvaluator() throws Exception {
        PMML pmml = this.getPMML();
        ModelEvaluatorFactory modelEvaluatorFactory = ModelEvaluatorFactory.newInstance();
        ModelEvaluator modelEvaluator = (ModelEvaluator)modelEvaluatorFactory.newModelManager(pmml);
        modelEvaluator.verify();
        return modelEvaluator;
    }

    public PMML getPMML() throws Exception {
        return this.loadPMML("/pmml/" + this.getName() + this.getDataset() + ".pmml");
    }

    public List<Map<FieldName, String>> getInput() throws IOException {
        return this.loadRecords("/csv/" + this.getDataset() + ".csv");
    }

    public List<Map<FieldName, String>> getOutput() throws IOException {
        return this.loadRecords("/csv/" + this.getName() + this.getDataset() + ".csv");
    }

    public void close() throws Exception {
    }

    private PMML loadPMML(String path) throws Exception {
        try (InputStream is = this.open(path);){
            SAXSource source = ImportFilter.apply((InputSource)new InputSource(is));
            PMML pMML = JAXBUtil.unmarshalPMML((Source)source);
            return pMML;
        }
    }

    private List<Map<FieldName, String>> loadRecords(String path) throws IOException {
        CsvUtil.Table table;
        try (InputStream is = this.open(path);){
            table = CsvUtil.readTable((InputStream)is, (String)",");
        }
        Function<String, String> function = new Function<String, String>(){

            public String apply(String string) {
                if ("N/A".equals(string) || "NA".equals(string)) {
                    return null;
                }
                return string;
            }
        };
        return BatchUtil.parseRecords((List)table, (Function)function);
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    public String getDataset() {
        return this.dataset;
    }

    private void setDataset(String dataset) {
        this.dataset = dataset;
    }
}

