/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.Computable;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.MixedNeighborhoodTest;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelEvaluatorTest;
import org.jpmml.evaluator.RankingTest;
import org.jpmml.evaluator.StandardAssociationSchemaTest;
import org.junit.Assert;
import org.junit.Test;

public class EvaluatorUtilTest {
    @Test
    public void decode() {
        Assert.assertEquals(null, (Object)EvaluatorUtil.decode((Object)null));
        Computable value = new Computable(){

            public String getResult() {
                return "value";
            }
        };
        Assert.assertEquals((Object)"value", (Object)EvaluatorUtil.decode((Object)value));
        Assert.assertEquals(Arrays.asList("value"), (Object)EvaluatorUtil.decode(Arrays.asList(value)));
        Assert.assertEquals(Arrays.asList("value", "value"), (Object)EvaluatorUtil.decode(Arrays.asList(value, value)));
        Assert.assertEquals(Collections.singletonMap(null, "value"), (Object)EvaluatorUtil.decode(Collections.singletonMap(null, value)));
        Assert.assertEquals(Collections.singletonMap("key", "value"), (Object)EvaluatorUtil.decode(Collections.singletonMap(FieldName.create((String)"key"), value)));
        Computable invalidValue = new Computable(){

            public Object getResult() {
                throw new UnsupportedOperationException();
            }
        };
        try {
            EvaluatorUtil.decode((Object)invalidValue);
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertEquals(Collections.emptyMap(), (Object)EvaluatorUtil.decode(Collections.singletonMap(null, invalidValue)));
        Assert.assertEquals(Collections.emptyMap(), (Object)EvaluatorUtil.decode(Collections.singletonMap(FieldName.create((String)"key"), invalidValue)));
    }

    @Test
    public void prepare() throws Exception {
        ModelEvaluator<?> evaluator = ModelEvaluatorTest.createModelEvaluator(StandardAssociationSchemaTest.class);
        FieldValue simple = EvaluatorUtil.prepare(evaluator, (FieldName)FieldName.create((String)"item"), (Object)"Cracker");
        Assert.assertEquals((Object)"Cracker", (Object)simple.getValue());
        Assert.assertEquals((Object)DataType.STRING, (Object)simple.getDataType());
        Assert.assertEquals((Object)OpType.CATEGORICAL, (Object)simple.getOpType());
        FieldValue collection = EvaluatorUtil.prepare(evaluator, (FieldName)FieldName.create((String)"item"), Arrays.asList("Cracker", "Water", "Coke"));
        Assert.assertEquals(Arrays.asList("Cracker", "Water", "Coke"), (Object)collection.getValue());
        Assert.assertEquals((Object)DataType.STRING, (Object)collection.getDataType());
        Assert.assertEquals((Object)OpType.CATEGORICAL, (Object)collection.getOpType());
    }

    @Test
    public void groupRows() {
        List table = new ArrayList<Map<FieldName, Object>>();
        table.add(EvaluatorUtilTest.createRow("1", "Cracker"));
        table.add(EvaluatorUtilTest.createRow("2", "Cracker"));
        table.add(EvaluatorUtilTest.createRow("1", "Coke"));
        table.add(EvaluatorUtilTest.createRow("3", "Cracker"));
        table.add(EvaluatorUtilTest.createRow("3", "Water"));
        table.add(EvaluatorUtilTest.createRow("3", "Coke"));
        table.add(EvaluatorUtilTest.createRow("2", "Water"));
        table = EvaluatorUtil.groupRows((Object)FieldName.create((String)"transaction"), table);
        EvaluatorUtilTest.checkGroupedRow((Map)table.get(0), "1", Arrays.asList("Cracker", "Coke"));
        EvaluatorUtilTest.checkGroupedRow((Map)table.get(1), "2", Arrays.asList("Cracker", "Water"));
        EvaluatorUtilTest.checkGroupedRow((Map)table.get(2), "3", Arrays.asList("Cracker", "Water", "Coke"));
    }

    @Test
    public void getTargetFields() throws Exception {
        ModelEvaluator<?> evaluator = ModelEvaluatorTest.createModelEvaluator(MixedNeighborhoodTest.class);
        Assert.assertEquals(Arrays.asList(FieldName.create((String)"species"), FieldName.create((String)"species_class")), (Object)EvaluatorUtil.getTargetFields(evaluator));
        evaluator = ModelEvaluatorTest.createModelEvaluator(RankingTest.class);
        Assert.assertEquals(Collections.singletonList(null), (Object)EvaluatorUtil.getTargetFields(evaluator));
        evaluator = ModelEvaluatorTest.createModelEvaluator(StandardAssociationSchemaTest.class);
        Assert.assertEquals(Collections.emptyList(), (Object)EvaluatorUtil.getTargetFields(evaluator));
    }

    private static Map<FieldName, Object> createRow(String transaction, String item) {
        HashMap<FieldName, Object> result = new HashMap<FieldName, Object>();
        result.put(FieldName.create((String)"transaction"), transaction);
        result.put(FieldName.create((String)"item"), item);
        return result;
    }

    private static void checkGroupedRow(Map<FieldName, Object> row, String transaction, List<String> items) {
        Assert.assertEquals((long)2L, (long)row.size());
        Assert.assertEquals((Object)transaction, (Object)row.get(FieldName.create((String)"transaction")));
        Assert.assertEquals(items, (Object)row.get(FieldName.create((String)"item")));
    }
}

