/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Visitable;
import org.jpmml.evaluator.ArchiveBatch;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.IntegrationTest;
import org.jpmml.model.visitors.LocatorTransformer;

public abstract class IntegrationTestBatch
extends ArchiveBatch {
    private Evaluator evaluator = null;

    public IntegrationTestBatch(String name, String dataset) {
        super(name, dataset);
    }

    public abstract IntegrationTest getIntegrationTest();

    @Override
    public InputStream open(String path) {
        IntegrationTest integrationTest = this.getIntegrationTest();
        Class<?> clazz = integrationTest.getClass();
        return clazz.getResourceAsStream(path);
    }

    @Override
    public PMML getPMML() throws Exception {
        PMML pmml = super.getPMML();
        LocatorTransformer locatorTransformer = new LocatorTransformer();
        locatorTransformer.applyTo((Visitable)pmml);
        return pmml;
    }

    @Override
    public Evaluator getEvaluator() throws Exception {
        if (this.evaluator == null) {
            Evaluator evaluator = super.getEvaluator();
            IntegrationTestBatch.ensureSerializability(evaluator);
            this.evaluator = evaluator;
        }
        return this.evaluator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        if (this.evaluator != null) {
            try {
                IntegrationTestBatch.ensureSerializability(this.evaluator);
            }
            finally {
                this.evaluator = null;
            }
        }
    }

    private static void ensureSerializability(Evaluator evaluator) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(ByteStreams.nullOutputStream());){
            oos.writeObject(evaluator);
        }
    }
}

