/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.FieldScopeTest;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelEvaluatorTest;
import org.junit.Assert;
import org.junit.Test;

public class ModelEvaluationContextTest
extends ModelEvaluatorTest {
    @Test
    public void evaluate() throws Exception {
        ModelEvaluator<?> evaluator = ModelEvaluationContextTest.createModelEvaluator(FieldScopeTest.class);
        FieldName input = FieldName.create((String)"input");
        ModelEvaluationContext parentContext = new ModelEvaluationContext(null, evaluator);
        parentContext.declare(input, (Object)1.0);
        Assert.assertEquals(Collections.emptyList(), (Object)Lists.newArrayList((Iterator)parentContext.getCompatibleParents()));
        ModelEvaluationContext childContext = new ModelEvaluationContext(parentContext, evaluator);
        childContext.declare(input, (Object)0.0);
        childContext.setCompatible(false);
        Assert.assertEquals(Collections.emptyList(), (Object)Lists.newArrayList((Iterator)childContext.getCompatibleParents()));
        ModelEvaluationContext grandChildContext = new ModelEvaluationContext(childContext, evaluator);
        grandChildContext.declare(input, (Object)0.0);
        grandChildContext.setCompatible(true);
        Assert.assertEquals(Collections.singletonList(childContext), (Object)Lists.newArrayList((Iterator)grandChildContext.getCompatibleParents()));
        FieldName squaredInput = FieldName.create((String)"squaredInput");
        FieldValue squaredInputValue = childContext.evaluate(squaredInput);
        Assert.assertNull((Object)parentContext.getFieldEntry(squaredInput));
        Assert.assertNotNull((Object)childContext.getFieldEntry(squaredInput));
        Assert.assertNull((Object)grandChildContext.getFieldEntry(squaredInput));
        Assert.assertNotSame((Object)squaredInputValue, (Object)parentContext.evaluate(squaredInput));
        Assert.assertSame((Object)squaredInputValue, (Object)childContext.evaluate(squaredInput));
        Assert.assertSame((Object)squaredInputValue, (Object)grandChildContext.evaluate(squaredInput));
        FieldName cubedInput = FieldName.create((String)"cubedInput");
        FieldValue cubedInputValue = grandChildContext.evaluate(cubedInput);
        Assert.assertNull((Object)parentContext.getFieldEntry(cubedInput));
        Assert.assertNotNull((Object)childContext.getFieldEntry(cubedInput));
        Assert.assertNotNull((Object)grandChildContext.getFieldEntry(cubedInput));
        Assert.assertNotSame((Object)cubedInputValue, (Object)parentContext.evaluate(cubedInput));
        Assert.assertSame((Object)cubedInputValue, (Object)childContext.evaluate(cubedInput));
        Assert.assertSame((Object)cubedInputValue, (Object)grandChildContext.evaluate(cubedInput));
    }
}

