/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.PMML;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.PMMLManager;
import org.jpmml.model.ImportFilter;
import org.jpmml.model.JAXBUtil;
import org.xml.sax.InputSource;

public abstract class PMMLManagerTest {
    public PMMLManager createPMMLManager() throws Exception {
        return PMMLManagerTest.createPMMLManager(this.getClass());
    }

    public static PMMLManager createPMMLManager(Class<? extends PMMLManagerTest> clazz) throws Exception {
        try (InputStream is = PMMLManagerTest.getInputStream(clazz);){
            PMMLManager pMMLManager = PMMLManagerTest.createPMMLManager(is);
            return pMMLManager;
        }
    }

    public static PMMLManager createPMMLManager(InputStream is) throws Exception {
        PMML pmml = PMMLManagerTest.loadPMML(is);
        PMMLManager pmmlManager = new PMMLManager(pmml);
        return pmmlManager;
    }

    public static Map<FieldName, ?> createArguments(Object ... objects) {
        HashMap<FieldName, Object> result = new HashMap<FieldName, Object>();
        if (objects.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < objects.length / 2; ++i) {
            Object key = objects[i * 2];
            Object value = objects[i * 2 + 1];
            result.put(PMMLManagerTest.toFieldName(key), value);
        }
        return result;
    }

    public static Object getTarget(Map<FieldName, ?> result, Object name) {
        Object value = result.get(PMMLManagerTest.toFieldName(name));
        return EvaluatorUtil.decode(value);
    }

    public static Object getOutput(Map<FieldName, ?> result, Object name) {
        Object value = result.get(PMMLManagerTest.toFieldName(name));
        return value;
    }

    public static InputStream getInputStream(Class<? extends PMMLManagerTest> clazz) {
        return clazz.getResourceAsStream("/pmml/" + clazz.getSimpleName() + ".pmml");
    }

    public static PMML loadPMML(InputStream is) throws Exception {
        SAXSource source = ImportFilter.apply((InputSource)new InputSource(is));
        return JAXBUtil.unmarshalPMML((Source)source);
    }

    private static FieldName toFieldName(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            return FieldName.create((String)string);
        }
        return (FieldName)object;
    }
}

