/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.util.Precision;
import org.dmg.pmml.BayesInput;
import org.dmg.pmml.BayesInputs;
import org.dmg.pmml.BayesOutput;
import org.dmg.pmml.ContinuousDistribution;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.GaussianDistribution;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.NaiveBayesModel;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.PairCounts;
import org.dmg.pmml.PoissonDistribution;
import org.dmg.pmml.TargetValueCount;
import org.dmg.pmml.TargetValueCounts;
import org.dmg.pmml.TargetValueStat;
import org.dmg.pmml.TargetValueStats;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.DiscretizationUtil;
import org.jpmml.evaluator.DistributionUtil;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.HasParsedValueMapping;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.ProbabilityDistribution;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;
import org.jpmml.evaluator.VerificationUtil;

public class NaiveBayesModelEvaluator
extends ModelEvaluator<NaiveBayesModel> {
    private static final LoadingCache<NaiveBayesModel, List<BayesInput>> bayesInputCache = CacheUtil.buildLoadingCache(new CacheLoader<NaiveBayesModel, List<BayesInput>>(){

        public List<BayesInput> load(NaiveBayesModel naiveBayesModel) {
            return ImmutableList.copyOf((Collection)NaiveBayesModelEvaluator.parseBayesInputs(naiveBayesModel));
        }
    });
    private static final LoadingCache<NaiveBayesModel, Map<FieldName, Map<String, Double>>> fieldCountSumCache = CacheUtil.buildLoadingCache(new CacheLoader<NaiveBayesModel, Map<FieldName, Map<String, Double>>>(){

        public Map<FieldName, Map<String, Double>> load(NaiveBayesModel naiveBayesModel) {
            return ImmutableMap.copyOf((Map)NaiveBayesModelEvaluator.calculateFieldCountSums(naiveBayesModel));
        }
    });

    public NaiveBayesModelEvaluator(PMML pmml) {
        super(pmml, NaiveBayesModel.class);
    }

    public NaiveBayesModelEvaluator(PMML pmml, NaiveBayesModel naiveBayesModel) {
        super(pmml, naiveBayesModel);
    }

    @Override
    public String getSummary() {
        return "Naive Bayes model";
    }

    @Override
    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        Map<FieldName, ? extends Classification> predictions;
        NaiveBayesModel naiveBayesModel = (NaiveBayesModel)this.getModel();
        if (!naiveBayesModel.isScorable()) {
            throw new InvalidResultException((PMMLObject)naiveBayesModel);
        }
        MiningFunctionType miningFunction = naiveBayesModel.getFunctionName();
        switch (miningFunction) {
            case CLASSIFICATION: {
                predictions = this.evaluateClassification(context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)naiveBayesModel, (Enum<?>)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, ? extends Classification> evaluateClassification(ModelEvaluationContext context) {
        NaiveBayesModel naiveBayesModel = (NaiveBayesModel)this.getModel();
        double threshold = naiveBayesModel.getThreshold();
        LinkedHashMap<String, Double> probabilities = new LinkedHashMap<String, Double>();
        Map<FieldName, Map<String, Double>> fieldCountSums = this.getFieldCountSums();
        List<BayesInput> bayesInputs = this.getBayesInputs();
        for (BayesInput bayesInput : bayesInputs) {
            FieldName name = bayesInput.getFieldName();
            FieldValue value = context.evaluate(name);
            if (value == null) continue;
            TargetValueStats targetValueStats = NaiveBayesModelEvaluator.getTargetValueStats(bayesInput);
            if (targetValueStats != null) {
                this.calculateContinuousProbabilities(value, targetValueStats, threshold, probabilities);
                continue;
            }
            DerivedField derivedField = bayesInput.getDerivedField();
            if (derivedField != null) {
                Expression expression = derivedField.getExpression();
                if (expression == null) {
                    throw new InvalidFeatureException((PMMLObject)derivedField);
                }
                if (!(expression instanceof Discretize)) {
                    throw new UnsupportedFeatureException((PMMLObject)expression);
                }
                Discretize discretize = (Discretize)expression;
                if ((value = DiscretizationUtil.discretize(discretize, value)) == null) {
                    throw new EvaluationException();
                }
                value = FieldValueUtil.refine((Field)derivedField, value);
            }
            Map<String, Double> countSums = fieldCountSums.get(name);
            TargetValueCounts targetValueCounts = NaiveBayesModelEvaluator.getTargetValueCounts(bayesInput, value);
            if (targetValueCounts == null) continue;
            this.calculateDiscreteProbabilities(countSums, targetValueCounts, threshold, probabilities);
        }
        BayesOutput bayesOutput = naiveBayesModel.getBayesOutput();
        this.calculatePriorProbabilities(bayesOutput.getTargetValueCounts(), probabilities);
        ProbabilityDistribution result = new ProbabilityDistribution();
        Double max = (Double)Collections.max(probabilities.values());
        Set entries = probabilities.entrySet();
        for (Map.Entry entry : entries) {
            result.put((String)entry.getKey(), Math.exp((Double)entry.getValue() - max));
        }
        result.normalizeValues();
        FieldName targetField = bayesOutput.getFieldName();
        if (targetField == null) {
            throw new InvalidFeatureException((PMMLObject)bayesOutput);
        }
        return TargetUtil.evaluateClassification(Collections.singletonMap(targetField, result), context);
    }

    private void calculateContinuousProbabilities(FieldValue value, TargetValueStats targetValueStats, double threshold, Map<String, Double> probabilities) {
        Number x = value.asNumber();
        for (TargetValueStat targetValueStat : targetValueStats) {
            String targetValue = targetValueStat.getValue();
            ContinuousDistribution distribution = targetValueStat.getContinuousDistribution();
            if (!(distribution instanceof GaussianDistribution) && !(distribution instanceof PoissonDistribution)) {
                throw new InvalidFeatureException((PMMLObject)targetValueStat);
            }
            double probability = DistributionUtil.probability(distribution, x);
            probability = Math.max(probability, threshold);
            NaiveBayesModelEvaluator.updateSum(targetValue, Math.log(probability), probabilities);
        }
    }

    private void calculateDiscreteProbabilities(Map<String, Double> countSums, TargetValueCounts targetValueCounts, double threshold, Map<String, Double> probabilities) {
        for (TargetValueCount targetValueCount : targetValueCounts) {
            String targetValue = targetValueCount.getValue();
            Double countSum = countSums.get(targetValue);
            double probability = targetValueCount.getCount() / countSum;
            if (VerificationUtil.isZero(targetValueCount.getCount(), Precision.EPSILON)) {
                probability = threshold;
            }
            NaiveBayesModelEvaluator.updateSum(targetValue, Math.log(probability), probabilities);
        }
    }

    private void calculatePriorProbabilities(TargetValueCounts targetValueCounts, Map<String, Double> probabilities) {
        for (TargetValueCount targetValueCount : targetValueCounts) {
            String targetValue = targetValueCount.getValue();
            NaiveBayesModelEvaluator.updateSum(targetValue, Math.log(targetValueCount.getCount()), probabilities);
        }
    }

    protected List<BayesInput> getBayesInputs() {
        return this.getValue(bayesInputCache);
    }

    protected Map<FieldName, Map<String, Double>> getFieldCountSums() {
        return this.getValue(fieldCountSumCache);
    }

    private static Map<FieldName, Map<String, Double>> calculateFieldCountSums(NaiveBayesModel naiveBayesModel) {
        LinkedHashMap<FieldName, Map<String, Double>> result = new LinkedHashMap<FieldName, Map<String, Double>>();
        List<BayesInput> bayesInputs = CacheUtil.getValue(naiveBayesModel, bayesInputCache);
        for (BayesInput bayesInput : bayesInputs) {
            FieldName name = bayesInput.getFieldName();
            LinkedHashMap<String, Double> counts = new LinkedHashMap<String, Double>();
            List pairCounts = bayesInput.getPairCounts();
            for (PairCounts pairCount : pairCounts) {
                TargetValueCounts targetValueCounts = pairCount.getTargetValueCounts();
                for (TargetValueCount targetValueCount : targetValueCounts) {
                    NaiveBayesModelEvaluator.updateSum(targetValueCount.getValue(), targetValueCount.getCount(), counts);
                }
            }
            result.put(name, counts);
        }
        return result;
    }

    private static List<BayesInput> parseBayesInputs(NaiveBayesModel naiveBayesModel) {
        BayesInputs bayesInputs = naiveBayesModel.getBayesInputs();
        if (!bayesInputs.hasExtensions()) {
            return bayesInputs.getBayesInputs();
        }
        ArrayList<BayesInput> result = new ArrayList<BayesInput>(bayesInputs.getBayesInputs());
        List extensions = bayesInputs.getExtensions();
        for (Extension extension : extensions) {
            List objects = extension.getContent();
            for (Object object : objects) {
                if (!(object instanceof BayesInput)) continue;
                BayesInput bayesInput = (BayesInput)object;
                result.add(bayesInput);
            }
        }
        return result;
    }

    private static void updateSum(String key, Double value, Map<String, Double> counts) {
        Double count = counts.get(key);
        if (count == null) {
            count = 0.0;
        }
        counts.put(key, count + value);
    }

    private static TargetValueStats getTargetValueStats(BayesInput bayesInput) {
        return bayesInput.getTargetValueStats();
    }

    private static TargetValueCounts getTargetValueCounts(BayesInput bayesInput, FieldValue value) {
        if (bayesInput instanceof HasParsedValueMapping) {
            HasParsedValueMapping hasParsedValueMapping = (HasParsedValueMapping)bayesInput;
            return (TargetValueCounts)value.getMapping(hasParsedValueMapping);
        }
        List pairCounts = bayesInput.getPairCounts();
        for (PairCounts pairCount : pairCounts) {
            if (!value.equalsString(pairCount.getValue())) continue;
            TargetValueCounts targetValueCounts = pairCount.getTargetValueCounts();
            if (targetValueCounts == null) {
                throw new InvalidFeatureException((PMMLObject)pairCount);
            }
            return targetValueCounts;
        }
        return null;
    }
}

