/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.LinkedHashMap;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Segment;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.HasEntityId;
import org.jpmml.evaluator.PMMLException;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;

abstract class SegmentResultMap
extends LinkedHashMap<FieldName, Object>
implements HasEntityId {
    private Segment segment = null;
    private FieldName targetField = null;

    public SegmentResultMap(Segment segment, FieldName targetField) {
        this.setSegment(segment);
        this.setTargetField(targetField);
    }

    public String getId() {
        Segment segment = this.getSegment();
        return segment.getId();
    }

    public double getWeight() {
        Segment segment = this.getSegment();
        return segment.getWeight();
    }

    public Object getTargetValue(DataType dataType) {
        Object targetValue = EvaluatorUtil.decode(this.getTargetValue());
        try {
            return TypeUtil.cast(dataType, targetValue);
        }
        catch (TypeCheckException tce) {
            throw this.ensureContext(tce);
        }
    }

    public <V> V getTargetValue(Class<V> clazz) {
        Object targetValue = this.getTargetValue();
        try {
            return TypeUtil.cast(clazz, targetValue);
        }
        catch (TypeCheckException tce) {
            throw this.ensureContext(tce);
        }
    }

    public Segment getSegment() {
        return this.segment;
    }

    private void setSegment(Segment segment) {
        this.segment = segment;
    }

    public FieldName getTargetField() {
        return this.targetField;
    }

    private void setTargetField(FieldName targetField) {
        this.targetField = targetField;
    }

    public Object getTargetValue() {
        return this.get(this.getTargetField());
    }

    private <E extends PMMLException> E ensureContext(E exception) {
        Segment segment = this.getSegment();
        exception.ensureContext((PMMLObject)segment);
        return exception;
    }
}

