/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Arrays;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OutputField;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelEvaluatorTest;
import org.jpmml.evaluator.OutputUtil;
import org.junit.Assert;
import org.junit.Test;

public class AssociationOutputTest
extends ModelEvaluatorTest {
    @Test
    public void evaluate() throws Exception {
        ModelEvaluator<?> evaluator = this.createModelEvaluator();
        Map<FieldName, ?> arguments = AssociationOutputTest.createArguments("item", Arrays.asList("Cracker", "Coke"));
        Map result = evaluator.evaluate(arguments);
        Assert.assertEquals((Object)"1", (Object)AssociationOutputTest.getOutput(result, "entityId"));
        AssociationOutputTest.checkValue(Arrays.asList("Cracker"), result, "antecedent");
        AssociationOutputTest.checkValue(Arrays.asList("Water"), result, "consequent");
        AssociationOutputTest.checkValue("{Cracker}->{Water}", result, "rule");
        AssociationOutputTest.checkValue("1", result, "ruleId");
        AssociationOutputTest.checkDataType(DataType.STRING, evaluator, "rule");
        AssociationOutputTest.checkDataType(DataType.STRING, evaluator, "ruleId");
        AssociationOutputTest.checkValue(1.0, result, "support");
        AssociationOutputTest.checkValue(1.0, result, "confidence");
        AssociationOutputTest.checkValue(1.0, result, "lift");
        AssociationOutputTest.checkDataType(DataType.DOUBLE, evaluator, "support");
        AssociationOutputTest.checkDataType(DataType.DOUBLE, evaluator, "confidence");
        AssociationOutputTest.checkDataType(DataType.DOUBLE, evaluator, "lift");
    }

    private static void checkValue(Object expected, Map<FieldName, ?> result, String name) {
        Assert.assertEquals((Object)expected, (Object)AssociationOutputTest.getOutput(result, name));
        Assert.assertEquals((Object)expected, (Object)AssociationOutputTest.getOutput(result, "deprecated_" + name));
    }

    private static void checkDataType(DataType expected, ModelEvaluator<?> evaluator, String name) {
        Assert.assertEquals((Object)expected, (Object)OutputUtil.getDataType((OutputField)evaluator.getOutputField(FieldName.create((String)name)), evaluator));
        Assert.assertEquals((Object)expected, (Object)OutputUtil.getDataType((OutputField)evaluator.getOutputField(FieldName.create((String)("deprecated_" + name))), evaluator));
    }
}

