/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelEvaluatorTest;
import org.junit.Assert;
import org.junit.Test;

public abstract class AssociationSchemaTest
extends ModelEvaluatorTest {
    public abstract Map<FieldName, ?> createItemArguments(List<String> var1);

    @Test
    public void evaluate() throws Exception {
        this.evaluate(Arrays.asList("Cracker", "Coke"), Arrays.asList("1", "3"), Arrays.asList("1"), Arrays.asList("3"));
        this.evaluate(Arrays.asList("Cracker", "Water"), Arrays.asList("1", "2", "3", "4", "5"), Arrays.asList("3", "4", "5"), Arrays.asList("1", "2"));
        this.evaluate(Arrays.asList("Water", "Coke"), Arrays.asList("2", "5"), Arrays.asList("2", "5"), Arrays.asList(new String[0]));
        this.evaluate(Arrays.asList("Cracker", "Water", "Coke"), Arrays.asList("1", "2", "3", "4", "5"), Arrays.asList("4", "5"), Arrays.asList("1", "2", "3"));
        this.evaluate(Arrays.asList("Cracker", "Water", "Banana", "Apple"), Arrays.asList("1", "2", "3", "4", "5"), Arrays.asList("3", "4", "5"), Arrays.asList("1", "2"));
    }

    private void evaluate(List<String> items, List<String> recommendations, List<String> exclusiveRecommendations, List<String> ruleAssociations) throws Exception {
        ModelEvaluator<?> evaluator = this.createModelEvaluator();
        Map<FieldName, ?> arguments = this.createItemArguments(items);
        Map result = evaluator.evaluate(arguments);
        Assert.assertEquals(recommendations, (Object)AssociationSchemaTest.getOutput(result, "Recommendation"));
        Assert.assertEquals(exclusiveRecommendations, (Object)AssociationSchemaTest.getOutput(result, "Exclusive_Recommendation"));
        Assert.assertEquals(ruleAssociations, (Object)AssociationSchemaTest.getOutput(result, "Rule_Association"));
        Assert.assertEquals((Object)Iterables.getFirst(recommendations, null), (Object)AssociationSchemaTest.getOutput(result, "Top Recommendation"));
        Assert.assertEquals((Object)Iterables.getFirst(exclusiveRecommendations, null), (Object)AssociationSchemaTest.getOutput(result, "Top Exclusive_Recommendation"));
        Assert.assertEquals((Object)Iterables.getFirst(ruleAssociations, null), (Object)AssociationSchemaTest.getOutput(result, "Top Rule_Association"));
    }
}

