/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collections;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OutputField;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelEvaluatorTest;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.ProbabilityDistribution;
import org.junit.Assert;
import org.junit.Test;

public class CategoricalResidualTest
extends ModelEvaluatorTest {
    @Test
    public void evaluate() throws Exception {
        ModelEvaluator<?> evaluator = this.createModelEvaluator();
        Map<FieldName, ?> arguments = CategoricalResidualTest.createArguments(evaluator.getTargetField(), "Y");
        ModelEvaluationContext context = evaluator.createContext(null);
        context.declareAll(arguments);
        ProbabilityDistribution response = new ProbabilityDistribution();
        response.put("Y", Double.valueOf(0.8));
        response.put("N", Double.valueOf(0.2));
        response.computeResult(DataType.STRING);
        Map<FieldName, ProbabilityDistribution> prediction = Collections.singletonMap(evaluator.getTargetField(), response);
        Map result = OutputUtil.evaluate(prediction, (ModelEvaluationContext)context);
        FieldName field = FieldName.create((String)"Residual");
        Assert.assertEquals((double)0.2, (double)((Double)CategoricalResidualTest.getOutput(result, field)), (double)1.0E-8);
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)OutputUtil.getDataType((OutputField)evaluator.getOutputField(field), evaluator));
        arguments = CategoricalResidualTest.createArguments(evaluator.getTargetField(), "N");
        context = evaluator.createContext(null);
        context.declareAll(arguments);
        result = OutputUtil.evaluate(prediction, (ModelEvaluationContext)context);
        Assert.assertEquals((double)-0.8, (double)((Double)CategoricalResidualTest.getOutput(result, field)), (double)1.0E-8);
    }
}

