/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.dmg.pmml.BinarySimilarity;
import org.dmg.pmml.ClusteringField;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Jaccard;
import org.dmg.pmml.Measure;
import org.dmg.pmml.SimpleMatching;
import org.dmg.pmml.Tanimoto;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.MeasureUtil;
import org.junit.Assert;
import org.junit.Test;

public class MeasureUtilTest {
    @Test
    public void evaluateSimilarity() {
        ComparisonMeasure comparisonMeasure = new ComparisonMeasure(ComparisonMeasure.Kind.SIMILARITY);
        List<ClusteringField> clusteringFields = MeasureUtilTest.createClusteringFields("one", "two", "three", "four");
        BitSet flags = MeasureUtilTest.createFlags(Arrays.asList(0, 0, 1, 1));
        BitSet referenceFlags = MeasureUtilTest.createFlags(Arrays.asList(0, 1, 0, 1));
        comparisonMeasure.setMeasure((Measure)new SimpleMatching());
        Assert.assertEquals((double)0.5, (double)MeasureUtil.evaluateSimilarity((ComparisonMeasure)comparisonMeasure, clusteringFields, (BitSet)flags, (BitSet)referenceFlags), (double)1.0E-8);
        comparisonMeasure.setMeasure((Measure)new Jaccard());
        Assert.assertEquals((double)0.3333333333333333, (double)MeasureUtil.evaluateSimilarity((ComparisonMeasure)comparisonMeasure, clusteringFields, (BitSet)flags, (BitSet)referenceFlags), (double)1.0E-8);
        comparisonMeasure.setMeasure((Measure)new Tanimoto());
        Assert.assertEquals((double)0.3333333333333333, (double)MeasureUtil.evaluateSimilarity((ComparisonMeasure)comparisonMeasure, clusteringFields, (BitSet)flags, (BitSet)referenceFlags), (double)1.0E-8);
        comparisonMeasure.setMeasure((Measure)new BinarySimilarity(0.5, 0.5, 0.5, 0.5, 1.0, 1.0, 1.0, 1.0));
        Assert.assertEquals((double)0.5, (double)MeasureUtil.evaluateSimilarity((ComparisonMeasure)comparisonMeasure, clusteringFields, (BitSet)flags, (BitSet)referenceFlags), (double)1.0E-8);
    }

    private static List<ClusteringField> createClusteringFields(String ... names) {
        ArrayList<ClusteringField> result = new ArrayList<ClusteringField>();
        for (String name : names) {
            ClusteringField clusteringField = new ClusteringField(FieldName.create((String)name));
            result.add(clusteringField);
        }
        return result;
    }

    private static BitSet createFlags(List<Integer> values) {
        return MeasureUtil.toBitSet((List)FieldValueUtil.createAll(values));
    }
}

