/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

abstract class ClassificationAggregator<K> {
    private Map<K, List<Double>> map = new LinkedHashMap<K, List<Double>>();

    ClassificationAggregator() {
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    public void add(K key, Double value) {
        List<Double> values = this.map.get(key);
        if (values == null) {
            values = new ArrayList<Double>();
            this.map.put(key, values);
        }
        values.add(value);
    }

    protected <V> Map<K, V> transform(Function<List<Double>, V> function) {
        return Maps.transformValues(this.map, function);
    }
}

