/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Array;
import org.dmg.pmml.CenterFields;
import org.dmg.pmml.Cluster;
import org.dmg.pmml.ClusteringField;
import org.dmg.pmml.ClusteringModel;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Measure;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MissingValueWeights;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Target;
import org.jpmml.evaluator.ArrayUtil;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.ClusterAffinityDistribution;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.MeasureUtil;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;

public class ClusteringModelEvaluator
extends ModelEvaluator<ClusteringModel>
implements HasEntityRegistry<Cluster> {
    private static final LoadingCache<Cluster, List<FieldValue>> clusterValueCache = CacheUtil.buildLoadingCache(new CacheLoader<Cluster, List<FieldValue>>(){

        public List<FieldValue> load(Cluster cluster) {
            Array array = cluster.getArray();
            List<? extends Number> values = ArrayUtil.asNumberList(array);
            return ImmutableList.copyOf(FieldValueUtil.createAll(values));
        }
    });
    private static final LoadingCache<Cluster, BitSet> clusterFlagCache = CacheUtil.buildLoadingCache(new CacheLoader<Cluster, BitSet>(){

        public BitSet load(Cluster cluster) {
            List values = (List)CacheUtil.getValue(cluster, clusterValueCache);
            return MeasureUtil.toBitSet(values);
        }
    });
    private static final LoadingCache<ClusteringModel, BiMap<String, Cluster>> entityCache = CacheUtil.buildLoadingCache(new CacheLoader<ClusteringModel, BiMap<String, Cluster>>(){

        public BiMap<String, Cluster> load(ClusteringModel clusteringModel) {
            return EntityUtil.buildBiMap(clusteringModel.getClusters());
        }
    });

    public ClusteringModelEvaluator(PMML pmml) {
        super(pmml, ClusteringModel.class);
    }

    public ClusteringModelEvaluator(PMML pmml, ClusteringModel clusteringModel) {
        super(pmml, clusteringModel);
    }

    @Override
    public String getSummary() {
        return "Clustering model";
    }

    @Override
    public Target getTarget(FieldName name) {
        return null;
    }

    @Override
    public BiMap<String, Cluster> getEntityRegistry() {
        return this.getValue(entityCache);
    }

    @Override
    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        Map<FieldName, ClusterAffinityDistribution> predictions;
        ClusteringModel clusteringModel = (ClusteringModel)this.getModel();
        if (!clusteringModel.isScorable()) {
            throw new InvalidResultException((PMMLObject)clusteringModel);
        }
        MiningFunctionType miningFunction = clusteringModel.getFunctionName();
        switch (miningFunction) {
            case CLUSTERING: {
                predictions = this.evaluateClustering(context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)clusteringModel, (Enum<?>)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, ClusterAffinityDistribution> evaluateClustering(EvaluationContext context) {
        ClusterAffinityDistribution result;
        ClusteringModel clusteringModel = (ClusteringModel)this.getModel();
        ClusteringModel.ModelClass modelClass = clusteringModel.getModelClass();
        switch (modelClass) {
            case CENTER_BASED: {
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)clusteringModel, (Enum<?>)modelClass);
            }
        }
        CenterFields centerFields = clusteringModel.getCenterFields();
        if (centerFields != null) {
            throw new UnsupportedFeatureException((PMMLObject)centerFields);
        }
        ArrayList<FieldValue> values = new ArrayList<FieldValue>();
        List<ClusteringField> clusteringFields = this.getCenterClusteringFields();
        for (ClusteringField clusteringField : clusteringFields) {
            FieldValue value = context.evaluate(clusteringField.getField());
            values.add(value);
        }
        ComparisonMeasure comparisonMeasure = clusteringModel.getComparisonMeasure();
        Measure measure = comparisonMeasure.getMeasure();
        if (MeasureUtil.isSimilarity(measure)) {
            result = this.evaluateSimilarity(comparisonMeasure, clusteringFields, values);
        } else if (MeasureUtil.isDistance(measure)) {
            result = this.evaluateDistance(comparisonMeasure, clusteringFields, values);
        } else {
            throw new UnsupportedFeatureException((PMMLObject)measure);
        }
        result.computeResult(DataType.STRING);
        return Collections.singletonMap(this.getTargetField(), result);
    }

    private ClusterAffinityDistribution evaluateSimilarity(ComparisonMeasure comparisonMeasure, List<ClusteringField> clusteringFields, List<FieldValue> values) {
        ClusteringModel clusteringModel = (ClusteringModel)this.getModel();
        BiMap<String, Cluster> entityRegistry = this.getEntityRegistry();
        ClusterAffinityDistribution result = new ClusterAffinityDistribution(Classification.Type.SIMILARITY, entityRegistry);
        BitSet flags = MeasureUtil.toBitSet(values);
        List clusters = clusteringModel.getClusters();
        for (Cluster cluster : clusters) {
            BitSet clusterFlags = CacheUtil.getValue(cluster, clusterFlagCache);
            if (flags.size() != clusterFlags.size()) {
                throw new InvalidFeatureException((PMMLObject)cluster);
            }
            String id = EntityUtil.getId(cluster, entityRegistry);
            Double similarity = MeasureUtil.evaluateSimilarity(comparisonMeasure, clusteringFields, flags, clusterFlags);
            result.put(cluster, id, similarity);
        }
        return result;
    }

    private ClusterAffinityDistribution evaluateDistance(ComparisonMeasure comparisonMeasure, List<ClusteringField> clusteringFields, List<FieldValue> values) {
        Double adjustment;
        ClusteringModel clusteringModel = (ClusteringModel)this.getModel();
        BiMap<String, Cluster> entityRegistry = this.getEntityRegistry();
        ClusterAffinityDistribution result = new ClusterAffinityDistribution(Classification.Type.DISTANCE, entityRegistry);
        MissingValueWeights missingValueWeights = clusteringModel.getMissingValueWeights();
        if (missingValueWeights != null) {
            Array array = missingValueWeights.getArray();
            List<? extends Number> adjustmentValues = ArrayUtil.asNumberList(array);
            if (values.size() != adjustmentValues.size()) {
                throw new InvalidFeatureException((PMMLObject)missingValueWeights);
            }
            adjustment = MeasureUtil.calculateAdjustment(values, adjustmentValues);
        } else {
            adjustment = MeasureUtil.calculateAdjustment(values);
        }
        List clusters = clusteringModel.getClusters();
        for (Cluster cluster : clusters) {
            List<FieldValue> clusterValues = CacheUtil.getValue(cluster, clusterValueCache);
            if (values.size() != clusterValues.size()) {
                throw new InvalidFeatureException((PMMLObject)cluster);
            }
            String id = EntityUtil.getId(cluster, entityRegistry);
            Double distance = MeasureUtil.evaluateDistance(comparisonMeasure, clusteringFields, values, clusterValues, adjustment);
            result.put(cluster, id, distance);
        }
        return result;
    }

    private List<ClusteringField> getCenterClusteringFields() {
        ClusteringModel clusteringModel = (ClusteringModel)this.getModel();
        ArrayList<ClusteringField> result = new ArrayList<ClusteringField>();
        List clusteringFields = clusteringModel.getClusteringFields();
        block4: for (ClusteringField clusteringField : clusteringFields) {
            ClusteringField.CenterField centerField = clusteringField.getCenterField();
            switch (centerField) {
                case TRUE: {
                    result.add(clusteringField);
                    continue block4;
                }
                case FALSE: {
                    continue block4;
                }
            }
            throw new UnsupportedFeatureException((PMMLObject)clusteringField, (Enum<?>)centerField);
        }
        return result;
    }
}

