/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.EmbeddedModel;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningModel;
import org.dmg.pmml.Model;
import org.dmg.pmml.MultipleModelMethodType;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.Segment;
import org.dmg.pmml.Segmentation;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueReference;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.MiningFieldUtil;
import org.jpmml.evaluator.MiningModelEvaluationContext;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.MissingValueException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.evaluator.ModelManager;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.PMMLException;
import org.jpmml.evaluator.PredicateUtil;
import org.jpmml.evaluator.ProbabilityAggregator;
import org.jpmml.evaluator.ProbabilityDistribution;
import org.jpmml.evaluator.RegressionAggregator;
import org.jpmml.evaluator.SegmentResultMap;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;
import org.jpmml.evaluator.VoteAggregator;

public class MiningModelEvaluator
extends ModelEvaluator<MiningModel>
implements HasEntityRegistry<Segment> {
    private ModelEvaluatorFactory evaluatorFactory = null;
    private LoadingCache<Model, SegmentHandler> segmentHandlerCache = CacheUtil.buildLoadingCache(new SegmentHandlerCacheLoader());
    private static final Set<MultipleModelMethodType> REGRESSION_METHODS = EnumSet.of(MultipleModelMethodType.SUM, MultipleModelMethodType.MEDIAN, MultipleModelMethodType.AVERAGE, MultipleModelMethodType.WEIGHTED_AVERAGE);
    private static final Set<MultipleModelMethodType> CLASSIFICATION_METHODS = EnumSet.of(MultipleModelMethodType.MAJORITY_VOTE, new MultipleModelMethodType[]{MultipleModelMethodType.WEIGHTED_MAJORITY_VOTE, MultipleModelMethodType.SUM, MultipleModelMethodType.MEDIAN, MultipleModelMethodType.AVERAGE, MultipleModelMethodType.WEIGHTED_AVERAGE});
    private static final Set<MultipleModelMethodType> CLUSTERING_METHODS = EnumSet.of(MultipleModelMethodType.MAJORITY_VOTE, MultipleModelMethodType.WEIGHTED_MAJORITY_VOTE);
    private static final LoadingCache<MiningModel, BiMap<String, Segment>> entityCache = CacheUtil.buildLoadingCache(new CacheLoader<MiningModel, BiMap<String, Segment>>(){

        public BiMap<String, Segment> load(MiningModel miningModel) {
            Segmentation segmentation = miningModel.getSegmentation();
            return EntityUtil.buildBiMap(segmentation.getSegments());
        }
    });

    public MiningModelEvaluator(PMML pmml) {
        super(pmml, MiningModel.class);
    }

    public MiningModelEvaluator(PMML pmml, MiningModel miningModel) {
        super(pmml, miningModel);
    }

    @Override
    public String getSummary() {
        return "Ensemble model";
    }

    @Override
    public BiMap<String, Segment> getEntityRegistry() {
        return this.getValue(entityCache);
    }

    @Override
    protected DataField getDataField() {
        MiningModel miningModel = (MiningModel)this.getModel();
        Segmentation segmentation = miningModel.getSegmentation();
        if (segmentation == null) {
            return null;
        }
        MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case SELECT_ALL: {
                return null;
            }
        }
        return super.getDataField();
    }

    @Override
    public MiningModelEvaluationContext createContext(ModelEvaluationContext parent) {
        return new MiningModelEvaluationContext(parent, this);
    }

    @Override
    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        return this.evaluate((MiningModelEvaluationContext)context);
    }

    public Map<FieldName, ?> evaluate(MiningModelEvaluationContext context) {
        Map<FieldName, ?> predictions;
        MiningModel miningModel = (MiningModel)this.getModel();
        if (!miningModel.isScorable()) {
            throw new InvalidResultException((PMMLObject)miningModel);
        }
        EmbeddedModel embeddedModel = (EmbeddedModel)Iterables.getFirst((Iterable)miningModel.getEmbeddedModels(), null);
        if (embeddedModel != null) {
            throw new UnsupportedFeatureException((PMMLObject)embeddedModel);
        }
        Segmentation segmentation = miningModel.getSegmentation();
        if (segmentation == null) {
            throw new InvalidFeatureException((PMMLObject)miningModel);
        }
        MiningFunctionType miningFunction = miningModel.getFunctionName();
        switch (miningFunction) {
            case REGRESSION: {
                predictions = this.evaluateRegression(context);
                break;
            }
            case CLASSIFICATION: {
                predictions = this.evaluateClassification(context);
                break;
            }
            case CLUSTERING: {
                predictions = this.evaluateClustering(context);
                break;
            }
            default: {
                predictions = this.evaluateAny(context);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, ?> evaluateRegression(MiningModelEvaluationContext context) {
        MiningModel miningModel = (MiningModel)this.getModel();
        List<SegmentResultMap> segmentResults = this.evaluateSegmentation(context);
        Map<FieldName, ?> predictions = this.getSegmentationResult(REGRESSION_METHODS, segmentResults);
        if (predictions != null) {
            return predictions;
        }
        Segmentation segmentation = miningModel.getSegmentation();
        Double result = MiningModelEvaluator.aggregateValues(segmentation, segmentResults);
        return TargetUtil.evaluateRegression(result, (ModelEvaluationContext)context);
    }

    private Map<FieldName, ?> evaluateClassification(MiningModelEvaluationContext context) {
        Classification result;
        MiningModel miningModel = (MiningModel)this.getModel();
        List<SegmentResultMap> segmentResults = this.evaluateSegmentation(context);
        Map<FieldName, ?> predictions = this.getSegmentationResult(CLASSIFICATION_METHODS, segmentResults);
        if (predictions != null) {
            return predictions;
        }
        Segmentation segmentation = miningModel.getSegmentation();
        MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case MAJORITY_VOTE: 
            case WEIGHTED_MAJORITY_VOTE: {
                result = new ProbabilityDistribution();
                result.putAll(MiningModelEvaluator.aggregateVotes(segmentation, segmentResults));
                result.normalizeValues();
                break;
            }
            case MAX: 
            case MEDIAN: {
                result = new Classification(Classification.Type.VOTE);
                result.putAll(MiningModelEvaluator.aggregateProbabilities(segmentation, segmentResults));
                break;
            }
            case AVERAGE: 
            case WEIGHTED_AVERAGE: {
                result = new ProbabilityDistribution();
                result.putAll(MiningModelEvaluator.aggregateProbabilities(segmentation, segmentResults));
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
            }
        }
        return TargetUtil.evaluateClassification(result, (ModelEvaluationContext)context);
    }

    private Map<FieldName, ?> evaluateClustering(MiningModelEvaluationContext context) {
        MiningModel miningModel = (MiningModel)this.getModel();
        List<SegmentResultMap> segmentResults = this.evaluateSegmentation(context);
        Map<FieldName, ?> predictions = this.getSegmentationResult(CLUSTERING_METHODS, segmentResults);
        if (predictions != null) {
            return predictions;
        }
        Segmentation segmentation = miningModel.getSegmentation();
        Classification result = new Classification(Classification.Type.VOTE);
        result.putAll(MiningModelEvaluator.aggregateVotes(segmentation, segmentResults));
        result.computeResult(DataType.STRING);
        return Collections.singletonMap(this.getTargetField(), result);
    }

    private Map<FieldName, ?> evaluateAny(MiningModelEvaluationContext context) {
        List<SegmentResultMap> segmentResults = this.evaluateSegmentation(context);
        return this.getSegmentationResult(Collections.emptySet(), segmentResults);
    }

    private List<SegmentResultMap> evaluateSegmentation(MiningModelEvaluationContext context) {
        MiningModel miningModel = (MiningModel)this.getModel();
        ArrayList<SegmentResultMap> results = new ArrayList<SegmentResultMap>();
        Segmentation segmentation = miningModel.getSegmentation();
        LocalTransformations localTransformations = segmentation.getLocalTransformations();
        if (localTransformations != null) {
            throw new UnsupportedFeatureException((PMMLObject)localTransformations);
        }
        BiMap<String, Segment> entityRegistry = this.getEntityRegistry();
        MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
        Model lastModel = null;
        MiningFunctionType miningFunction = miningModel.getFunctionName();
        HashMap<FieldName, OutputField> segmentOutputFields = new HashMap<FieldName, OutputField>();
        List segments = segmentation.getSegments();
        for (Segment segment : segments) {
            Map<FieldName, ?> result;
            Predicate predicate = segment.getPredicate();
            if (predicate == null) {
                throw new InvalidFeatureException((PMMLObject)segment);
            }
            Boolean status = PredicateUtil.evaluate(predicate, context);
            if (status == null || !status.booleanValue()) continue;
            Model model = segment.getModel();
            if (model == null) {
                throw new InvalidFeatureException((PMMLObject)segment);
            }
            switch (multipleModelMethod) {
                case MODEL_CHAIN: {
                    lastModel = model;
                    break;
                }
                default: {
                    if (miningFunction.equals((Object)model.getFunctionName())) break;
                    throw new InvalidFeatureException((PMMLObject)model);
                }
            }
            SegmentHandler segmentHandler = this.getSegmentHandler(model);
            ModelEvaluator evaluator = (ModelEvaluator)segmentHandler.getEvaluator();
            ModelEvaluationContext segmentContext = evaluator.createContext(context);
            segmentContext.setCompatible(segmentHandler.isCompatible());
            HashMap<FieldName, FieldValueReference> segmentArguments = new HashMap<FieldName, FieldValueReference>();
            List<FieldProxy> fieldProxies = segmentHandler.getFieldProxies();
            for (FieldProxy fieldProxy : fieldProxies) {
                FieldValueReference fieldValueReference = fieldProxy.createFieldValueReference(segmentOutputFields, context);
                segmentArguments.put(fieldValueReference.getName(), fieldValueReference);
            }
            segmentContext.setArguments(segmentArguments);
            try {
                result = evaluator.evaluate(segmentContext);
            }
            catch (PMMLException pe) {
                pe.ensureContext((PMMLObject)segment);
                throw pe;
            }
            FieldName targetField = evaluator.getTargetField();
            final String entityId = EntityUtil.getId(segment, entityRegistry);
            SegmentResultMap segmentResult = new SegmentResultMap(segment, targetField){

                @Override
                public String getEntityId() {
                    return entityId;
                }
            };
            segmentResult.putAll(result);
            context.putResult(entityId, segmentResult);
            switch (multipleModelMethod) {
                case MODEL_CHAIN: {
                    List<FieldName> outputFields = evaluator.getOutputFields();
                    for (FieldName outputField : outputFields) {
                        FieldValue outputValue = segmentContext.getField(outputField);
                        if (outputValue == null) {
                            throw new MissingValueException(outputField, (PMMLObject)segment);
                        }
                        context.declare(outputField, outputValue);
                        OutputField segmentOutputField = evaluator.getOutputField(outputField);
                        segmentOutputFields.put(outputField, segmentOutputField);
                    }
                    break;
                }
            }
            List<String> warnings = segmentContext.getWarnings();
            for (String warning : warnings) {
                context.addWarning(warning);
            }
            switch (multipleModelMethod) {
                case SELECT_FIRST: {
                    return Collections.singletonList(segmentResult);
                }
            }
            results.add(segmentResult);
        }
        switch (multipleModelMethod) {
            case MODEL_CHAIN: {
                if (lastModel == null || miningFunction.equals((Object)lastModel.getFunctionName())) break;
                throw new InvalidFeatureException((PMMLObject)lastModel);
            }
        }
        return results;
    }

    private Map<FieldName, ?> getSegmentationResult(Set<MultipleModelMethodType> multipleModelMethods, List<SegmentResultMap> segmentResults) {
        MiningModel miningModel = (MiningModel)this.getModel();
        Segmentation segmentation = miningModel.getSegmentation();
        MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case SELECT_ALL: {
                return MiningModelEvaluator.selectAll(segmentResults);
            }
            case SELECT_FIRST: {
                if (segmentResults.size() <= 0) break;
                return segmentResults.get(0);
            }
            case MODEL_CHAIN: {
                if (segmentResults.size() <= 0) break;
                return segmentResults.get(segmentResults.size() - 1);
            }
            default: {
                if (multipleModelMethods.contains(multipleModelMethod)) break;
                throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
            }
        }
        if (segmentResults.size() == 0) {
            return Collections.singletonMap(this.getTargetField(), null);
        }
        return null;
    }

    private SegmentHandler createSegmentHandler(Model model) {
        ModelEvaluatorFactory evaluatorFactory = this.getEvaluatorFactory();
        if (evaluatorFactory == null) {
            evaluatorFactory = ModelEvaluatorFactory.newInstance();
        }
        ModelManager evaluator = evaluatorFactory.newModelManager(this.getPMML(), model);
        boolean compatible = true;
        ArrayList<FieldProxy> fieldProxies = new ArrayList<FieldProxy>();
        List<FieldName> activeFields = evaluator.getActiveFields();
        for (FieldName activeField : activeFields) {
            MiningField miningField = ((ModelEvaluator)evaluator).getMiningField(activeField);
            DataField dataField = this.getDataField(activeField);
            if (dataField != null) {
                compatible &= MiningFieldUtil.isDefault(miningField);
                continue;
            }
            DerivedField derivedField = this.getLocalDerivedField(activeField);
            if (derivedField != null) {
                fieldProxies.add(new DerivedFieldProxy(miningField, derivedField));
                continue;
            }
            fieldProxies.add(new OutputFieldProxy(miningField));
        }
        SegmentHandler result = new SegmentHandler((Evaluator)((Object)evaluator), compatible, fieldProxies);
        return result;
    }

    public ModelEvaluatorFactory getEvaluatorFactory() {
        return this.evaluatorFactory;
    }

    public void setEvaluatorFactory(ModelEvaluatorFactory evaluatorFactory) {
        this.evaluatorFactory = evaluatorFactory;
    }

    private SegmentHandler getSegmentHandler(Model model) {
        return CacheUtil.getValue(model, this.segmentHandlerCache);
    }

    private static Double aggregateValues(Segmentation segmentation, List<SegmentResultMap> segmentResults) {
        RegressionAggregator aggregator = new RegressionAggregator();
        MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
        double denominator = 0.0;
        block10: for (SegmentResultMap segmentResult : segmentResults) {
            Double value = (Double)segmentResult.getTargetValue(DataType.DOUBLE);
            switch (multipleModelMethod) {
                case MEDIAN: 
                case SUM: {
                    aggregator.add(value);
                    continue block10;
                }
                case AVERAGE: {
                    aggregator.add(value);
                    denominator += 1.0;
                    continue block10;
                }
                case WEIGHTED_AVERAGE: {
                    double weight = segmentResult.getWeight();
                    aggregator.add(value * weight);
                    denominator += weight;
                    continue block10;
                }
            }
            throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
        }
        switch (multipleModelMethod) {
            case SUM: {
                return aggregator.sum();
            }
            case MEDIAN: {
                return aggregator.median();
            }
            case AVERAGE: 
            case WEIGHTED_AVERAGE: {
                return aggregator.average(denominator);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
    }

    private static Map<String, Double> aggregateVotes(Segmentation segmentation, List<SegmentResultMap> segmentResults) {
        VoteAggregator<String> aggregator = new VoteAggregator<String>();
        MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
        block4: for (SegmentResultMap segmentResult : segmentResults) {
            String key = (String)segmentResult.getTargetValue(DataType.STRING);
            switch (multipleModelMethod) {
                case MAJORITY_VOTE: {
                    aggregator.add(key, 1.0);
                    continue block4;
                }
                case WEIGHTED_MAJORITY_VOTE: {
                    aggregator.add(key, segmentResult.getWeight());
                    continue block4;
                }
            }
            throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
        }
        return aggregator.sumMap();
    }

    private static Map<String, Double> aggregateProbabilities(Segmentation segmentation, List<SegmentResultMap> segmentResults) {
        ProbabilityAggregator aggregator = new ProbabilityAggregator();
        MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
        double denominator = 0.0;
        block10: for (SegmentResultMap segmentResult : segmentResults) {
            HasProbability hasProbability = segmentResult.getTargetValue(HasProbability.class);
            switch (multipleModelMethod) {
                case MAX: 
                case MEDIAN: {
                    aggregator.add(hasProbability);
                    continue block10;
                }
                case AVERAGE: {
                    aggregator.add(hasProbability);
                    denominator += 1.0;
                    continue block10;
                }
                case WEIGHTED_AVERAGE: {
                    double weight = segmentResult.getWeight();
                    aggregator.add(hasProbability, weight);
                    denominator += weight;
                    continue block10;
                }
            }
            throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
        }
        switch (multipleModelMethod) {
            case MAX: {
                return aggregator.maxMap();
            }
            case MEDIAN: {
                return aggregator.medianMap();
            }
            case AVERAGE: 
            case WEIGHTED_AVERAGE: {
                return aggregator.averageMap(denominator);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
    }

    private static Map<FieldName, ?> selectAll(List<SegmentResultMap> segmentResults) {
        ArrayListMultimap result = ArrayListMultimap.create();
        LinkedHashSet keys = null;
        for (SegmentResultMap segmentResult : segmentResults) {
            if (keys == null) {
                keys = new LinkedHashSet(segmentResult.keySet());
            }
            if (!keys.equals(segmentResult.keySet())) {
                throw new EvaluationException();
            }
            for (FieldName key : keys) {
                result.put((Object)key, segmentResult.get(key));
            }
        }
        return result.asMap();
    }

    private static class OutputFieldProxy
    extends FieldProxy {
        private OutputFieldProxy(MiningField miningField) {
            super(miningField);
        }

        @Override
        public FieldValueReference createFieldValueReference(Map<FieldName, OutputField> outputFields, final MiningModelEvaluationContext context) {
            final MiningField miningField = this.getMiningField();
            FieldName name = miningField.getName();
            final OutputField outputField = outputFields.get(name);
            if (outputField == null) {
                throw new MissingFieldException(name, (PMMLObject)miningField);
            }
            FieldValueReference result = new FieldValueReference(name){

                @Override
                public FieldValue get() {
                    FieldName name = this.getName();
                    return FieldProxy.processFieldValue((Field)outputField, miningField, context.getField(name));
                }
            };
            return result;
        }
    }

    private static class DerivedFieldProxy
    extends FieldProxy {
        private DerivedField derivedField = null;

        private DerivedFieldProxy(MiningField miningField, DerivedField derivedField) {
            super(miningField);
            this.setDerivedField(derivedField);
        }

        @Override
        public FieldValueReference createFieldValueReference(Map<FieldName, OutputField> outputFields, final MiningModelEvaluationContext context) {
            final MiningField miningField = this.getMiningField();
            FieldName name = miningField.getName();
            OutputField outputField = outputFields.get(name);
            if (outputField != null) {
                throw new EvaluationException();
            }
            final DerivedField derivedField = this.getDerivedField();
            FieldValueReference result = new FieldValueReference(name){

                @Override
                public FieldValue get() {
                    FieldName name = this.getName();
                    return FieldProxy.processFieldValue((Field)derivedField, miningField, context.evaluate(name));
                }
            };
            return result;
        }

        public DerivedField getDerivedField() {
            return this.derivedField;
        }

        private void setDerivedField(DerivedField derivedField) {
            this.derivedField = derivedField;
        }
    }

    private static abstract class FieldProxy {
        private MiningField miningField = null;

        private FieldProxy(MiningField miningField) {
            this.setMiningField(miningField);
        }

        public abstract FieldValueReference createFieldValueReference(Map<FieldName, OutputField> var1, MiningModelEvaluationContext var2);

        public MiningField getMiningField() {
            return this.miningField;
        }

        private void setMiningField(MiningField miningField) {
            this.miningField = miningField;
        }

        public static FieldValue processFieldValue(Field field, MiningField miningField, FieldValue value) {
            if (MiningFieldUtil.isDefault(miningField)) {
                return value;
            }
            if (value == null) {
                return FieldValueUtil.performMissingValueTreatment(field, miningField);
            }
            return FieldValueUtil.performValidValueTreatment(field, miningField, FieldValueUtil.getValue(value));
        }
    }

    private static class SegmentHandler {
        private Evaluator evaluator = null;
        private boolean compatible = false;
        private List<FieldProxy> fieldProxies = null;

        private SegmentHandler(Evaluator evaluator, boolean compatible, List<FieldProxy> fieldProxies) {
            this.setEvaluator(evaluator);
            this.setCompatible(compatible);
            this.setFieldProxies(fieldProxies);
        }

        public Evaluator getEvaluator() {
            return this.evaluator;
        }

        private void setEvaluator(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        public boolean isCompatible() {
            return this.compatible;
        }

        private void setCompatible(boolean compatible) {
            this.compatible = compatible;
        }

        public List<FieldProxy> getFieldProxies() {
            return this.fieldProxies;
        }

        private void setFieldProxies(List<FieldProxy> fieldProxies) {
            this.fieldProxies = fieldProxies;
        }
    }

    private class SegmentHandlerCacheLoader
    extends CacheLoader<Model, SegmentHandler>
    implements Serializable {
        private SegmentHandlerCacheLoader() {
        }

        public SegmentHandler load(Model model) {
            return MiningModelEvaluator.this.createSegmentHandler(model);
        }
    }
}

