/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collections;
import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueReference;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.MiningFieldUtil;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.ModelEvaluator;

public class ModelEvaluationContext
extends EvaluationContext {
    private ModelEvaluationContext parent = null;
    private ModelEvaluator<?> modelEvaluator = null;
    private Map<FieldName, ?> arguments = Collections.emptyMap();
    private boolean compatible = false;

    public ModelEvaluationContext(ModelEvaluationContext parent, ModelEvaluator<?> modelEvaluator) {
        this.setParent(parent);
        this.setModelEvaluator(modelEvaluator);
    }

    @Override
    protected FieldValue createFieldValue(FieldName name, Object value) {
        ModelEvaluator<?> modelEvaluator = this.getModelEvaluator();
        MiningField miningField = modelEvaluator.getMiningField(name);
        if (miningField == null) {
            throw new EvaluationException();
        }
        return EvaluatorUtil.prepare(modelEvaluator, name, value);
    }

    @Override
    public FieldValue evaluate(FieldName name) {
        ModelEvaluator<?> modelEvaluator = this.getModelEvaluator();
        Map.Entry<FieldName, FieldValue> entry = this.getFieldEntry(name);
        if (entry != null) {
            return entry.getValue();
        }
        ModelEvaluationContext parent = this.getParent();
        MiningField miningField = modelEvaluator.getMiningField(name);
        if (miningField == null) {
            DerivedField localDerivedField = modelEvaluator.getLocalDerivedField(name);
            if (localDerivedField != null) {
                FieldValue value = ExpressionUtil.evaluate(localDerivedField, (EvaluationContext)this);
                return this.declare(name, value);
            }
            DerivedField derivedField = modelEvaluator.getDerivedField(name);
            if (derivedField != null) {
                FieldValue value = parent != null && this.isCompatible() ? parent.evaluate(name) : ExpressionUtil.evaluate(derivedField, (EvaluationContext)this);
                return this.declare(name, value);
            }
        } else {
            Map<FieldName, ?> arguments = this.getArguments();
            DataField dataField = modelEvaluator.getDataField(name);
            if (dataField != null) {
                if (parent != null) {
                    FieldValue value = parent.evaluate(name);
                    if (MiningFieldUtil.isDefault(miningField)) {
                        return this.declare(name, value);
                    }
                    return this.declare(name, FieldValueUtil.getValue(value));
                }
                Object value = arguments.get(name);
                return this.declare(name, value);
            }
            Object value = arguments.get(name);
            if (value instanceof FieldValueReference) {
                FieldValueReference fieldValueReference = (FieldValueReference)value;
                return this.declare(name, fieldValueReference.get());
            }
            DerivedField localDerivedField = modelEvaluator.getLocalDerivedField(name);
            DerivedField derivedField = modelEvaluator.getDerivedField(name);
            if (localDerivedField != null || derivedField != null) {
                throw new InvalidFeatureException((PMMLObject)miningField);
            }
        }
        throw new MissingFieldException(name);
    }

    @Override
    protected DefineFunction resolveDefineFunction(String name) {
        ModelEvaluator<?> modelEvaluator = this.getModelEvaluator();
        DefineFunction defineFunction = modelEvaluator.getFunction(name);
        return defineFunction;
    }

    public ModelEvaluationContext getParent() {
        return this.parent;
    }

    private void setParent(ModelEvaluationContext parent) {
        this.parent = parent;
    }

    public ModelEvaluator<?> getModelEvaluator() {
        return this.modelEvaluator;
    }

    private void setModelEvaluator(ModelEvaluator<?> modelEvaluator) {
        this.modelEvaluator = modelEvaluator;
    }

    Map<FieldName, ?> getArguments() {
        return this.arguments;
    }

    void setArguments(Map<FieldName, ?> arguments) {
        this.arguments = arguments;
    }

    boolean isCompatible() {
        return this.compatible;
    }

    void setCompatible(boolean compatible) {
        ModelEvaluationContext parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException();
        }
        this.compatible = compatible;
    }
}

