/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.HasAffinityRanking;
import org.jpmml.evaluator.HasEntityAffinity;
import org.jpmml.evaluator.HasEntityIdRanking;
import org.jpmml.evaluator.Report;
import org.jpmml.evaluator.ValueMap;

public class AffinityDistribution<V extends Number>
extends Classification<V>
implements HasEntityIdRanking,
HasAffinityRanking,
HasEntityAffinity {
    public AffinityDistribution(Classification.Type type, ValueMap<String, V> values, Object result) {
        super(AffinityDistribution.validateType(type), values);
        this.setResult(result);
    }

    @Override
    public void computeResult(DataType dataType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getCategoryValues() {
        return this.keySet();
    }

    @Override
    public String getEntityId() {
        Map.Entry entry = this.getWinner();
        if (entry == null) {
            return null;
        }
        return entry.getKey();
    }

    @Override
    public List<String> getEntityIdRanking() {
        return this.getWinnerKeys();
    }

    @Override
    public Double getAffinity(String category) {
        return this.getValue(category);
    }

    @Override
    public Report getAffinityReport(String category) {
        return this.getValueReport(category);
    }

    @Override
    public List<Double> getAffinityRanking() {
        return this.getWinnerValues();
    }

    @Override
    public Double getEntityAffinity() {
        return this.getAffinity(this.getEntityId());
    }

    public static Classification.Type validateType(Classification.Type type) {
        switch (type) {
            case DISTANCE: 
            case SIMILARITY: {
                return type;
            }
        }
        throw new IllegalArgumentException();
    }
}

