/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.Computable;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.HasPrediction;
import org.jpmml.evaluator.Numbers;
import org.jpmml.evaluator.Report;
import org.jpmml.evaluator.ReportUtil;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueMap;

public class Classification<V extends Number>
implements Computable,
HasPrediction {
    private Type type = null;
    private ValueMap<String, V> values = null;
    private Object result = null;

    protected Classification(Type type, ValueMap<String, V> values) {
        this.setType(type);
        this.setValues(values);
    }

    @Override
    public Object getResult() {
        if (this.result == null) {
            throw new EvaluationException();
        }
        return this.result;
    }

    protected void setResult(Object result) {
        this.result = result;
    }

    protected void computeResult(DataType dataType) {
        Map.Entry<String, Value<V>> entry = this.getWinner();
        if (entry == null) {
            throw new EvaluationException();
        }
        String key = entry.getKey();
        Value<V> value = entry.getValue();
        Object result = TypeUtil.parseOrCast(dataType, key);
        this.setResult(result);
    }

    @Override
    public Object getPrediction() {
        return this.getResult();
    }

    @Override
    public Report getPredictionReport() {
        Map.Entry<String, Value<V>> entry = this.getWinner();
        if (entry == null) {
            return null;
        }
        String key = entry.getKey();
        Value<V> value = entry.getValue();
        return ReportUtil.getReport(value);
    }

    public String toString() {
        Objects.ToStringHelper helper = this.toStringHelper();
        return helper.toString();
    }

    protected Objects.ToStringHelper toStringHelper() {
        Type type = this.getType();
        ValueMap<String, V> values = this.getValues();
        Objects.ToStringHelper helper = Objects.toStringHelper((Object)this).add("result", this.getResult()).add(type.entryKey(), values.entrySet());
        return helper;
    }

    public void put(String key, Value<V> value) {
        ValueMap<String, Value<V>> values = this.getValues();
        Value<V> previousValue = values.put(key, value);
        if (previousValue != null) {
            throw new EvaluationException();
        }
    }

    public Double getValue(String key) {
        Type type = this.getType();
        ValueMap<String, V> values = this.getValues();
        Value value = (Value)values.get(key);
        return type.getValue(value);
    }

    public Report getValueReport(String key) {
        ValueMap<String, V> values = this.getValues();
        Value value = (Value)values.get(key);
        return ReportUtil.getReport(value);
    }

    protected Map.Entry<String, Value<V>> getWinner() {
        return Classification.getWinner(this.getType(), this.entrySet());
    }

    protected List<Map.Entry<String, Value<V>>> getWinnerRanking() {
        return Classification.getWinnerList(this.getType(), this.entrySet());
    }

    protected List<String> getWinnerKeys() {
        return Classification.entryKeys(this.getWinnerRanking());
    }

    protected List<Double> getWinnerValues() {
        Function function = new Function<Value<V>, Double>(){

            public Double apply(Value<V> value) {
                return value.doubleValue();
            }
        };
        return Lists.transform(Classification.entryValues(this.getWinnerRanking()), (Function)function);
    }

    protected Set<String> keySet() {
        ValueMap<String, V> values = this.getValues();
        return values.keySet();
    }

    protected Set<Map.Entry<String, Value<V>>> entrySet() {
        ValueMap<String, V> values = this.getValues();
        return values.entrySet();
    }

    public Type getType() {
        return this.type;
    }

    private void setType(Type type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.type = type;
    }

    public ValueMap<String, V> getValues() {
        return this.values;
    }

    private void setValues(ValueMap<String, V> values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        this.values = values;
    }

    public static <V extends Number> Map.Entry<String, Value<V>> getWinner(Type type, Collection<Map.Entry<String, Value<V>>> entries) {
        Ordering<Map.Entry<String, Value<V>>> ordering = Classification.createOrdering(type);
        try {
            return (Map.Entry)ordering.max(entries);
        }
        catch (NoSuchElementException nsee) {
            return null;
        }
    }

    public static <V extends Number> List<Map.Entry<String, Value<V>>> getWinnerList(Type type, Collection<Map.Entry<String, Value<V>>> entries) {
        Ordering ordering = Classification.createOrdering(type).reverse();
        return ordering.sortedCopy(entries);
    }

    protected static <V extends Number> Ordering<Map.Entry<String, Value<V>>> createOrdering(final Type type) {
        Comparator comparator = new Comparator<Map.Entry<String, Value<V>>>(){

            @Override
            public int compare(Map.Entry<String, Value<V>> left, Map.Entry<String, Value<V>> right) {
                return type.compareValues(left.getValue(), right.getValue());
            }
        };
        return Ordering.from((Comparator)comparator);
    }

    public static <K, V> List<K> entryKeys(List<Map.Entry<K, V>> entries) {
        Function function = new Function<Map.Entry<K, V>, K>(){

            public K apply(Map.Entry<K, V> entry) {
                return entry.getKey();
            }
        };
        return Lists.transform(entries, (Function)function);
    }

    public static <K, V> List<V> entryValues(List<Map.Entry<K, V>> entries) {
        Function function = new Function<Map.Entry<K, V>, V>(){

            public V apply(Map.Entry<K, V> entry) {
                return entry.getValue();
            }
        };
        return Lists.transform(entries, (Function)function);
    }

    public static enum Type {
        PROBABILITY(true, (Range<Double>)Range.closed((Comparable)Numbers.DOUBLE_ZERO, (Comparable)Numbers.DOUBLE_ONE)),
        CONFIDENCE(true, (Range<Double>)Range.atLeast((Comparable)Numbers.DOUBLE_ZERO)),
        DISTANCE(false, Range.atLeast((Comparable)Numbers.DOUBLE_ZERO)){

            @Override
            public Double getDefaultValue() {
                return Double.POSITIVE_INFINITY;
            }
        }
        ,
        SIMILARITY(true, (Range<Double>)Range.atLeast((Comparable)Numbers.DOUBLE_ZERO)),
        VOTE(true, (Range<Double>)Range.atLeast((Comparable)Numbers.DOUBLE_ZERO));

        private boolean ordering;
        private Range<Double> range;

        private Type(boolean ordering, Range<Double> range) {
            this.setOrdering(ordering);
            this.setRange(range);
        }

        public <V extends Number> Double getValue(Value<V> value) {
            if (value == null) {
                return this.getDefaultValue();
            }
            return value.doubleValue();
        }

        public <V extends Number> int compareValues(Value<V> left, Value<V> right) {
            boolean ordering = this.getOrdering();
            if (left == null || right == null) {
                throw new EvaluationException();
            }
            int result = left.compareTo(right);
            return ordering ? result : -result;
        }

        public <V extends Number> boolean isValidValue(Value<V> value) {
            Range<Double> range = this.getRange();
            return range.contains((Comparable)Double.valueOf(value.doubleValue()));
        }

        public Double getDefaultValue() {
            return Numbers.DOUBLE_ZERO;
        }

        public String entryKey() {
            String name = this.name();
            return name.toLowerCase() + "_entries";
        }

        public boolean getOrdering() {
            return this.ordering;
        }

        private void setOrdering(boolean ordering) {
            this.ordering = ordering;
        }

        public Range<Double> getRange() {
            return this.range;
        }

        private void setRange(Range<Double> range) {
            this.range = range;
        }
    }
}

