/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Objects;
import com.google.common.collect.BiMap;
import org.dmg.pmml.Entity;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.HasEntityId;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueMap;

public abstract class EntityClassification<E extends Entity, V extends Number>
extends Classification<V>
implements HasEntityId,
HasEntityRegistry<E> {
    private BiMap<String, E> entityRegistry = null;
    private E entity = null;
    private Value<V> entityValue = null;

    protected EntityClassification(Classification.Type type, ValueMap<String, V> values, BiMap<String, E> entityRegistry) {
        super(type, values);
        this.setEntityRegistry(entityRegistry);
    }

    @Override
    protected Objects.ToStringHelper toStringHelper() {
        Objects.ToStringHelper helper = super.toStringHelper().add("entityId", (Object)this.getEntityId());
        return helper;
    }

    public void put(E entity, Value<V> value) {
        BiMap<String, E> entityRegistry = this.getEntityRegistry();
        String id = EntityUtil.getId(entity, entityRegistry);
        this.put(entity, id, value);
    }

    public void put(E entity, String key, Value<V> value) {
        Classification.Type type = this.getType();
        if (this.entityValue == null || type.compareValues(value, this.entityValue) > 0) {
            this.setEntity(entity);
            this.entityValue = value;
        }
        this.put((E)key, value);
    }

    @Override
    public String getEntityId() {
        E entity = this.getEntity();
        return EntityUtil.getId(entity, this);
    }

    @Override
    public BiMap<String, E> getEntityRegistry() {
        return this.entityRegistry;
    }

    private void setEntityRegistry(BiMap<String, E> entityRegistry) {
        if (entityRegistry == null) {
            throw new IllegalArgumentException();
        }
        this.entityRegistry = entityRegistry;
    }

    public E getEntity() {
        return this.entity;
    }

    protected void setEntity(E entity) {
        if (entity == null) {
            throw new IllegalArgumentException();
        }
        this.entity = entity;
    }
}

