/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.dmg.pmml.Array;
import org.dmg.pmml.DataType;
import org.dmg.pmml.HasValue;
import org.dmg.pmml.HasValueSet;
import org.dmg.pmml.OpType;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.jpmml.evaluator.ArrayUtil;
import org.jpmml.evaluator.HasParsedValue;
import org.jpmml.evaluator.HasParsedValueMapping;
import org.jpmml.evaluator.HasParsedValueSet;
import org.jpmml.evaluator.Numbers;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;

public abstract class FieldValue
implements Comparable<FieldValue>,
Serializable {
    private DataType dataType = null;
    private Object value = null;

    FieldValue(DataType dataType, Object value) {
        this.setDataType(Objects.requireNonNull(dataType));
        this.setValue(FieldValue.filterValue(Objects.requireNonNull(value)));
    }

    public abstract OpType getOpType();

    public boolean equals(HasValue<?> hasValue) {
        if (hasValue instanceof HasParsedValue) {
            HasParsedValue hasParsedValue = (HasParsedValue)hasValue;
            return this.equals(hasParsedValue);
        }
        return this.equalsString(hasValue.getValue());
    }

    public boolean equals(HasParsedValue<?> hasParsedValue) {
        FieldValue value = hasParsedValue.getValue(this.getDataType(), this.getOpType());
        return this.equals(value);
    }

    public boolean isIn(HasValueSet<?> hasValueSet) {
        if (hasValueSet instanceof HasParsedValueSet) {
            HasParsedValueSet hasParsedValueSet = (HasParsedValueSet)hasValueSet;
            return this.isIn(hasParsedValueSet);
        }
        Array array = hasValueSet.getArray();
        List<String> content = ArrayUtil.getContent(array);
        return this.indexInStrings(content) > -1;
    }

    public boolean isIn(HasParsedValueSet<?> hasParsedValueSet) {
        Set<FieldValue> values = hasParsedValueSet.getValueSet(this.getDataType(), this.getOpType());
        return values.contains(this);
    }

    @Override
    public int compareTo(HasValue<?> hasValue) {
        if (hasValue instanceof HasParsedValue) {
            HasParsedValue hasParsedValue = (HasParsedValue)hasValue;
            return this.compareTo(hasParsedValue);
        }
        return this.compareToString(hasValue.getValue());
    }

    @Override
    public int compareTo(HasParsedValue<?> hasParsedValue) {
        FieldValue value = hasParsedValue.getValue(this.getDataType(), this.getOpType());
        return this.compareTo(value);
    }

    public boolean equalsString(String string) {
        Object value = this.parseValue(string);
        if (this.isScalar()) {
            return this.getValue().equals(value);
        }
        return TypeUtil.equals(this.getDataType(), this.getValue(), value);
    }

    public boolean equalsValue(FieldValue value) {
        if (this.sameScalarType(value)) {
            return this.getValue().equals(value.getValue());
        }
        DataType dataType = TypeUtil.getResultDataType(this.getDataType(), value.getDataType());
        return TypeUtil.equals(dataType, this.getValue(), value.getValue());
    }

    public int indexInStrings(Iterable<String> strings) {
        Predicate<String> predicate = new Predicate<String>(){

            public boolean apply(String string) {
                return FieldValue.this.equalsString(string);
            }
        };
        return Iterables.indexOf(strings, (Predicate)predicate);
    }

    public int indexInValues(Iterable<FieldValue> values) {
        Predicate<FieldValue> predicate = new Predicate<FieldValue>(){

            public boolean apply(FieldValue value) {
                return FieldValue.this.equalsValue(value);
            }
        };
        return Iterables.indexOf(values, (Predicate)predicate);
    }

    public int compareToString(String string) {
        Object value = this.parseValue(string);
        if (this.isScalar()) {
            return ((Comparable)this.getValue()).compareTo(value);
        }
        return TypeUtil.compare(this.getDataType(), this.getValue(), value);
    }

    public int compareToValue(FieldValue value) {
        if (this.sameScalarType(value)) {
            return ((Comparable)this.getValue()).compareTo(value.getValue());
        }
        DataType dataType = TypeUtil.getResultDataType(this.getDataType(), value.getDataType());
        return TypeUtil.compare(dataType, this.getValue(), value.getValue());
    }

    public Object parseValue(String string) {
        DataType dataType = this.getDataType();
        return TypeUtil.parse(dataType, string);
    }

    public <V> V getMapping(HasParsedValueMapping<V> hasParsedValueMapping) {
        Map<FieldValue, V> values = hasParsedValueMapping.getValueMapping(this.getDataType(), this.getOpType());
        return values.get(this);
    }

    private boolean isScalar() {
        return this instanceof Scalar;
    }

    private boolean sameScalarType(FieldValue value) {
        if (this.isScalar()) {
            return this.getClass().equals(value.getClass());
        }
        return false;
    }

    public String asString() {
        return (String)this.getValue(DataType.STRING);
    }

    public Number asNumber() {
        Object value = this.getValue();
        if (value instanceof Number) {
            return (Number)value;
        }
        return (Double)this.getValue(DataType.DOUBLE);
    }

    public Integer asInteger() {
        return (Integer)this.getValue(DataType.INTEGER);
    }

    public Float asFloat() {
        Number number = this.asNumber();
        return Float.valueOf(number.floatValue());
    }

    public Double asDouble() {
        Number number = this.asNumber();
        return number.doubleValue();
    }

    public Boolean asBoolean() {
        return (Boolean)this.getValue(DataType.BOOLEAN);
    }

    public LocalDateTime asLocalDateTime() {
        return (LocalDateTime)this.getValue(DataType.DATE_TIME);
    }

    public LocalDate asLocalDate() {
        return (LocalDate)this.getValue(DataType.DATE);
    }

    public LocalTime asLocalTime() {
        return (LocalTime)this.getValue(DataType.TIME);
    }

    public DateTime asDateTime() {
        try {
            LocalDateTime dateTime = this.asLocalDateTime();
            return dateTime.toDateTime();
        }
        catch (TypeCheckException tceDateTime) {
            try {
                LocalDate date = this.asLocalDate();
                return date.toDateTimeAtStartOfDay();
            }
            catch (TypeCheckException tceDate) {
                try {
                    LocalTime time = this.asLocalTime();
                    return time.toDateTimeToday();
                }
                catch (TypeCheckException typeCheckException) {
                    throw tceDateTime;
                }
            }
        }
    }

    private Object getValue(DataType dataType) {
        Object value = this.getValue();
        try {
            return TypeUtil.cast(dataType, value);
        }
        catch (TypeCheckException tce) {
            try {
                if (value instanceof String) {
                    String string = (String)value;
                    return TypeUtil.parse(dataType, string);
                }
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
            throw tce;
        }
    }

    @Override
    public int compareTo(FieldValue that) {
        if (this.getOpType() != that.getOpType() || this.getDataType() != that.getDataType()) {
            throw new ClassCastException();
        }
        return this.compareToValue(that);
    }

    public int hashCode() {
        return 31 * (this.getOpType().hashCode() ^ this.getDataType().hashCode()) + this.getValue().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof FieldValue) {
            FieldValue that = (FieldValue)object;
            return this.getOpType() == that.getOpType() && this.getDataType() == that.getDataType() && this.getValue().equals(that.getValue());
        }
        return false;
    }

    public String toString() {
        Objects.ToStringHelper helper = com.google.common.base.Objects.toStringHelper((Object)this).add("opType", (Object)this.getOpType()).add("dataType", (Object)this.getDataType()).add("value", this.getValue());
        return helper.toString();
    }

    public DataType getDataType() {
        return this.dataType;
    }

    private void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public Object getValue() {
        return this.value;
    }

    private void setValue(Object value) {
        this.value = value;
    }

    private static Object filterValue(Object value) {
        if (value instanceof Float) {
            return FieldValue.filterValue((Float)value);
        }
        if (value instanceof Double) {
            return FieldValue.filterValue((Double)value);
        }
        return value;
    }

    private static Float filterValue(Float value) {
        if (value.doubleValue() == 0.0) {
            return Numbers.FLOAT_ZERO;
        }
        return value;
    }

    private static Double filterValue(Double value) {
        if (value == 0.0) {
            return Numbers.DOUBLE_ZERO;
        }
        return value;
    }

    static interface Scalar {
    }
}

