/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.Interval;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MissingValueTreatmentMethod;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutlierTreatmentMethod;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Target;
import org.dmg.pmml.TypeDefinitionField;
import org.dmg.pmml.Value;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.CategoricalValue;
import org.jpmml.evaluator.ContinuousValue;
import org.jpmml.evaluator.DiscretizationUtil;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.HasParsedValueMapping;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.OrdinalValue;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;

public class FieldValueUtil {
    private static final LoadingCache<TypeDefinitionField, List<String>> targetCategoryCache = CacheUtil.buildLoadingCache(new CacheLoader<TypeDefinitionField, List<String>>(){

        public List<String> load(TypeDefinitionField field) {
            List<Value> values = FieldValueUtil.getValidValues(field);
            Function<Value, String> function = new Function<Value, String>(){

                public String apply(Value value) {
                    String result = value.getValue();
                    if (result == null) {
                        throw new InvalidFeatureException((PMMLObject)value);
                    }
                    return result;
                }
            };
            return ImmutableList.copyOf((Iterable)Iterables.transform(values, (Function)function));
        }
    });
    private static final LoadingCache<DataField, RangeSet<Double>> validRangeCache = CacheUtil.buildLoadingCache(new CacheLoader<DataField, RangeSet<Double>>(){

        public RangeSet<Double> load(DataField dataField) {
            return ImmutableRangeSet.copyOf((RangeSet)FieldValueUtil.parseValidRanges(dataField));
        }
    });

    private FieldValueUtil() {
    }

    public static FieldValue prepareInputValue(Field field, MiningField miningField, Object value) {
        boolean compatible;
        DataType dataType = field.getDataType();
        OpType opType = field.getOpType();
        if (dataType == null || opType == null) {
            throw new InvalidFeatureException((PMMLObject)field);
        }
        if (value == null) {
            return FieldValueUtil.performMissingValueTreatment(field, miningField);
        }
        if (value instanceof Collection) {
            return FieldValueUtil.createInputValue(field, miningField, value);
        }
        try {
            value = FieldValueUtil.createInputValue(field, miningField, value);
            compatible = true;
        }
        catch (IllegalArgumentException | TypeCheckException e) {
            compatible = false;
        }
        Value.Property status = FieldValueUtil.getStatus(field, miningField, value, compatible);
        switch (status) {
            case VALID: {
                return FieldValueUtil.performValidValueTreatment(field, miningField, (FieldValue)value);
            }
            case INVALID: {
                return FieldValueUtil.performInvalidValueTreatment(field, miningField, value);
            }
            case MISSING: {
                return FieldValueUtil.performMissingValueTreatment(field, miningField);
            }
        }
        throw new EvaluationException();
    }

    public static FieldValue prepareTargetValue(DataField dataField, MiningField miningField, Target target, Object value) {
        DataType dataType = dataField.getDataType();
        OpType opType = dataField.getOpType();
        if (dataType == null || opType == null) {
            throw new InvalidFeatureException((PMMLObject)dataField);
        }
        if (miningField != null) {
            String invalidValueReplacement = miningField.getInvalidValueReplacement();
            String missingValueReplacement = miningField.getMissingValueReplacement();
            if (invalidValueReplacement != null || missingValueReplacement != null) {
                throw new InvalidFeatureException((PMMLObject)miningField);
            }
        }
        return FieldValueUtil.createTargetValue((Field)dataField, miningField, target, value);
    }

    public static FieldValue performValidValueTreatment(Field field, MiningField miningField, FieldValue value) {
        OutlierTreatmentMethod outlierTreatmentMethod = miningField.getOutlierTreatment();
        switch (outlierTreatmentMethod) {
            case AS_IS: {
                return FieldValueUtil.createInputValue(field, miningField, value);
            }
            case AS_MISSING_VALUES: 
            case AS_EXTREME_VALUES: {
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)miningField, (Enum<?>)outlierTreatmentMethod);
            }
        }
        Double lowValue = miningField.getLowValue();
        Double highValue = miningField.getHighValue();
        if (lowValue == null || highValue == null || lowValue.compareTo(highValue) > 0) {
            throw new InvalidFeatureException((PMMLObject)miningField);
        }
        if (value == null) {
            throw new TypeCheckException(Number.class, null);
        }
        Number numberValue = value.asNumber();
        switch (outlierTreatmentMethod) {
            case AS_MISSING_VALUES: {
                if (!(numberValue.doubleValue() < lowValue) && !(numberValue.doubleValue() > highValue)) break;
                return FieldValueUtil.createMissingInputValue(field, miningField);
            }
            case AS_EXTREME_VALUES: {
                if (numberValue.doubleValue() < lowValue) {
                    return FieldValueUtil.createInputValue(field, miningField, lowValue);
                }
                if (!(numberValue.doubleValue() > highValue)) break;
                return FieldValueUtil.createInputValue(field, miningField, highValue);
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)miningField, (Enum<?>)outlierTreatmentMethod);
            }
        }
        return FieldValueUtil.createInputValue(field, miningField, value);
    }

    public static FieldValue performInvalidValueTreatment(Field field, MiningField miningField, Object value) {
        InvalidValueTreatmentMethod invalidValueTreatmentMethod = miningField.getInvalidValueTreatment();
        String invalidValueReplacement = miningField.getInvalidValueReplacement();
        switch (invalidValueTreatmentMethod) {
            case AS_IS: {
                break;
            }
            case AS_MISSING: 
            case RETURN_INVALID: {
                if (invalidValueReplacement == null) break;
                throw new InvalidFeatureException((PMMLObject)miningField);
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)miningField, (Enum<?>)invalidValueTreatmentMethod);
            }
        }
        switch (invalidValueTreatmentMethod) {
            case AS_IS: {
                if (invalidValueReplacement != null) {
                    return FieldValueUtil.createInputValue(field, miningField, invalidValueReplacement);
                }
                return FieldValueUtil.createInputValue(field, miningField, value);
            }
            case AS_MISSING: {
                return FieldValueUtil.createMissingInputValue(field, miningField);
            }
            case RETURN_INVALID: {
                throw new InvalidResultException((PMMLObject)miningField);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)miningField, (Enum<?>)invalidValueTreatmentMethod);
    }

    public static FieldValue performMissingValueTreatment(Field field, MiningField miningField) {
        MissingValueTreatmentMethod missingValueTreatmentMethod = miningField.getMissingValueTreatment();
        if (missingValueTreatmentMethod == null) {
            missingValueTreatmentMethod = MissingValueTreatmentMethod.AS_IS;
        }
        switch (missingValueTreatmentMethod) {
            case AS_IS: 
            case AS_MEAN: 
            case AS_MEDIAN: 
            case AS_MODE: 
            case AS_VALUE: {
                return FieldValueUtil.createMissingInputValue(field, miningField);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)miningField, (Enum<?>)missingValueTreatmentMethod);
    }

    static OpType getOpType(Field field, MiningField miningField) {
        OpType opType = field.getOpType();
        if (miningField != null) {
            opType = FieldValueUtil.firstNonNull(miningField.getOpType(), opType);
        }
        return opType;
    }

    static OpType getOpType(Field field, MiningField miningField, Target target) {
        OpType opType = field.getOpType();
        if (miningField != null) {
            opType = FieldValueUtil.firstNonNull(miningField.getOpType(), opType);
            if (target != null) {
                opType = FieldValueUtil.firstNonNull(target.getOpType(), opType);
            }
        }
        return opType;
    }

    private static Value.Property getStatus(Field field, MiningField miningField, Object value, boolean compatible) {
        if (field instanceof DataField) {
            DataField dataField = (DataField)field;
            return FieldValueUtil.getStatus(dataField, miningField, value, compatible);
        }
        return compatible ? Value.Property.VALID : Value.Property.INVALID;
    }

    private static Value.Property getStatus(DataField dataField, MiningField miningField, Object value, boolean compatible) {
        OpType opType;
        boolean hasValidSpace = false;
        if (dataField.hasValues()) {
            HasParsedValueMapping hasParsedValueMapping;
            Value pmmlValue;
            DataType dataType = dataField.getDataType();
            opType = dataField.getOpType();
            if (dataField instanceof HasParsedValueMapping && (pmmlValue = FieldValueUtil.getValue(hasParsedValueMapping = (HasParsedValueMapping)dataField, dataType, opType, value)) != null) {
                return pmmlValue.getProperty();
            }
            List pmmlValues = dataField.getValues();
            int max = pmmlValues.size();
            block8: for (int i = 0; i < max; ++i) {
                boolean equals;
                Value pmmlValue2 = (Value)pmmlValues.get(i);
                Value.Property property = pmmlValue2.getProperty();
                switch (property) {
                    case VALID: {
                        FieldValue fieldValue;
                        hasValidSpace = true;
                        if (!compatible) continue block8;
                        if (value instanceof FieldValue) {
                            fieldValue = (FieldValue)value;
                            equals = fieldValue.equalsString(pmmlValue2.getValue());
                            break;
                        }
                        equals = FieldValueUtil.equals(dataType, value, pmmlValue2.getValue());
                        break;
                    }
                    case INVALID: 
                    case MISSING: {
                        FieldValue fieldValue;
                        if (value instanceof FieldValue) {
                            fieldValue = (FieldValue)value;
                            equals = FieldValueUtil.equals(dataType, FieldValueUtil.getValue(fieldValue), pmmlValue2.getValue());
                            break;
                        }
                        equals = FieldValueUtil.equals(dataType, value, pmmlValue2.getValue());
                        break;
                    }
                    default: {
                        throw new UnsupportedFeatureException((PMMLObject)pmmlValue2, (Enum<?>)property);
                    }
                }
                if (!equals) continue;
                return property;
            }
        }
        if (!compatible) {
            return Value.Property.INVALID;
        }
        if (dataField.hasIntervals()) {
            MiningField locatable = miningField;
            opType = miningField.getOpType();
            if (opType == null) {
                locatable = dataField;
                opType = dataField.getOpType();
            }
            switch (opType) {
                case CONTINUOUS: {
                    RangeSet<Double> validRanges = FieldValueUtil.getValidRanges(dataField);
                    if (!(value instanceof FieldValue)) {
                        throw new EvaluationException();
                    }
                    FieldValue fieldValue = (FieldValue)value;
                    Double doubleValue = fieldValue.asDouble();
                    return validRanges.contains((Comparable)doubleValue) ? Value.Property.VALID : Value.Property.INVALID;
                }
                case CATEGORICAL: 
                case ORDINAL: {
                    throw new InvalidFeatureException((PMMLObject)dataField);
                }
            }
            throw new UnsupportedFeatureException((PMMLObject)locatable, (Enum<?>)opType);
        }
        if (hasValidSpace) {
            return Value.Property.INVALID;
        }
        return Value.Property.VALID;
    }

    private static FieldValue createInputValue(Field field, MiningField miningField, Object value) {
        if (value == null) {
            return null;
        }
        DataType dataType = field.getDataType();
        OpType opType = FieldValueUtil.getOpType(field, miningField);
        FieldValue fieldValue = FieldValueUtil.createOrRefine(dataType, opType, value);
        if (field instanceof TypeDefinitionField) {
            return FieldValueUtil.enhance((TypeDefinitionField)field, fieldValue);
        }
        return fieldValue;
    }

    private static FieldValue createMissingInputValue(Field field, MiningField miningField) {
        String missingValueReplacement = miningField.getMissingValueReplacement();
        return FieldValueUtil.createInputValue(field, miningField, missingValueReplacement);
    }

    private static FieldValue createTargetValue(Field field, MiningField miningField, Target target, Object value) {
        if (value == null) {
            return null;
        }
        DataType dataType = field.getDataType();
        OpType opType = FieldValueUtil.getOpType(field, miningField, target);
        FieldValue fieldValue = FieldValueUtil.createOrRefine(dataType, opType, value);
        if (field instanceof TypeDefinitionField) {
            return FieldValueUtil.enhance((TypeDefinitionField)field, fieldValue);
        }
        return fieldValue;
    }

    public static FieldValue create(Field field, Object value) {
        FieldValue result = FieldValueUtil.create(field.getDataType(), field.getOpType(), value);
        if (field instanceof TypeDefinitionField) {
            return FieldValueUtil.enhance((TypeDefinitionField)field, result);
        }
        return result;
    }

    public static FieldValue create(DataType dataType, OpType opType, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            Collection values;
            if (dataType == null && (values = (Collection)value).size() > 0) {
                dataType = TypeUtil.getDataType(values);
            }
            if (dataType == null) {
                dataType = DataType.STRING;
            }
            if (opType == null) {
                opType = TypeUtil.getOpType(dataType);
            }
        } else {
            if (dataType == null) {
                dataType = TypeUtil.getDataType(value);
            } else {
                value = TypeUtil.parseOrCast(dataType, value);
            }
            if (opType == null) {
                opType = TypeUtil.getOpType(dataType);
            }
        }
        return FieldValueUtil.createInternal(dataType, opType, value);
    }

    public static List<FieldValue> createAll(final DataType dataType, final OpType opType, List<?> values) {
        Function<Object, FieldValue> function = new Function<Object, FieldValue>(){

            public FieldValue apply(Object value) {
                return FieldValueUtil.create(dataType, opType, value);
            }
        };
        return Lists.transform(values, (Function)function);
    }

    public static FieldValue refine(Field field, FieldValue value) {
        FieldValue result = FieldValueUtil.refine(field.getDataType(), field.getOpType(), value);
        if (field instanceof TypeDefinitionField && result != value) {
            return FieldValueUtil.enhance((TypeDefinitionField)field, result);
        }
        return result;
    }

    public static FieldValue refine(DataType dataType, OpType opType, FieldValue value) {
        if (value == null) {
            return null;
        }
        DataType valueDataType = value.getDataType();
        OpType valueOpType = value.getOpType();
        DataType refinedDataType = FieldValueUtil.firstNonNull(dataType, valueDataType);
        OpType refinedOpType = FieldValueUtil.firstNonNull(opType, valueOpType);
        if (refinedDataType.equals((Object)valueDataType)) {
            if (refinedOpType.equals((Object)valueOpType)) {
                return value;
            }
            return FieldValueUtil.createInternal(refinedDataType, refinedOpType, value.getValue());
        }
        return FieldValueUtil.create(refinedDataType, refinedOpType, value.getValue());
    }

    private static FieldValue createOrRefine(DataType dataType, OpType opType, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof FieldValue) {
            FieldValue fieldValue = (FieldValue)value;
            return FieldValueUtil.refine(dataType, opType, fieldValue);
        }
        return FieldValueUtil.create(dataType, opType, value);
    }

    private static FieldValue enhance(TypeDefinitionField field, FieldValue value) {
        if (value instanceof OrdinalValue) {
            OrdinalValue ordinalValue = (OrdinalValue)value;
            ordinalValue.setOrdering(FieldValueUtil.getOrdering(field, ordinalValue.getDataType()));
        }
        return value;
    }

    private static FieldValue createInternal(DataType dataType, OpType opType, Object value) {
        switch (opType) {
            case CONTINUOUS: {
                return ContinuousValue.create(dataType, value);
            }
            case CATEGORICAL: {
                return CategoricalValue.create(dataType, value);
            }
            case ORDINAL: {
                return OrdinalValue.create(dataType, value);
            }
        }
        throw new EvaluationException();
    }

    public static Object getValue(FieldValue value) {
        return value != null ? value.getValue() : null;
    }

    public static <V> V getValue(Class<? extends V> clazz, FieldValue value) {
        return TypeUtil.cast(clazz, FieldValueUtil.getValue(value));
    }

    public static Value getValidValue(TypeDefinitionField field, Object value) {
        if (value == null) {
            return null;
        }
        if (field.hasValues()) {
            DataType dataType = field.getDataType();
            OpType opType = field.getOpType();
            value = TypeUtil.parseOrCast(dataType, value);
            if (field instanceof HasParsedValueMapping) {
                HasParsedValueMapping hasParsedValueMapping = (HasParsedValueMapping)field;
                FieldValue fieldValue = FieldValueUtil.createInternal(dataType, opType, value);
                Value pmmlValue = FieldValueUtil.getValue(hasParsedValueMapping, dataType, opType, fieldValue);
                if (pmmlValue != null && Value.Property.VALID.equals((Object)pmmlValue.getProperty())) {
                    return pmmlValue;
                }
                return null;
            }
            List pmmlValues = field.getValues();
            int max = pmmlValues.size();
            block4: for (int i = 0; i < max; ++i) {
                Value pmmlValue = (Value)pmmlValues.get(i);
                Value.Property property = pmmlValue.getProperty();
                switch (property) {
                    case VALID: {
                        boolean equals = FieldValueUtil.equals(dataType, value, pmmlValue.getValue());
                        if (!equals) continue block4;
                        return pmmlValue;
                    }
                    case INVALID: 
                    case MISSING: {
                        continue block4;
                    }
                    default: {
                        throw new UnsupportedFeatureException((PMMLObject)pmmlValue, (Enum<?>)property);
                    }
                }
            }
        }
        return null;
    }

    private static Value getValue(HasParsedValueMapping<?> hasParsedValueMapping, DataType dataType, OpType opType, Object value) {
        try {
            FieldValue fieldValue = FieldValueUtil.createOrRefine(dataType, opType, value);
        }
        catch (IllegalArgumentException | TypeCheckException e) {
            return null;
        }
        Map<FieldValue, ?> fieldValues = hasParsedValueMapping.getValueMapping(dataType, opType);
        return (Value)fieldValues.get(value);
    }

    public static List<Value> getValidValues(TypeDefinitionField field) {
        if (field.hasValues()) {
            List pmmlValues = field.getValues();
            ArrayList<Value> result = new ArrayList<Value>(pmmlValues.size());
            int max = pmmlValues.size();
            block4: for (int i = 0; i < max; ++i) {
                Value pmmlValue = (Value)pmmlValues.get(i);
                Value.Property property = pmmlValue.getProperty();
                switch (property) {
                    case VALID: {
                        result.add(pmmlValue);
                        continue block4;
                    }
                    case INVALID: 
                    case MISSING: {
                        continue block4;
                    }
                    default: {
                        throw new UnsupportedFeatureException((PMMLObject)pmmlValue, (Enum<?>)property);
                    }
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static List<String> getTargetCategories(TypeDefinitionField field) {
        return CacheUtil.getValue(field, targetCategoryCache);
    }

    public static RangeSet<Double> getValidRanges(DataField dataField) {
        return CacheUtil.getValue(dataField, validRangeCache);
    }

    private static boolean equals(DataType dataType, Object value, String referenceValue) {
        try {
            return TypeUtil.equals(dataType, value, TypeUtil.parse(dataType, referenceValue));
        }
        catch (IllegalArgumentException | TypeCheckException e) {
            try {
                return TypeUtil.equals(DataType.STRING, value, referenceValue);
            }
            catch (TypeCheckException tce) {
                throw e;
            }
        }
    }

    private static <V> V firstNonNull(V value, V defaultValue) {
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    private static RangeSet<Double> parseValidRanges(DataField dataField) {
        TreeRangeSet result = TreeRangeSet.create();
        List intervals = dataField.getIntervals();
        for (Interval interval : intervals) {
            Range<Double> range = DiscretizationUtil.toRange(interval);
            result.add(range);
        }
        return result;
    }

    private static List<?> getOrdering(TypeDefinitionField field, final DataType dataType) {
        List<Value> values = FieldValueUtil.getValidValues(field);
        if (values.isEmpty()) {
            return null;
        }
        Function<Value, Object> function = new Function<Value, Object>(){

            public Object apply(Value value) {
                return TypeUtil.parse(dataType, value.getValue());
            }
        };
        return Lists.newArrayList((Iterable)Iterables.transform(values, (Function)function));
    }
}

