/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.BitSet;
import java.util.List;
import org.dmg.pmml.BinarySimilarity;
import org.dmg.pmml.Chebychev;
import org.dmg.pmml.CityBlock;
import org.dmg.pmml.CompareFunction;
import org.dmg.pmml.ComparisonField;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.Euclidean;
import org.dmg.pmml.Jaccard;
import org.dmg.pmml.Measure;
import org.dmg.pmml.Minkowski;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.SimpleMatching;
import org.dmg.pmml.SquaredEuclidean;
import org.dmg.pmml.Tanimoto;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValues;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.Numbers;
import org.jpmml.evaluator.UnsupportedFeatureException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.Vector;

public class MeasureUtil {
    private MeasureUtil() {
    }

    public static boolean isSimilarity(Measure measure) {
        return measure instanceof SimpleMatching || measure instanceof Jaccard || measure instanceof Tanimoto || measure instanceof BinarySimilarity;
    }

    public static <V extends Number> Value<V> evaluateSimilarity(ValueFactory<V> valueFactory, ComparisonMeasure comparisonMeasure, List<? extends ComparisonField> comparisonFields, BitSet flags, BitSet referenceFlags) {
        Measure measure = comparisonMeasure.getMeasure();
        int a11 = 0;
        int a10 = 0;
        int a01 = 0;
        int a00 = 0;
        for (int i = 0; i < comparisonFields.size(); ++i) {
            if (flags.get(i)) {
                if (referenceFlags.get(i)) {
                    ++a11;
                    continue;
                }
                ++a10;
                continue;
            }
            if (referenceFlags.get(i)) {
                ++a01;
                continue;
            }
            ++a00;
        }
        Value<V> numerator = valueFactory.newValue();
        Value<V> denominator = valueFactory.newValue();
        if (measure instanceof SimpleMatching) {
            numerator.add(a11 + a00);
            denominator.add(a11 + a10 + a01 + a00);
        } else if (measure instanceof Jaccard) {
            numerator.add(a11);
            denominator.add(a11 + a10 + a01);
        } else if (measure instanceof Tanimoto) {
            numerator.add(a11 + a00);
            denominator.add(a11).add(2.0, a10 + a01).add(a00);
        } else if (measure instanceof BinarySimilarity) {
            BinarySimilarity binarySimilarity = (BinarySimilarity)measure;
            numerator.add(binarySimilarity.getC11Parameter(), a11).add(binarySimilarity.getC10Parameter(), a10).add(binarySimilarity.getC01Parameter(), a01).add(binarySimilarity.getC00Parameter(), a00);
            denominator.add(binarySimilarity.getD11Parameter(), a11).add(binarySimilarity.getD10Parameter(), a10).add(binarySimilarity.getD01Parameter(), a01).add(binarySimilarity.getD00Parameter(), a00);
        } else {
            throw new UnsupportedFeatureException((PMMLObject)measure);
        }
        if (denominator.doubleValue() == 0.0) {
            throw new InvalidResultException(null);
        }
        return numerator.divide(denominator);
    }

    public static BitSet toBitSet(List<FieldValue> values) {
        BitSet result = new BitSet(values.size());
        for (int i = 0; i < values.size(); ++i) {
            FieldValue value = values.get(i);
            if (FieldValues.CONTINUOUS_DOUBLE_ZERO.equalsValue(value)) {
                result.set(i, false);
                continue;
            }
            if (FieldValues.CONTINUOUS_DOUBLE_ONE.equalsValue(value)) {
                result.set(i, true);
                continue;
            }
            throw new EvaluationException();
        }
        return result;
    }

    public static boolean isDistance(Measure measure) {
        return measure instanceof Euclidean || measure instanceof SquaredEuclidean || measure instanceof Chebychev || measure instanceof CityBlock || measure instanceof Minkowski;
    }

    public static <V extends Number> Value<V> evaluateDistance(ValueFactory<V> valueFactory, ComparisonMeasure comparisonMeasure, List<? extends ComparisonField> comparisonFields, List<FieldValue> values, List<FieldValue> referenceValues, Value<V> adjustment) {
        double innerPower;
        double outerPower;
        Measure measure = comparisonMeasure.getMeasure();
        if (measure instanceof Euclidean) {
            outerPower = 2.0;
            innerPower = 2.0;
        } else if (measure instanceof SquaredEuclidean) {
            innerPower = 2.0;
            outerPower = 1.0;
        } else if (measure instanceof Chebychev || measure instanceof CityBlock) {
            outerPower = 1.0;
            innerPower = 1.0;
        } else if (measure instanceof Minkowski) {
            Minkowski minkowski = (Minkowski)measure;
            double p = minkowski.getPParameter();
            if (p < 0.0) {
                throw new InvalidFeatureException((PMMLObject)minkowski);
            }
            innerPower = outerPower = p;
        } else {
            throw new UnsupportedFeatureException((PMMLObject)measure);
        }
        Vector<V> distances = valueFactory.newVector(0);
        int max = comparisonFields.size();
        for (int i = 0; i < max; ++i) {
            ComparisonField comparisonField = comparisonFields.get(i);
            FieldValue value = values.get(i);
            if (value == null) continue;
            FieldValue referenceValue = referenceValues.get(i);
            Value<V> distance = MeasureUtil.evaluateInnerFunction(valueFactory, comparisonMeasure, comparisonField, value, referenceValue, innerPower);
            distances.add(distance.doubleValue());
        }
        if (measure instanceof Euclidean || measure instanceof SquaredEuclidean || measure instanceof CityBlock || measure instanceof Minkowski) {
            Value<V> result = distances.sum();
            if (adjustment.doubleValue() != 1.0) {
                result.multiply(adjustment);
            }
            if (outerPower != 1.0) {
                result.inversePower(outerPower);
            }
            return result;
        }
        if (measure instanceof Chebychev) {
            Value<V> result = distances.max();
            if (adjustment.doubleValue() != 1.0) {
                result.multiply(adjustment);
            }
            return result;
        }
        throw new UnsupportedFeatureException((PMMLObject)measure);
    }

    private static <V extends Number> Value<V> evaluateInnerFunction(ValueFactory<V> valueFactory, ComparisonMeasure comparisonMeasure, ComparisonField comparisonField, FieldValue value, FieldValue referenceValue, double power) {
        Double fieldWeight;
        Value<V> distance;
        CompareFunction compareFunction = comparisonField.getCompareFunction();
        if (compareFunction == null) {
            compareFunction = comparisonMeasure.getCompareFunction();
            switch (compareFunction) {
                case ABS_DIFF: 
                case DELTA: 
                case EQUAL: {
                    break;
                }
                case GAUSS_SIM: 
                case TABLE: {
                    throw new InvalidFeatureException((PMMLObject)comparisonMeasure);
                }
                default: {
                    throw new UnsupportedFeatureException((PMMLObject)comparisonMeasure, (Enum<?>)compareFunction);
                }
            }
        }
        switch (compareFunction) {
            case ABS_DIFF: {
                distance = valueFactory.newValue(value.asNumber().doubleValue()).subtract(referenceValue.asNumber().doubleValue());
                distance.abs();
                break;
            }
            case GAUSS_SIM: {
                Double similarityScale = comparisonField.getSimilarityScale();
                if (similarityScale == null) {
                    throw new InvalidFeatureException((PMMLObject)comparisonField);
                }
                distance = valueFactory.newValue(value.asNumber().doubleValue()).subtract(referenceValue.asNumber().doubleValue());
                distance.gaussSim(similarityScale);
                break;
            }
            case DELTA: {
                boolean equals = value.equalsValue(referenceValue);
                distance = valueFactory.newValue(equals ? 0.0 : 1.0);
                break;
            }
            case EQUAL: {
                boolean equals = value.equalsValue(referenceValue);
                distance = valueFactory.newValue(equals ? 1.0 : 0.0);
                break;
            }
            case TABLE: {
                throw new UnsupportedFeatureException((PMMLObject)comparisonField, (Enum<?>)compareFunction);
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)comparisonField, (Enum<?>)compareFunction);
            }
        }
        if (power != 1.0) {
            distance.power(power);
        }
        if ((fieldWeight = comparisonField.getFieldWeight()) != null && fieldWeight != 1.0) {
            distance.multiply(fieldWeight);
        }
        return distance;
    }

    public static <V extends Number> Value<V> calculateAdjustment(ValueFactory<V> valueFactory, List<FieldValue> values) {
        return MeasureUtil.calculateAdjustment(valueFactory, values, null);
    }

    public static <V extends Number> Value<V> calculateAdjustment(ValueFactory<V> valueFactory, List<FieldValue> values, List<? extends Number> adjustmentValues) {
        Value<V> sum = valueFactory.newValue();
        Value<V> nonmissingSum = valueFactory.newValue();
        for (int i = 0; i < values.size(); ++i) {
            FieldValue value = values.get(i);
            Double adjustmentValue = adjustmentValues != null ? (Number)adjustmentValues.get(i) : (Number)Numbers.DOUBLE_ONE;
            sum.add(adjustmentValue);
            if (value == null) continue;
            nonmissingSum.add(adjustmentValue);
        }
        return sum.divide(nonmissingSum);
    }
}

