/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.jpmml.evaluator.ComplexFloatVector;
import org.jpmml.evaluator.Report;
import org.jpmml.evaluator.ReportingFloatValue;

public abstract class ReportingComplexFloatVector
extends ComplexFloatVector {
    private String expression = "";

    public ReportingComplexFloatVector(int capacity) {
        super(capacity);
    }

    public ReportingComplexFloatVector(int capacity, String expression) {
        super(capacity);
        if (expression != null) {
            this.report(expression);
        }
    }

    protected abstract Report newReport();

    @Override
    public ReportingComplexFloatVector add(double value) {
        ReportingComplexFloatVector result = (ReportingComplexFloatVector)super.add(value);
        this.report(new StringBuilder(256).append(this.getExpression()).append("<cn>").append((float)value).append("</cn>").toString());
        return result;
    }

    @Override
    public ReportingComplexFloatVector add(Number value) {
        ReportingComplexFloatVector result = (ReportingComplexFloatVector)super.add(value);
        this.report(new StringBuilder(256).append(this.getExpression()).append("<cn>").append(value.floatValue()).append("</cn>").toString());
        return result;
    }

    @Override
    public ReportingComplexFloatVector add(double coefficient, Number factor) {
        ReportingComplexFloatVector result = (ReportingComplexFloatVector)super.add(coefficient, factor);
        this.report(new StringBuilder(256).append(this.getExpression()).append("<apply><times/>").append("<cn>").append((float)coefficient).append("</cn>").append("<cn>").append(factor.floatValue()).append("</cn>").append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue get(int index) {
        return new ReportingFloatValue(this.floatValue(index), this.newReport());
    }

    public ReportingFloatValue max() {
        return new ReportingFloatValue(this.floatMax(), this.newReport(), new StringBuilder(256).append("<apply><max/>").append(this.getExpression()).append("</apply>").toString());
    }

    public ReportingFloatValue median() {
        return new ReportingFloatValue(this.floatMedian(), this.newReport(), new StringBuilder(256).append("<apply><median/>").append(this.getExpression()).append("</apply>").toString());
    }

    public ReportingFloatValue sum() {
        return new ReportingFloatValue(this.floatSum(), this.newReport(), new StringBuilder(256).append("<apply><plus/>").append(this.getExpression()).append("</apply>").toString());
    }

    private void report(String expression) {
        this.setExpression(expression);
    }

    public String getExpression() {
        return this.expression;
    }

    private void setExpression(String expression) {
        this.expression = expression;
    }
}

