/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Target;
import org.dmg.pmml.TargetValue;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.HasReport;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.ProbabilityDistribution;
import org.jpmml.evaluator.Regression;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;

public class TargetUtil {
    private TargetUtil() {
    }

    public static <V extends Number> Map<FieldName, ?> evaluateRegressionDefault(ValueFactory<V> valueFactory, TargetField targetField) {
        Value<V> value;
        Target target = targetField.getTarget();
        if (target != null && target.hasTargetValues() && (value = TargetUtil.getDefaultValue(valueFactory, target)) != null) {
            return TargetUtil.evaluateRegression(targetField, value);
        }
        return Collections.singletonMap(targetField.getName(), null);
    }

    public static <V extends Number> Map<FieldName, ?> evaluateRegression(TargetField targetField, Value<V> value) {
        DataField dataField = targetField.getDataField();
        if ((value = TargetUtil.evaluateRegressionInternal(targetField, value)) instanceof HasReport) {
            Regression<V> result = new Regression<V>(value);
            return TargetUtil.evaluateRegression(targetField, result);
        }
        Object result = TypeUtil.cast(dataField.getDataType(), value.getValue());
        return Collections.singletonMap(targetField.getName(), result);
    }

    public static <V extends Number> Map<FieldName, ? extends Regression<V>> evaluateRegression(TargetField targetField, Regression<V> regression) {
        DataField dataField = targetField.getDataField();
        regression.computeResult(dataField.getDataType());
        return Collections.singletonMap(targetField.getName(), regression);
    }

    public static <V extends Number> Value<V> evaluateRegressionInternal(TargetField targetField, Value<V> value) {
        Target target = targetField.getTarget();
        if (target != null) {
            return TargetUtil.processValue(target, value);
        }
        return value;
    }

    public static <V extends Number> Map<FieldName, ? extends Classification<V>> evaluateClassificationDefault(ValueFactory<V> valueFactory, TargetField targetField) {
        ProbabilityDistribution<V> result;
        Target target = targetField.getTarget();
        if (target != null && target.hasTargetValues() && (result = TargetUtil.getPriorProbabilities(valueFactory, target)) != null) {
            return TargetUtil.evaluateClassification(targetField, result);
        }
        return Collections.singletonMap(targetField.getName(), null);
    }

    public static <V extends Number> Map<FieldName, ? extends Classification<V>> evaluateClassification(TargetField targetField, Classification<V> classification) {
        DataField dataField = targetField.getDataField();
        classification.computeResult(dataField.getDataType());
        return Collections.singletonMap(targetField.getName(), classification);
    }

    public static <V extends Number> Value<V> processValue(Target target, Value<V> value) {
        Target.CastInteger castInteger;
        double rescaleConstant;
        double rescaleFactor;
        Double min = target.getMin();
        Double max = target.getMax();
        if (min != null || max != null) {
            value.restrict(min != null ? min : Double.NEGATIVE_INFINITY, max != null ? max : Double.POSITIVE_INFINITY);
        }
        if ((rescaleFactor = target.getRescaleFactor().doubleValue()) != 1.0) {
            value.multiply(rescaleFactor);
        }
        if ((rescaleConstant = target.getRescaleConstant().doubleValue()) != 0.0) {
            value.add(rescaleConstant);
        }
        if ((castInteger = target.getCastInteger()) == null) {
            return value;
        }
        switch (castInteger) {
            case ROUND: {
                return value.round();
            }
            case CEILING: {
                return value.ceiling();
            }
            case FLOOR: {
                return value.floor();
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)target, (Enum<?>)castInteger);
    }

    public static TargetValue getTargetValue(Target target, Object value) {
        DataType dataType = TypeUtil.getDataType(value);
        List targetValues = target.getTargetValues();
        for (TargetValue targetValue : targetValues) {
            if (!TypeUtil.equals(dataType, value, TypeUtil.parseOrCast(dataType, targetValue.getValue()))) continue;
            return targetValue;
        }
        return null;
    }

    private static <V extends Number> Value<V> getDefaultValue(ValueFactory<V> valueFactory, Target target) {
        if (!target.hasTargetValues()) {
            return null;
        }
        List targetValues = target.getTargetValues();
        if (targetValues.size() != 1) {
            throw new InvalidFeatureException((PMMLObject)target);
        }
        TargetValue targetValue = (TargetValue)targetValues.get(0);
        Double defaultValue = targetValue.getDefaultValue();
        if (targetValue.getValue() != null || targetValue.getPriorProbability() != null) {
            throw new InvalidFeatureException((PMMLObject)targetValue);
        }
        if (defaultValue == null) {
            return null;
        }
        return valueFactory.newValue(defaultValue);
    }

    private static <V extends Number> ProbabilityDistribution<V> getPriorProbabilities(ValueFactory<V> valueFactory, Target target) {
        if (!target.hasTargetValues()) {
            return null;
        }
        ValueMap<String, Value<V>> values = new ValueMap<String, Value<V>>();
        Value<V> sum = valueFactory.newValue();
        List targetValues = target.getTargetValues();
        for (TargetValue targetValue : targetValues) {
            String targetCategory = targetValue.getValue();
            Double probability = targetValue.getPriorProbability();
            if (targetCategory == null || probability == null) {
                throw new InvalidFeatureException((PMMLObject)targetValue);
            }
            if (targetValue.getDefaultValue() != null) {
                throw new InvalidFeatureException((PMMLObject)targetValue);
            }
            Value<V> value = valueFactory.newValue(probability);
            values.put(targetCategory, value);
            sum.add(value);
        }
        if (sum.doubleValue() != 1.0) {
            throw new InvalidFeatureException((PMMLObject)target);
        }
        return new ProbabilityDistribution(values);
    }
}

