/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.clustering;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Array;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.Measure;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Target;
import org.dmg.pmml.Targets;
import org.dmg.pmml.clustering.CenterFields;
import org.dmg.pmml.clustering.Cluster;
import org.dmg.pmml.clustering.ClusteringField;
import org.dmg.pmml.clustering.ClusteringModel;
import org.dmg.pmml.clustering.MissingValueWeights;
import org.jpmml.evaluator.ArrayUtil;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.MeasureUtil;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.clustering.ClusterAffinityDistribution;

public class ClusteringModelEvaluator
extends ModelEvaluator<ClusteringModel>
implements HasEntityRegistry<Cluster> {
    private transient BiMap<String, Cluster> entityRegistry = null;
    private static final LoadingCache<Cluster, List<FieldValue>> clusterValueCache = CacheUtil.buildLoadingCache(new CacheLoader<Cluster, List<FieldValue>>(){

        public List<FieldValue> load(Cluster cluster) {
            Array array = cluster.getArray();
            List<? extends Number> values = ArrayUtil.asNumberList(array);
            return ImmutableList.copyOf(FieldValueUtil.createAll(null, OpType.CONTINUOUS, values));
        }
    });
    private static final LoadingCache<Cluster, BitSet> clusterFlagCache = CacheUtil.buildLoadingCache(new CacheLoader<Cluster, BitSet>(){

        public BitSet load(Cluster cluster) {
            List values = (List)CacheUtil.getValue(cluster, clusterValueCache);
            return MeasureUtil.toBitSet(values);
        }
    });
    private static final LoadingCache<ClusteringModel, BiMap<String, Cluster>> entityCache = CacheUtil.buildLoadingCache(new CacheLoader<ClusteringModel, BiMap<String, Cluster>>(){

        public BiMap<String, Cluster> load(ClusteringModel clusteringModel) {
            return EntityUtil.buildBiMap(clusteringModel.getClusters());
        }
    });

    public ClusteringModelEvaluator(PMML pmml) {
        this(pmml, ClusteringModelEvaluator.selectModel(pmml, ClusteringModel.class));
    }

    public ClusteringModelEvaluator(PMML pmml, ClusteringModel clusteringModel) {
        super(pmml, clusteringModel);
        ComparisonMeasure comparisonMeasure = clusteringModel.getComparisonMeasure();
        if (comparisonMeasure == null) {
            throw new InvalidFeatureException((PMMLObject)clusteringModel);
        }
        ClusteringModel.ModelClass modelClass = clusteringModel.getModelClass();
        switch (modelClass) {
            case CENTER_BASED: {
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)clusteringModel, (Enum<?>)modelClass);
            }
        }
        CenterFields centerFields = clusteringModel.getCenterFields();
        if (centerFields != null) {
            throw new UnsupportedFeatureException((PMMLObject)centerFields);
        }
        if (!clusteringModel.hasClusteringFields()) {
            throw new InvalidFeatureException((PMMLObject)clusteringModel);
        }
        if (!clusteringModel.hasClusters()) {
            throw new InvalidFeatureException((PMMLObject)clusteringModel);
        }
        Targets targets = clusteringModel.getTargets();
        if (targets != null) {
            throw new InvalidFeatureException((PMMLObject)targets);
        }
    }

    @Override
    public String getSummary() {
        return "Clustering model";
    }

    @Override
    public Target getTarget(FieldName name) {
        return null;
    }

    @Override
    public BiMap<String, Cluster> getEntityRegistry() {
        if (this.entityRegistry == null) {
            this.entityRegistry = this.getValue(entityCache);
        }
        return this.entityRegistry;
    }

    @Override
    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        Map<FieldName, ClusterAffinityDistribution<?>> predictions;
        ValueFactory<?> valueFactory;
        ClusteringModel clusteringModel = (ClusteringModel)this.getModel();
        if (!clusteringModel.isScorable()) {
            throw new InvalidResultException((PMMLObject)clusteringModel);
        }
        MathContext mathContext = clusteringModel.getMathContext();
        switch (mathContext) {
            case FLOAT: 
            case DOUBLE: {
                valueFactory = this.getValueFactory();
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)clusteringModel, (Enum<?>)mathContext);
            }
        }
        MiningFunction miningFunction = clusteringModel.getMiningFunction();
        switch (miningFunction) {
            case CLUSTERING: {
                predictions = this.evaluateClustering(valueFactory, context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)clusteringModel, (Enum<?>)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private <V extends Number> Map<FieldName, ClusterAffinityDistribution<V>> evaluateClustering(ValueFactory<V> valueFactory, EvaluationContext context) {
        ClusterAffinityDistribution<V> result;
        ClusteringModel clusteringModel = (ClusteringModel)this.getModel();
        ComparisonMeasure comparisonMeasure = clusteringModel.getComparisonMeasure();
        List<ClusteringField> clusteringFields = this.getCenterClusteringFields();
        ArrayList<FieldValue> values = new ArrayList<FieldValue>(clusteringFields.size());
        int max = clusteringFields.size();
        for (int i = 0; i < max; ++i) {
            ClusteringField clusteringField = clusteringFields.get(i);
            FieldValue value = context.evaluate(clusteringField.getField());
            values.add(value);
        }
        Measure measure = comparisonMeasure.getMeasure();
        if (MeasureUtil.isSimilarity(measure)) {
            result = this.evaluateSimilarity(valueFactory, comparisonMeasure, clusteringFields, values);
        } else if (MeasureUtil.isDistance(measure)) {
            result = this.evaluateDistance(valueFactory, comparisonMeasure, clusteringFields, values);
        } else {
            throw new UnsupportedFeatureException((PMMLObject)measure);
        }
        result.computeResult(DataType.STRING);
        return Collections.singletonMap(this.getTargetFieldName(), result);
    }

    private <V extends Number> ClusterAffinityDistribution<V> evaluateSimilarity(ValueFactory<V> valueFactory, ComparisonMeasure comparisonMeasure, List<ClusteringField> clusteringFields, List<FieldValue> values) {
        ClusteringModel clusteringModel = (ClusteringModel)this.getModel();
        List clusters = clusteringModel.getClusters();
        BiMap<String, Cluster> entityRegistry = this.getEntityRegistry();
        ClusterAffinityDistribution<V> result = new ClusterAffinityDistribution<V>(Classification.Type.SIMILARITY, new ValueMap(2 * clusters.size()), entityRegistry);
        BitSet flags = MeasureUtil.toBitSet(values);
        for (Cluster cluster : clusters) {
            BitSet clusterFlags = CacheUtil.getValue(cluster, clusterFlagCache);
            if (flags.size() != clusterFlags.size()) {
                throw new InvalidFeatureException((PMMLObject)cluster);
            }
            Value<V> similarity = MeasureUtil.evaluateSimilarity(valueFactory, comparisonMeasure, clusteringFields, flags, clusterFlags);
            result.put(cluster, similarity);
        }
        return result;
    }

    private <V extends Number> ClusterAffinityDistribution<V> evaluateDistance(ValueFactory<V> valueFactory, ComparisonMeasure comparisonMeasure, List<ClusteringField> clusteringFields, List<FieldValue> values) {
        Value<V> adjustment;
        ClusteringModel clusteringModel = (ClusteringModel)this.getModel();
        List clusters = clusteringModel.getClusters();
        BiMap<String, Cluster> entityRegistry = this.getEntityRegistry();
        MissingValueWeights missingValueWeights = clusteringModel.getMissingValueWeights();
        if (missingValueWeights != null) {
            Array array = missingValueWeights.getArray();
            List<? extends Number> adjustmentValues = ArrayUtil.asNumberList(array);
            if (values.size() != adjustmentValues.size()) {
                throw new InvalidFeatureException((PMMLObject)missingValueWeights);
            }
            adjustment = MeasureUtil.calculateAdjustment(valueFactory, values, adjustmentValues);
        } else {
            adjustment = MeasureUtil.calculateAdjustment(valueFactory, values);
        }
        ClusterAffinityDistribution<V> result = new ClusterAffinityDistribution<V>(Classification.Type.DISTANCE, new ValueMap(2 * clusters.size()), entityRegistry);
        for (Cluster cluster : clusters) {
            List<FieldValue> clusterValues = CacheUtil.getValue(cluster, clusterValueCache);
            if (values.size() != clusterValues.size()) {
                throw new InvalidFeatureException((PMMLObject)cluster);
            }
            Value<V> distance = MeasureUtil.evaluateDistance(valueFactory, comparisonMeasure, clusteringFields, values, clusterValues, adjustment);
            result.put(cluster, distance);
        }
        return result;
    }

    private List<ClusteringField> getCenterClusteringFields() {
        ClusteringModel clusteringModel = (ClusteringModel)this.getModel();
        List clusteringFields = clusteringModel.getClusteringFields();
        ArrayList<ClusteringField> result = new ArrayList<ClusteringField>(clusteringFields.size());
        int max = clusteringFields.size();
        block4: for (int i = 0; i < max; ++i) {
            ClusteringField clusteringField = (ClusteringField)clusteringFields.get(i);
            ClusteringField.CenterField centerField = clusteringField.getCenterField();
            switch (centerField) {
                case TRUE: {
                    result.add(clusteringField);
                    continue block4;
                }
                case FALSE: {
                    continue block4;
                }
                default: {
                    throw new UnsupportedFeatureException((PMMLObject)clusteringField, (Enum<?>)centerField);
                }
            }
        }
        return result;
    }
}

