/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.general_regression;

import org.dmg.pmml.general_regression.GeneralRegressionModel;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Value;

public class GeneralRegressionModelUtil {
    private GeneralRegressionModelUtil() {
    }

    public static <V extends Number> Value<V> computeLink(Value<V> value, Double distParameter, Double linkParameter, GeneralRegressionModel.LinkFunction linkFunction) {
        switch (linkFunction) {
            case CLOGLOG: {
                return value.inverseCloglog();
            }
            case IDENTITY: {
                return value;
            }
            case LOG: {
                return value.exp();
            }
            case LOGC: {
                return value.inverseLogc();
            }
            case LOGIT: {
                return value.inverseLogit();
            }
            case LOGLOG: {
                return value.inverseLoglog();
            }
            case NEGBIN: {
                if (distParameter == null) {
                    throw new EvaluationException();
                }
                return value.inverseNegbin(distParameter);
            }
            case ODDSPOWER: {
                if (linkParameter == null) {
                    throw new EvaluationException();
                }
                return value.inverseOddspower(linkParameter);
            }
            case POWER: {
                if (linkParameter == null) {
                    throw new EvaluationException();
                }
                return value.inversePower(linkParameter);
            }
            case PROBIT: {
                return value.inverseProbit();
            }
        }
        throw new EvaluationException();
    }

    public static <V extends Number> Value<V> computeCumulativeLink(Value<V> value, GeneralRegressionModel.CumulativeLinkFunction cumulativeLinkFunction) {
        switch (cumulativeLinkFunction) {
            case LOGIT: {
                return value.inverseLogit();
            }
            case PROBIT: {
                return value.inverseProbit();
            }
            case CLOGLOG: {
                return value.inverseCloglog();
            }
            case LOGLOG: {
                return value.inverseLoglog();
            }
            case CAUCHIT: {
                return value.inverseCauchit();
            }
        }
        throw new EvaluationException();
    }
}

