/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.mining;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.EmbeddedModel;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.True;
import org.dmg.pmml.TypeDefinitionField;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segment;
import org.dmg.pmml.mining.Segmentation;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.InputField;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.MiningFieldUtil;
import org.jpmml.evaluator.MissingValueException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.evaluator.OutputField;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.PMMLException;
import org.jpmml.evaluator.PredicateUtil;
import org.jpmml.evaluator.ProbabilityDistribution;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.ValueUtil;
import org.jpmml.evaluator.mining.MiningModelEvaluationContext;
import org.jpmml.evaluator.mining.MiningModelUtil;
import org.jpmml.evaluator.mining.SegmentResult;
import org.jpmml.evaluator.mining.VoteDistribution;

public class MiningModelEvaluator
extends ModelEvaluator<MiningModel>
implements HasEntityRegistry<Segment> {
    private ModelEvaluatorFactory modelEvaluatorFactory = null;
    private ConcurrentMap<String, SegmentHandler> segmentHandlers = new ConcurrentHashMap<String, SegmentHandler>();
    private transient BiMap<String, Segment> entityRegistry = null;
    private static final Set<Segmentation.MultipleModelMethod> REGRESSION_METHODS = EnumSet.of(Segmentation.MultipleModelMethod.AVERAGE, new Segmentation.MultipleModelMethod[]{Segmentation.MultipleModelMethod.WEIGHTED_AVERAGE, Segmentation.MultipleModelMethod.MEDIAN, Segmentation.MultipleModelMethod.WEIGHTED_MEDIAN, Segmentation.MultipleModelMethod.SUM, Segmentation.MultipleModelMethod.WEIGHTED_SUM});
    private static final Set<Segmentation.MultipleModelMethod> CLASSIFICATION_METHODS = EnumSet.of(Segmentation.MultipleModelMethod.MAJORITY_VOTE, new Segmentation.MultipleModelMethod[]{Segmentation.MultipleModelMethod.WEIGHTED_MAJORITY_VOTE, Segmentation.MultipleModelMethod.AVERAGE, Segmentation.MultipleModelMethod.WEIGHTED_AVERAGE, Segmentation.MultipleModelMethod.MEDIAN, Segmentation.MultipleModelMethod.MAX});
    private static final Set<Segmentation.MultipleModelMethod> CLUSTERING_METHODS = EnumSet.of(Segmentation.MultipleModelMethod.MAJORITY_VOTE, Segmentation.MultipleModelMethod.WEIGHTED_MAJORITY_VOTE);
    private static final LoadingCache<MiningModel, BiMap<String, Segment>> entityCache = CacheUtil.buildLoadingCache(new CacheLoader<MiningModel, BiMap<String, Segment>>(){

        public BiMap<String, Segment> load(MiningModel miningModel) {
            Segmentation segmentation = miningModel.getSegmentation();
            return EntityUtil.buildBiMap(segmentation.getSegments());
        }
    });

    public MiningModelEvaluator(PMML pmml) {
        this(pmml, MiningModelEvaluator.selectModel(pmml, MiningModel.class));
    }

    public MiningModelEvaluator(PMML pmml, MiningModel miningModel) {
        super(pmml, miningModel);
        if (miningModel.hasEmbeddedModels()) {
            List embeddedModels = miningModel.getEmbeddedModels();
            EmbeddedModel embeddedModel = (EmbeddedModel)embeddedModels.get(0);
            throw new UnsupportedFeatureException((PMMLObject)embeddedModel);
        }
        Segmentation segmentation = miningModel.getSegmentation();
        if (segmentation == null) {
            throw new InvalidFeatureException((PMMLObject)miningModel);
        }
        if (!segmentation.hasSegments()) {
            throw new InvalidFeatureException((PMMLObject)segmentation);
        }
        LocalTransformations localTransformations = segmentation.getLocalTransformations();
        if (localTransformations != null) {
            throw new UnsupportedFeatureException((PMMLObject)localTransformations);
        }
    }

    @Override
    protected void configure(ModelEvaluatorFactory modelEvaluatorFactory) {
        super.configure(modelEvaluatorFactory);
        this.setModelEvaluatorFactory(modelEvaluatorFactory);
    }

    @Override
    public String getSummary() {
        return "Ensemble model";
    }

    @Override
    protected DataField getDataField() {
        MiningModel miningModel = (MiningModel)this.getModel();
        Segmentation segmentation = miningModel.getSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case SELECT_ALL: 
            case SELECT_FIRST: 
            case MODEL_CHAIN: {
                return null;
            }
        }
        return super.getDataField();
    }

    @Override
    public FieldName getTargetFieldName() {
        List<TargetField> targetFields = super.getTargetFields();
        if (targetFields.size() == 0) {
            return Evaluator.DEFAULT_TARGET_NAME;
        }
        return super.getTargetFieldName();
    }

    @Override
    public BiMap<String, Segment> getEntityRegistry() {
        if (this.entityRegistry == null) {
            this.entityRegistry = this.getValue(entityCache);
        }
        return this.entityRegistry;
    }

    @Override
    protected List<OutputField> createOutputFields() {
        List<OutputField> outputFields = super.createOutputFields();
        List<OutputField> nestedOutputFields = this.createNestedOutputFields();
        if (nestedOutputFields.size() > 0) {
            return ImmutableList.copyOf((Iterable)Iterables.concat(nestedOutputFields, outputFields));
        }
        return outputFields;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public Map<FieldName, ?> evaluate(Map<FieldName, ?> arguments) {
        MiningModelEvaluationContext context = new MiningModelEvaluationContext(this);
        context.setArguments(arguments);
        return this.evaluate(context);
    }

    @Override
    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        return this.evaluate((MiningModelEvaluationContext)context);
    }

    public Map<FieldName, ?> evaluate(MiningModelEvaluationContext context) {
        Map<FieldName, ?> predictions;
        ValueFactory<?> valueFactory;
        MiningModel miningModel = (MiningModel)this.getModel();
        if (!miningModel.isScorable()) {
            throw new InvalidResultException((PMMLObject)miningModel);
        }
        MathContext mathContext = miningModel.getMathContext();
        switch (mathContext) {
            case FLOAT: 
            case DOUBLE: {
                valueFactory = this.getValueFactory();
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)miningModel, (Enum<?>)mathContext);
            }
        }
        MiningFunction miningFunction = miningModel.getMiningFunction();
        switch (miningFunction) {
            case REGRESSION: {
                predictions = this.evaluateRegression(valueFactory, context);
                break;
            }
            case CLASSIFICATION: {
                predictions = this.evaluateClassification(valueFactory, context);
                break;
            }
            case CLUSTERING: {
                predictions = this.evaluateClustering(valueFactory, context);
                break;
            }
            default: {
                predictions = this.evaluateAny(context);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private <V extends Number> Map<FieldName, ?> evaluateRegression(ValueFactory<V> valueFactory, MiningModelEvaluationContext context) {
        Value<V> result;
        MiningModel miningModel = (MiningModel)this.getModel();
        List<SegmentResult> segmentResults = this.evaluateSegmentation(context);
        Map<FieldName, ?> predictions = this.getSegmentationResult(REGRESSION_METHODS, segmentResults);
        if (predictions != null) {
            return predictions;
        }
        Segmentation segmentation = miningModel.getSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case AVERAGE: 
            case WEIGHTED_AVERAGE: 
            case MEDIAN: 
            case WEIGHTED_MEDIAN: 
            case SUM: 
            case WEIGHTED_SUM: {
                result = MiningModelUtil.aggregateValues(valueFactory, segmentResults, multipleModelMethod);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
            }
        }
        return TargetUtil.evaluateRegression(this.getTargetField(), result);
    }

    private <V extends Number> Map<FieldName, ?> evaluateClassification(ValueFactory<V> valueFactory, MiningModelEvaluationContext context) {
        ProbabilityDistribution<V> result;
        MiningModel miningModel = (MiningModel)this.getModel();
        List<SegmentResult> segmentResults = this.evaluateSegmentation(context);
        Map<FieldName, ?> predictions = this.getSegmentationResult(CLASSIFICATION_METHODS, segmentResults);
        if (predictions != null) {
            return predictions;
        }
        TargetField targetField = this.getTargetField();
        Segmentation segmentation = miningModel.getSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case MAJORITY_VOTE: 
            case WEIGHTED_MAJORITY_VOTE: {
                ValueMap<String, V> values = MiningModelUtil.aggregateVotes(valueFactory, segmentResults, multipleModelMethod);
                ValueUtil.normalizeSimpleMax(values);
                result = new ProbabilityDistribution<V>(values);
                break;
            }
            case AVERAGE: 
            case WEIGHTED_AVERAGE: 
            case MEDIAN: 
            case MAX: {
                DataField dataField = targetField.getDataField();
                List<String> categories = FieldValueUtil.getTargetCategories((TypeDefinitionField)dataField);
                ValueMap<String, V> values = MiningModelUtil.aggregateProbabilities(valueFactory, segmentResults, categories, multipleModelMethod);
                result = new ProbabilityDistribution<V>(values);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
            }
        }
        return TargetUtil.evaluateClassification(targetField, result);
    }

    private <V extends Number> Map<FieldName, ?> evaluateClustering(ValueFactory<V> valueFactory, MiningModelEvaluationContext context) {
        VoteDistribution<V> result;
        MiningModel miningModel = (MiningModel)this.getModel();
        List<SegmentResult> segmentResults = this.evaluateSegmentation(context);
        Map<FieldName, ?> predictions = this.getSegmentationResult(CLUSTERING_METHODS, segmentResults);
        if (predictions != null) {
            return predictions;
        }
        Segmentation segmentation = miningModel.getSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case MAJORITY_VOTE: 
            case WEIGHTED_MAJORITY_VOTE: {
                ValueMap<String, V> values = MiningModelUtil.aggregateVotes(valueFactory, segmentResults, multipleModelMethod);
                result = new VoteDistribution<V>(values);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
            }
        }
        result.computeResult(DataType.STRING);
        return Collections.singletonMap(this.getTargetFieldName(), result);
    }

    private Map<FieldName, ?> evaluateAny(MiningModelEvaluationContext context) {
        List<SegmentResult> segmentResults = this.evaluateSegmentation(context);
        return this.getSegmentationResult(Collections.emptySet(), segmentResults);
    }

    private List<SegmentResult> evaluateSegmentation(MiningModelEvaluationContext context) {
        MiningModel miningModel = (MiningModel)this.getModel();
        BiMap<String, Segment> entityRegistry = this.getEntityRegistry();
        MiningFunction miningFunction = miningModel.getMiningFunction();
        Segmentation segmentation = miningModel.getSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        Model lastModel = null;
        boolean purge = false;
        ModelEvaluationContext miningModelContext = null;
        ModelEvaluationContext modelContext = null;
        List segments = segmentation.getSegments();
        ArrayList<SegmentResult> segmentResults = new ArrayList<SegmentResult>(segments.size());
        int max = segments.size();
        for (int i = 0; i < max; ++i) {
            SegmentResult segmentResult;
            ModelEvaluationContext segmentContext;
            Segment segment = (Segment)segments.get(i);
            Predicate predicate = segment.getPredicate();
            if (predicate == null) {
                throw new InvalidFeatureException((PMMLObject)segment);
            }
            Boolean status = PredicateUtil.evaluate(predicate, context);
            if (status == null || !status.booleanValue()) continue;
            Model model = segment.getModel();
            if (model == null) {
                throw new InvalidFeatureException((PMMLObject)segment);
            }
            switch (multipleModelMethod) {
                case MODEL_CHAIN: {
                    lastModel = model;
                    break;
                }
                default: {
                    if (miningFunction.equals((Object)model.getMiningFunction())) break;
                    throw new InvalidFeatureException((PMMLObject)model);
                }
            }
            String segmentId = EntityUtil.getId(segment, entityRegistry);
            SegmentHandler segmentHandler = (SegmentHandler)this.segmentHandlers.get(segmentId);
            if (segmentHandler == null) {
                segmentHandler = this.createSegmentHandler(model);
                this.segmentHandlers.putIfAbsent(segmentId, segmentHandler);
            }
            ModelEvaluator<?> segmentModelEvaluator = segmentHandler.getModelEvaluator();
            purge |= !segmentHandler.isCompatible() || !segmentModelEvaluator.isPrimitive();
            if (segmentModelEvaluator instanceof MiningModelEvaluator) {
                MiningModelEvaluator segmentMiningModelEvaluator = (MiningModelEvaluator)segmentModelEvaluator;
                if (miningModelContext == null) {
                    miningModelContext = new MiningModelEvaluationContext(context, segmentMiningModelEvaluator);
                } else {
                    miningModelContext.reset(segmentMiningModelEvaluator, purge);
                }
                segmentContext = miningModelContext;
            } else {
                if (modelContext == null) {
                    modelContext = new ModelEvaluationContext(context, segmentModelEvaluator);
                } else {
                    modelContext.reset(segmentModelEvaluator, purge);
                }
                segmentContext = modelContext;
            }
            segmentContext.setCompatible(segmentHandler.isCompatible());
            try {
                Map<FieldName, ?> result = segmentModelEvaluator.evaluate(segmentContext);
                FieldName segmentTargetFieldName = segmentModelEvaluator.getTargetFieldName();
                segmentResult = new SegmentResult(segment, segmentId, result, segmentTargetFieldName);
            }
            catch (PMMLException pe) {
                pe.ensureContext((PMMLObject)segment);
                throw pe;
            }
            context.putResult(segmentId, segmentResult);
            switch (multipleModelMethod) {
                case MODEL_CHAIN: {
                    List<OutputField> outputFields = segmentModelEvaluator.getOutputFields();
                    for (OutputField outputField : outputFields) {
                        FieldName name = outputField.getName();
                        int depth = outputField.getDepth();
                        if (depth > 0) continue;
                        context.putOutputField(outputField.getOutputField());
                        FieldValue value = segmentContext.getField(name);
                        if (value == null) {
                            throw new MissingValueException(name, (PMMLObject)segment);
                        }
                        context.declare(name, value);
                    }
                    break;
                }
            }
            List<String> segmentWarnings = segmentContext.getWarnings();
            if (segmentWarnings.size() > 0) {
                for (String segmentWarning : segmentWarnings) {
                    context.addWarning(segmentWarning);
                }
            }
            switch (multipleModelMethod) {
                case SELECT_FIRST: {
                    return Collections.singletonList(segmentResult);
                }
            }
            segmentResults.add(segmentResult);
        }
        switch (multipleModelMethod) {
            case MODEL_CHAIN: {
                if (lastModel == null || miningFunction.equals((Object)lastModel.getMiningFunction())) break;
                throw new InvalidFeatureException((PMMLObject)lastModel);
            }
        }
        return segmentResults;
    }

    private Map<FieldName, ?> getSegmentationResult(Set<Segmentation.MultipleModelMethod> multipleModelMethods, List<SegmentResult> segmentResults) {
        MiningModel miningModel = (MiningModel)this.getModel();
        Segmentation segmentation = miningModel.getSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case SELECT_ALL: {
                return MiningModelEvaluator.selectAll(segmentResults);
            }
            case SELECT_FIRST: {
                if (segmentResults.size() <= 0) break;
                return (Map)((Object)segmentResults.get(0));
            }
            case MODEL_CHAIN: {
                if (segmentResults.size() <= 0) break;
                return (Map)((Object)segmentResults.get(segmentResults.size() - 1));
            }
            default: {
                if (multipleModelMethods.contains(multipleModelMethod)) break;
                throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
            }
        }
        if (segmentResults.size() == 0) {
            return Collections.singletonMap(this.getTargetFieldName(), null);
        }
        return null;
    }

    private List<Segment> getActiveHead(List<Segment> segments) {
        int max = segments.size();
        for (int i = 0; i < max; ++i) {
            Segment segment = segments.get(i);
            Predicate predicate = segment.getPredicate();
            if (predicate == null) {
                throw new InvalidFeatureException((PMMLObject)segment);
            }
            if (!(predicate instanceof True)) continue;
            return segments.subList(0, i + 1);
        }
        return segments;
    }

    private List<Segment> getActiveTail(List<Segment> segments) {
        return Lists.reverse(this.getActiveHead(Lists.reverse(segments)));
    }

    private List<OutputField> createNestedOutputFields() {
        MiningModel miningModel = (MiningModel)this.getModel();
        Segmentation segmentation = miningModel.getSegmentation();
        List segments = segmentation.getSegments();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case SELECT_ALL: {
                break;
            }
            case SELECT_FIRST: {
                return this.createNestedOutputFields(this.getActiveHead(segments));
            }
            case MODEL_CHAIN: {
                return this.createNestedOutputFields(this.getActiveTail(segments));
            }
        }
        return Collections.emptyList();
    }

    private List<OutputField> createNestedOutputFields(List<Segment> segments) {
        ArrayList<OutputField> result = new ArrayList<OutputField>();
        BiMap<String, Segment> entityRegistry = this.getEntityRegistry();
        int max = segments.size();
        for (int i = 0; i < max; ++i) {
            Segment segment = segments.get(i);
            Model model = segment.getModel();
            if (model == null) {
                throw new InvalidFeatureException((PMMLObject)segment);
            }
            String segmentId = EntityUtil.getId(segment, entityRegistry);
            SegmentHandler segmentHandler = (SegmentHandler)this.segmentHandlers.get(segmentId);
            if (segmentHandler == null) {
                segmentHandler = this.createSegmentHandler(model);
                this.segmentHandlers.putIfAbsent(segmentId, segmentHandler);
            }
            ModelEvaluator<?> modelEvaluator = segmentHandler.getModelEvaluator();
            List<OutputField> outputFields = modelEvaluator.getOutputFields();
            for (OutputField outputField : outputFields) {
                OutputField nestedOutputField = new OutputField(outputField);
                result.add(nestedOutputField);
            }
        }
        return ImmutableList.copyOf(result);
    }

    private SegmentHandler createSegmentHandler(Model model) {
        ModelEvaluatorFactory modelEvaluatorFactory = this.getModelEvaluatorFactory();
        if (modelEvaluatorFactory == null) {
            modelEvaluatorFactory = ModelEvaluatorFactory.newInstance();
        }
        ModelEvaluator<? extends Model> modelEvaluator = modelEvaluatorFactory.newModelEvaluator(this.getPMML(), model);
        return new SegmentHandler(modelEvaluator);
    }

    public ModelEvaluatorFactory getModelEvaluatorFactory() {
        return this.modelEvaluatorFactory;
    }

    private void setModelEvaluatorFactory(ModelEvaluatorFactory modelEvaluatorFactory) {
        this.modelEvaluatorFactory = modelEvaluatorFactory;
    }

    private static Map<FieldName, ?> selectAll(List<SegmentResult> segmentResults) {
        ArrayListMultimap result = ArrayListMultimap.create();
        LinkedHashSet keys = null;
        for (SegmentResult segmentResult : segmentResults) {
            if (keys == null) {
                keys = new LinkedHashSet(segmentResult.keySet());
            }
            if (!keys.equals(segmentResult.keySet())) {
                throw new EvaluationException();
            }
            for (FieldName key : keys) {
                result.put((Object)key, segmentResult.get(key));
            }
        }
        return result.asMap();
    }

    private static class SegmentHandler
    implements Serializable {
        private ModelEvaluator<?> modelEvaluator = null;
        private boolean compatible = false;

        private SegmentHandler(ModelEvaluator<?> modelEvaluator) {
            this.setModelEvaluator(modelEvaluator);
            boolean compatible = true;
            List<InputField> inputFields = modelEvaluator.getInputFields();
            for (InputField inputField : inputFields) {
                Field field = inputField.getField();
                if (!(field instanceof DataField)) continue;
                MiningField miningField = inputField.getMiningField();
                compatible &= MiningFieldUtil.isDefault(miningField);
            }
            this.setCompatible(compatible);
        }

        public ModelEvaluator<?> getModelEvaluator() {
            return this.modelEvaluator;
        }

        private void setModelEvaluator(ModelEvaluator<?> modelEvaluator) {
            this.modelEvaluator = modelEvaluator;
        }

        public boolean isCompatible() {
            return this.compatible;
        }

        private void setCompatible(boolean compatible) {
            this.compatible = compatible;
        }
    }
}

