/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.neural_network;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Entity;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.HasField;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TypeDefinitionField;
import org.dmg.pmml.neural_network.Connection;
import org.dmg.pmml.neural_network.NeuralInput;
import org.dmg.pmml.neural_network.NeuralInputs;
import org.dmg.pmml.neural_network.NeuralLayer;
import org.dmg.pmml.neural_network.NeuralNetwork;
import org.dmg.pmml.neural_network.NeuralOutput;
import org.dmg.pmml.neural_network.NeuralOutputs;
import org.dmg.pmml.neural_network.Neuron;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.NormalizationUtil;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.neural_network.NeuralNetworkUtil;
import org.jpmml.evaluator.neural_network.NeuronProbabilityDistribution;

public class NeuralNetworkEvaluator
extends ModelEvaluator<NeuralNetwork>
implements HasEntityRegistry<Entity> {
    private transient Map<FieldName, List<NeuralOutput>> neuralOutputMap = null;
    private transient BiMap<String, Entity> entityRegistry = null;
    private static final LoadingCache<NeuralNetwork, BiMap<String, Entity>> entityCache = CacheUtil.buildLoadingCache(new CacheLoader<NeuralNetwork, BiMap<String, Entity>>(){

        public BiMap<String, Entity> load(NeuralNetwork neuralNetwork) {
            ImmutableBiMap.Builder<String, NeuralInput> builder = new ImmutableBiMap.Builder<String, NeuralInput>();
            AtomicInteger index = new AtomicInteger(1);
            NeuralInputs neuralInputs = neuralNetwork.getNeuralInputs();
            for (NeuralInput neuralInput : neuralInputs) {
                builder = EntityUtil.put(neuralInput, index, builder);
            }
            List neuralLayers = neuralNetwork.getNeuralLayers();
            for (NeuralLayer neuralLayer : neuralLayers) {
                List neurons = neuralLayer.getNeurons();
                for (int i = 0; i < neurons.size(); ++i) {
                    Neuron neuron = (Neuron)neurons.get(i);
                    builder = EntityUtil.put(neuron, index, builder);
                }
            }
            return builder.build();
        }
    });

    public NeuralNetworkEvaluator(PMML pmml) {
        this(pmml, NeuralNetworkEvaluator.selectModel(pmml, NeuralNetwork.class));
    }

    public NeuralNetworkEvaluator(PMML pmml, NeuralNetwork neuralNetwork) {
        super(pmml, neuralNetwork);
        NeuralInputs neuralInputs = neuralNetwork.getNeuralInputs();
        if (neuralInputs == null) {
            throw new InvalidFeatureException((PMMLObject)neuralNetwork);
        }
        if (!neuralInputs.hasNeuralInputs()) {
            throw new InvalidFeatureException((PMMLObject)neuralInputs);
        }
        if (!neuralNetwork.hasNeuralLayers()) {
            throw new InvalidFeatureException((PMMLObject)neuralNetwork);
        }
        NeuralOutputs neuralOutputs = neuralNetwork.getNeuralOutputs();
        if (neuralOutputs == null) {
            throw new InvalidFeatureException((PMMLObject)neuralNetwork);
        }
        if (!neuralOutputs.hasNeuralOutputs()) {
            throw new InvalidFeatureException((PMMLObject)neuralOutputs);
        }
    }

    @Override
    public String getSummary() {
        return "Neural network";
    }

    @Override
    public BiMap<String, Entity> getEntityRegistry() {
        if (this.entityRegistry == null) {
            this.entityRegistry = this.getValue(entityCache);
        }
        return this.entityRegistry;
    }

    @Override
    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        Map<FieldName, Object> predictions;
        ValueFactory<?> valueFactory;
        NeuralNetwork neuralNetwork = (NeuralNetwork)this.getModel();
        if (!neuralNetwork.isScorable()) {
            throw new InvalidResultException((PMMLObject)neuralNetwork);
        }
        MathContext mathContext = neuralNetwork.getMathContext();
        switch (mathContext) {
            case FLOAT: 
            case DOUBLE: {
                valueFactory = this.getValueFactory();
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)neuralNetwork, (Enum<?>)mathContext);
            }
        }
        MiningFunction miningFunction = neuralNetwork.getMiningFunction();
        switch (miningFunction) {
            case REGRESSION: {
                predictions = this.evaluateRegression(valueFactory, context);
                break;
            }
            case CLASSIFICATION: {
                predictions = this.evaluateClassification(valueFactory, context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)neuralNetwork, (Enum<?>)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private <V extends Number> Map<FieldName, ?> evaluateRegression(ValueFactory<V> valueFactory, EvaluationContext context) {
        NeuralNetwork neuralNetwork = (NeuralNetwork)this.getModel();
        List<TargetField> targetFields = this.getTargetFields();
        ValueMap<String, V> values = this.evaluateRaw(valueFactory, context);
        if (values == null) {
            if (targetFields.size() == 1) {
                TargetField targetField = targetFields.get(0);
                return TargetUtil.evaluateRegressionDefault(valueFactory, targetField);
            }
            LinkedHashMap results = new LinkedHashMap();
            for (TargetField targetField : targetFields) {
                results.putAll(TargetUtil.evaluateRegressionDefault(valueFactory, targetField));
            }
            return results;
        }
        Map<FieldName, List<NeuralOutput>> neuralOutputMap = this.getNeuralOutputMap();
        LinkedHashMap results = null;
        for (TargetField targetField : targetFields) {
            List<NeuralOutput> neuralOutputs = neuralOutputMap.get(targetField.getName());
            if (neuralOutputs == null || neuralOutputs.size() != 1) {
                throw new InvalidFeatureException((PMMLObject)neuralNetwork);
            }
            NeuralOutput neuralOutput = neuralOutputs.get(0);
            String id = neuralOutput.getOutputNeuron();
            Value value = (Value)values.get(id);
            if (value == null) {
                throw new InvalidFeatureException((PMMLObject)neuralOutput);
            }
            value = value.copy();
            Expression expression = this.getOutputExpression(neuralOutput);
            if (!(expression instanceof FieldRef)) {
                if (expression instanceof NormContinuous) {
                    NormContinuous normContinuous = (NormContinuous)expression;
                    NormalizationUtil.denormalize(normContinuous, value);
                } else {
                    throw new UnsupportedFeatureException((PMMLObject)expression);
                }
            }
            if (targetFields.size() == 1) {
                return TargetUtil.evaluateRegression(targetField, value);
            }
            if (results == null) {
                results = new LinkedHashMap();
            }
            results.putAll(TargetUtil.evaluateRegression(targetField, value));
        }
        return results;
    }

    private <V extends Number> Map<FieldName, ? extends Classification<V>> evaluateClassification(ValueFactory<V> valueFactory, EvaluationContext context) {
        NeuralNetwork neuralNetwork = (NeuralNetwork)this.getModel();
        List<TargetField> targetFields = this.getTargetFields();
        ValueMap<String, V> values = this.evaluateRaw(valueFactory, context);
        if (values == null) {
            if (targetFields.size() == 1) {
                TargetField targetField = targetFields.get(0);
                return TargetUtil.evaluateClassificationDefault(valueFactory, targetField);
            }
            LinkedHashMap<FieldName, Classification<V>> results = new LinkedHashMap<FieldName, Classification<V>>();
            for (TargetField targetField : targetFields) {
                results.putAll(TargetUtil.evaluateClassificationDefault(valueFactory, targetField));
            }
            return results;
        }
        Map<FieldName, List<NeuralOutput>> neuralOutputMap = this.getNeuralOutputMap();
        BiMap<String, Entity> entityRegistry = this.getEntityRegistry();
        LinkedHashMap results = null;
        for (TargetField targetField : targetFields) {
            List<NeuralOutput> neuralOutputs = neuralOutputMap.get(targetField.getName());
            if (neuralOutputs == null) {
                throw new InvalidFeatureException((PMMLObject)neuralNetwork);
            }
            NeuronProbabilityDistribution result = new NeuronProbabilityDistribution(new ValueMap(2 * neuralOutputs.size()), entityRegistry);
            for (NeuralOutput neuralOutput : neuralOutputs) {
                String id = neuralOutput.getOutputNeuron();
                Entity entity = (Entity)entityRegistry.get((Object)id);
                if (entity == null) {
                    throw new InvalidFeatureException((PMMLObject)neuralOutput);
                }
                Value value = (Value)values.get(id);
                if (value == null) {
                    throw new InvalidFeatureException((PMMLObject)neuralOutput);
                }
                Expression expression = this.getOutputExpression(neuralOutput);
                if (expression instanceof NormDiscrete) {
                    NormDiscrete normDiscrete = (NormDiscrete)expression;
                    String targetCategory = normDiscrete.getValue();
                    if (targetCategory == null) {
                        throw new InvalidFeatureException((PMMLObject)normDiscrete);
                    }
                    result.put(entity, targetCategory, value);
                    continue;
                }
                throw new UnsupportedFeatureException((PMMLObject)expression);
            }
            if (targetFields.size() == 1) {
                return TargetUtil.evaluateClassification(targetField, result);
            }
            if (results == null) {
                results = new LinkedHashMap();
            }
            results.putAll(TargetUtil.evaluateClassification(targetField, result));
        }
        return results;
    }

    private Expression getOutputExpression(NeuralOutput neuralOutput) {
        DerivedField derivedField = neuralOutput.getDerivedField();
        if (derivedField == null) {
            throw new InvalidFeatureException((PMMLObject)neuralOutput);
        }
        Expression expression = derivedField.getExpression();
        if (expression == null) {
            throw new InvalidFeatureException((PMMLObject)derivedField);
        }
        if (expression instanceof FieldRef) {
            FieldRef fieldRef = (FieldRef)expression;
            FieldName name = fieldRef.getField();
            TypeDefinitionField field = this.resolveField(name);
            if (field == null) {
                throw new MissingFieldException(name, (PMMLObject)fieldRef);
            }
            if (field instanceof DataField) {
                return expression;
            }
            if (field instanceof DerivedField) {
                DerivedField targetDerivedField = (DerivedField)field;
                Expression targetExpression = targetDerivedField.getExpression();
                if (targetExpression == null) {
                    throw new InvalidFeatureException((PMMLObject)targetDerivedField);
                }
                return targetExpression;
            }
            throw new InvalidFeatureException((PMMLObject)fieldRef);
        }
        return expression;
    }

    private <V extends Number> ValueMap<String, V> evaluateRaw(ValueFactory<V> valueFactory, EvaluationContext context) {
        NeuralNetwork neuralNetwork = (NeuralNetwork)this.getModel();
        BiMap<String, Entity> entityRegistry = this.getEntityRegistry();
        ValueMap<String, Value<V>> result = new ValueMap<String, Value<V>>(2 * entityRegistry.size());
        NeuralInputs neuralInputs = neuralNetwork.getNeuralInputs();
        for (NeuralInput neuralInput : neuralInputs) {
            DerivedField derivedField = neuralInput.getDerivedField();
            if (derivedField == null) {
                throw new InvalidFeatureException((PMMLObject)neuralInput);
            }
            FieldValue value = ExpressionUtil.evaluate(derivedField, context);
            if (value == null) {
                return null;
            }
            Value<V> output = valueFactory.newValue(value.asNumber());
            result.put(neuralInput.getId(), output);
        }
        ArrayList outputs = new ArrayList();
        List neuralLayers = neuralNetwork.getNeuralLayers();
        block11: for (NeuralLayer neuralLayer : neuralLayers) {
            outputs.clear();
            NeuralLayer locatable = neuralLayer;
            NeuralNetwork.ActivationFunction activationFunction = neuralLayer.getActivationFunction();
            if (activationFunction == null) {
                locatable = neuralNetwork;
                activationFunction = neuralNetwork.getActivationFunction();
            }
            if (activationFunction == null) {
                throw new InvalidFeatureException((PMMLObject)neuralLayer);
            }
            Double threshold = neuralLayer.getThreshold();
            if (threshold == null) {
                threshold = neuralNetwork.getThreshold();
            }
            switch (activationFunction) {
                case THRESHOLD: {
                    if (threshold != null) break;
                    throw new InvalidFeatureException((PMMLObject)neuralLayer);
                }
                case LOGISTIC: 
                case TANH: 
                case IDENTITY: 
                case EXPONENTIAL: 
                case RECIPROCAL: 
                case SQUARE: 
                case GAUSS: 
                case SINE: 
                case COSINE: 
                case ELLIOTT: 
                case ARCTAN: 
                case RECTIFIER: {
                    break;
                }
                default: {
                    throw new UnsupportedFeatureException((PMMLObject)locatable, (Enum<?>)activationFunction);
                }
            }
            List neurons = neuralLayer.getNeurons();
            for (int i = 0; i < neurons.size(); ++i) {
                Neuron neuron = (Neuron)neurons.get(i);
                Value<V> output = valueFactory.newValue();
                List connections = neuron.getConnections();
                for (int j = 0; j < connections.size(); ++j) {
                    Connection connection = (Connection)connections.get(j);
                    Value input = (Value)result.get(connection.getFrom());
                    if (input == null) {
                        throw new InvalidFeatureException((PMMLObject)connection);
                    }
                    output.add(connection.getWeight(), (Number)input.getValue());
                }
                Double bias = neuron.getBias();
                if (bias != null) {
                    output.add(bias);
                }
                switch (activationFunction) {
                    case THRESHOLD: 
                    case LOGISTIC: 
                    case TANH: 
                    case IDENTITY: 
                    case EXPONENTIAL: 
                    case RECIPROCAL: 
                    case SQUARE: 
                    case GAUSS: 
                    case SINE: 
                    case COSINE: 
                    case ELLIOTT: 
                    case ARCTAN: 
                    case RECTIFIER: {
                        NeuralNetworkUtil.activateNeuronOutput(output, threshold, activationFunction);
                        break;
                    }
                    default: {
                        throw new UnsupportedFeatureException((PMMLObject)locatable, (Enum<?>)activationFunction);
                    }
                }
                result.put(neuron.getId(), output);
                outputs.add(output);
            }
            locatable = neuralLayer;
            NeuralNetwork.NormalizationMethod normalizationMethod = neuralLayer.getNormalizationMethod();
            if (normalizationMethod == null) {
                locatable = neuralNetwork;
                normalizationMethod = neuralNetwork.getNormalizationMethod();
            }
            switch (normalizationMethod) {
                case NONE: 
                case SIMPLEMAX: 
                case SOFTMAX: {
                    NeuralNetworkUtil.normalizeNeuralLayerOutputs(outputs, normalizationMethod);
                    continue block11;
                }
            }
            throw new UnsupportedFeatureException((PMMLObject)locatable, (Enum<?>)normalizationMethod);
        }
        return result;
    }

    private Map<FieldName, List<NeuralOutput>> getNeuralOutputMap() {
        if (this.neuralOutputMap == null) {
            this.neuralOutputMap = this.parseNeuralOutputs();
        }
        return this.neuralOutputMap;
    }

    private Map<FieldName, List<NeuralOutput>> parseNeuralOutputs() {
        NeuralNetwork neuralNetwork = (NeuralNetwork)this.getModel();
        NeuralOutputs neuralOutputs = neuralNetwork.getNeuralOutputs();
        if (neuralOutputs == null) {
            return Collections.emptyMap();
        }
        ArrayListMultimap result = ArrayListMultimap.create();
        for (NeuralOutput neuralOutput : neuralOutputs) {
            Expression expression = this.getOutputExpression(neuralOutput);
            if (!(expression instanceof HasField)) {
                throw new UnsupportedFeatureException((PMMLObject)expression);
            }
            HasField hasField = (HasField)expression;
            FieldName name = hasField.getField();
            if (name == null) {
                throw new InvalidFeatureException((PMMLObject)expression);
            }
            result.put((Object)name, (Object)neuralOutput);
        }
        return result.asMap();
    }
}

