/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.rule_set;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.rule_set.CompoundRule;
import org.dmg.pmml.rule_set.Rule;
import org.dmg.pmml.rule_set.RuleSelectionMethod;
import org.dmg.pmml.rule_set.RuleSet;
import org.dmg.pmml.rule_set.RuleSetModel;
import org.dmg.pmml.rule_set.SimpleRule;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.PredicateUtil;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.rule_set.SimpleRuleScoreDistribution;

public class RuleSetModelEvaluator
extends ModelEvaluator<RuleSetModel>
implements HasEntityRegistry<SimpleRule> {
    private transient BiMap<String, SimpleRule> entityRegistry = null;
    private static final LoadingCache<RuleSetModel, BiMap<String, SimpleRule>> entityCache = CacheUtil.buildLoadingCache(new CacheLoader<RuleSetModel, BiMap<String, SimpleRule>>(){

        public BiMap<String, SimpleRule> load(RuleSetModel ruleSetModel) {
            ImmutableBiMap.Builder<String, SimpleRule> builder = new ImmutableBiMap.Builder<String, SimpleRule>();
            RuleSet ruleSet = ruleSetModel.getRuleSet();
            builder = this.collectRules(ruleSet.getRules(), new AtomicInteger(1), builder);
            return builder.build();
        }

        private ImmutableBiMap.Builder<String, SimpleRule> collectRule(Rule rule, AtomicInteger index, ImmutableBiMap.Builder<String, SimpleRule> builder) {
            if (rule instanceof SimpleRule) {
                SimpleRule simpleRule = (SimpleRule)rule;
                builder = EntityUtil.put(simpleRule, index, builder);
            } else if (rule instanceof CompoundRule) {
                CompoundRule compoundRule = (CompoundRule)rule;
                builder = this.collectRules(compoundRule.getRules(), index, builder);
            } else {
                throw new UnsupportedFeatureException((PMMLObject)rule);
            }
            return builder;
        }

        private ImmutableBiMap.Builder<String, SimpleRule> collectRules(List<Rule> rules, AtomicInteger index, ImmutableBiMap.Builder<String, SimpleRule> builder) {
            for (Rule rule : rules) {
                builder = this.collectRule(rule, index, builder);
            }
            return builder;
        }
    });

    public RuleSetModelEvaluator(PMML pmml) {
        this(pmml, RuleSetModelEvaluator.selectModel(pmml, RuleSetModel.class));
    }

    public RuleSetModelEvaluator(PMML pmml, RuleSetModel ruleSetModel) {
        super(pmml, ruleSetModel);
        RuleSet ruleSet = ruleSetModel.getRuleSet();
        if (ruleSet == null) {
            throw new InvalidFeatureException((PMMLObject)ruleSetModel);
        }
        if (!ruleSet.hasRuleSelectionMethods()) {
            throw new InvalidFeatureException((PMMLObject)ruleSet);
        }
    }

    @Override
    public String getSummary() {
        return "Ruleset model";
    }

    @Override
    public BiMap<String, SimpleRule> getEntityRegistry() {
        if (this.entityRegistry == null) {
            this.entityRegistry = this.getValue(entityCache);
        }
        return this.entityRegistry;
    }

    @Override
    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        Map<FieldName, Classification<?>> predictions;
        ValueFactory<?> valueFactory;
        RuleSetModel ruleSetModel = (RuleSetModel)this.getModel();
        if (!ruleSetModel.isScorable()) {
            throw new InvalidResultException((PMMLObject)ruleSetModel);
        }
        MathContext mathContext = ruleSetModel.getMathContext();
        switch (mathContext) {
            case FLOAT: 
            case DOUBLE: {
                valueFactory = this.getValueFactory();
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)ruleSetModel, (Enum<?>)mathContext);
            }
        }
        MiningFunction miningFunction = ruleSetModel.getMiningFunction();
        switch (miningFunction) {
            case CLASSIFICATION: {
                predictions = this.evaluateClassification(valueFactory, context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)ruleSetModel, (Enum<?>)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private <V extends Number> Map<FieldName, ? extends Classification<V>> evaluateClassification(ValueFactory<V> valueFactory, EvaluationContext context) {
        RuleSetModel ruleSetModel = (RuleSetModel)this.getModel();
        RuleSet ruleSet = ruleSetModel.getRuleSet();
        List ruleSelectionMethods = ruleSet.getRuleSelectionMethods();
        if (ruleSelectionMethods.size() < 1) {
            throw new InvalidFeatureException((PMMLObject)ruleSet);
        }
        TargetField targetField = this.getTargetField();
        RuleSelectionMethod ruleSelectionMethod = (RuleSelectionMethod)ruleSelectionMethods.get(0);
        LinkedListMultimap firedRules = LinkedListMultimap.create();
        RuleSetModelEvaluator.evaluateRules(ruleSet.getRules(), (ListMultimap<String, SimpleRule>)firedRules, context);
        BiMap<String, SimpleRule> entityRegistry = this.getEntityRegistry();
        SimpleRuleScoreDistribution<V> result = new SimpleRuleScoreDistribution<V>(new ValueMap(2 * firedRules.size()), entityRegistry);
        if (firedRules.size() == 0) {
            String defaultScore = ruleSet.getDefaultScore();
            Double defaultConfidence = ruleSet.getDefaultConfidence();
            if (defaultScore == null || defaultConfidence == null) {
                throw new InvalidFeatureException((PMMLObject)ruleSet);
            }
            Value<V> value = valueFactory.newValue(defaultConfidence);
            result.put(new SimpleRule(defaultScore), defaultScore, value);
            return TargetUtil.evaluateClassification(targetField, result);
        }
        RuleSelectionMethod.Criterion criterion = ruleSelectionMethod.getCriterion();
        Set keys = firedRules.keySet();
        block5: for (String key : keys) {
            List keyRules = firedRules.get((Object)key);
            switch (criterion) {
                case FIRST_HIT: {
                    SimpleRule winner = (SimpleRule)keyRules.get(0);
                    if (result.getEntity() == null) {
                        result.setEntity(winner);
                    }
                    Value<V> value = valueFactory.newValue(winner.getConfidence());
                    result.put(key, value);
                    continue block5;
                }
                case WEIGHTED_SUM: {
                    SimpleRule winner = null;
                    Value<V> totalWeight = valueFactory.newValue();
                    for (SimpleRule keyRule : keyRules) {
                        if (winner == null || winner.getWeight() < keyRule.getWeight()) {
                            winner = keyRule;
                        }
                        totalWeight.add(keyRule.getWeight());
                    }
                    Value<V> value = totalWeight.divide(firedRules.size());
                    result.put(winner, key, value);
                    continue block5;
                }
                case WEIGHTED_MAX: {
                    SimpleRule winner = null;
                    for (SimpleRule keyRule : keyRules) {
                        if (winner != null && !(winner.getWeight() < keyRule.getWeight())) continue;
                        winner = keyRule;
                    }
                    Value<V> value = valueFactory.newValue(winner.getConfidence());
                    result.put(winner, key, value);
                    continue block5;
                }
            }
            throw new UnsupportedFeatureException((PMMLObject)ruleSelectionMethod, (Enum<?>)criterion);
        }
        return TargetUtil.evaluateClassification(targetField, result);
    }

    private static void evaluateRule(Rule rule, ListMultimap<String, SimpleRule> firedRules, EvaluationContext context) {
        Predicate predicate = rule.getPredicate();
        if (predicate == null) {
            throw new InvalidFeatureException((PMMLObject)rule);
        }
        Boolean status = PredicateUtil.evaluate(predicate, context);
        if (status == null || !status.booleanValue()) {
            return;
        }
        if (rule instanceof SimpleRule) {
            SimpleRule simpleRule = (SimpleRule)rule;
            firedRules.put((Object)simpleRule.getScore(), (Object)simpleRule);
        } else if (rule instanceof CompoundRule) {
            CompoundRule compoundRule = (CompoundRule)rule;
            RuleSetModelEvaluator.evaluateRules(compoundRule.getRules(), firedRules, context);
        } else {
            throw new UnsupportedFeatureException((PMMLObject)rule);
        }
    }

    private static void evaluateRules(List<Rule> rules, ListMultimap<String, SimpleRule> firedRules, EvaluationContext context) {
        for (Rule rule : rules) {
            RuleSetModelEvaluator.evaluateRule(rule, firedRules, context);
        }
    }
}

