/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Map;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.model.Property;
import org.jpmml.schema.Extension;

@Extension
public abstract class JavaModel
extends Model {
    private String modelName = null;
    private MiningFunction miningFunction = null;
    private String algorithmName = null;
    private Boolean scorable = null;
    private MathContext mathContext = null;
    private MiningSchema miningSchema = null;
    private LocalTransformations localTransformations = null;
    private Targets targets = null;
    private Output output = null;
    private ModelStats modelStats = null;
    private ModelExplanation modelExplanation = null;
    private ModelVerification modelVerification = null;

    public JavaModel() {
    }

    public JavaModel(MiningFunction miningFunction, MiningSchema miningSchema) {
        this.setMiningFunction(miningFunction);
        this.setMiningSchema(miningSchema);
    }

    public JavaModel(Model model) {
        this.setModelName(model.getModelName());
        this.setMiningFunction(model.getMiningFunction());
        this.setAlgorithmName(model.getAlgorithmName());
        this.setScorable(model.isScorable());
        this.setMathContext(model.getMathContext());
        this.setMiningSchema(model.getMiningSchema());
        this.setLocalTransformations(model.getLocalTransformations());
        this.setTargets(model.getTargets());
        this.setOutput(model.getOutput());
        this.setModelStats(model.getModelStats());
        this.setModelExplanation(model.getModelExplanation());
        this.setModelVerification(model.getModelVerification());
    }

    public abstract Map<FieldName, ?> evaluate(ModelEvaluationContext var1);

    public String getModelName() {
        return this.modelName;
    }

    public JavaModel setModelName(@Property(value="modelName") String modelName) {
        this.modelName = modelName;
        return this;
    }

    public MiningFunction getMiningFunction() {
        return this.miningFunction;
    }

    public JavaModel setMiningFunction(@Property(value="miningFunction") MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public JavaModel setAlgorithmName(@Property(value="algorithmName") String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public boolean isScorable() {
        if (this.scorable == null) {
            return true;
        }
        return this.scorable;
    }

    public JavaModel setScorable(@Property(value="scorable") Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    public MathContext getMathContext() {
        if (this.mathContext == null) {
            return MathContext.DOUBLE;
        }
        return this.mathContext;
    }

    public JavaModel setMathContext(MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    public JavaModel setMiningSchema(@Property(value="miningSchema") MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    public JavaModel setLocalTransformations(@Property(value="localTransformations") LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public Targets getTargets() {
        return this.targets;
    }

    public JavaModel setTargets(@Property(value="targets") Targets targets) {
        this.targets = targets;
        return this;
    }

    public Output getOutput() {
        return this.output;
    }

    public JavaModel setOutput(@Property(value="output") Output output) {
        this.output = output;
        return this;
    }

    public ModelStats getModelStats() {
        return this.modelStats;
    }

    public JavaModel setModelStats(@Property(value="modelStats") ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    public ModelExplanation getModelExplanation() {
        return this.modelExplanation;
    }

    public JavaModel setModelExplanation(@Property(value="modelExplanation") ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    public JavaModel setModelVerification(@Property(value="modelVerification") ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    public VisitorAction accept(Visitor visitor) {
        visitor.pushParent((PMMLObject)this);
        VisitorAction status = PMMLObject.traverse((Visitor)visitor, (Visitable[])new Visitable[]{this.getMiningSchema(), this.getLocalTransformations(), this.getTargets(), this.getOutput(), this.getModelStats(), this.getModelExplanation(), this.getModelVerification()});
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

