/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.association;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Target;
import org.dmg.pmml.Targets;
import org.dmg.pmml.TypeDefinitionField;
import org.dmg.pmml.association.AssociationModel;
import org.dmg.pmml.association.AssociationRule;
import org.dmg.pmml.association.Item;
import org.dmg.pmml.association.ItemRef;
import org.dmg.pmml.association.Itemset;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.FieldValues;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.HasGroupFields;
import org.jpmml.evaluator.IndexableUtil;
import org.jpmml.evaluator.InputField;
import org.jpmml.evaluator.InvalidAttributeException;
import org.jpmml.evaluator.MisplacedElementException;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingValueException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.PMMLAttributes;
import org.jpmml.evaluator.PMMLException;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.association.Association;

public class AssociationModelEvaluator
extends ModelEvaluator<AssociationModel>
implements HasGroupFields,
HasEntityRegistry<AssociationRule> {
    private transient List<InputField> groupInputFields = null;
    private transient BiMap<String, AssociationRule> entityRegistry = null;
    private transient Map<String, Item> items = null;
    private transient Map<String, Itemset> itemsets = null;
    private transient List<ItemValue> itemValues = null;
    private static final LoadingCache<AssociationModel, BiMap<String, AssociationRule>> entityCache = CacheUtil.buildLoadingCache(new CacheLoader<AssociationModel, BiMap<String, AssociationRule>>(){

        public BiMap<String, AssociationRule> load(AssociationModel associationModel) {
            return EntityUtil.buildBiMap(associationModel.getAssociationRules());
        }
    });
    private static final LoadingCache<AssociationModel, Map<String, Item>> itemCache = CacheUtil.buildLoadingCache(new CacheLoader<AssociationModel, Map<String, Item>>(){

        public Map<String, Item> load(AssociationModel associationModel) {
            return IndexableUtil.buildMap(associationModel.getItems());
        }
    });
    private static final LoadingCache<AssociationModel, Map<String, Itemset>> itemsetCache = CacheUtil.buildLoadingCache(new CacheLoader<AssociationModel, Map<String, Itemset>>(){

        public Map<String, Itemset> load(AssociationModel associationModel) {
            return IndexableUtil.buildMap(associationModel.getItemsets());
        }
    });
    private static final Cache<AssociationModel, List<ItemValue>> itemValueCache = CacheUtil.buildCache();

    public AssociationModelEvaluator(PMML pmml) {
        this(pmml, AssociationModelEvaluator.selectModel(pmml, AssociationModel.class));
    }

    public AssociationModelEvaluator(PMML pmml, AssociationModel associationModel) {
        super(pmml, associationModel);
        Targets targets = associationModel.getTargets();
        if (targets != null) {
            throw new MisplacedElementException((PMMLObject)targets);
        }
    }

    @Override
    public String getSummary() {
        return "Association rules";
    }

    @Override
    public List<InputField> getGroupFields() {
        if (this.groupInputFields == null) {
            this.groupInputFields = this.createInputFields(MiningField.UsageType.GROUP);
        }
        return this.groupInputFields;
    }

    @Override
    public Target getTarget(FieldName name) {
        return null;
    }

    @Override
    public FieldName getTargetFieldName() {
        return Evaluator.DEFAULT_TARGET_NAME;
    }

    @Override
    public BiMap<String, AssociationRule> getEntityRegistry() {
        if (this.entityRegistry == null) {
            this.entityRegistry = this.getValue(entityCache);
        }
        return this.entityRegistry;
    }

    @Override
    protected List<TargetField> createTargetFields() {
        List<TargetField> targetFields = super.createTargetFields();
        if (targetFields.size() > 0) {
            throw this.createMiningSchemaException("Expected 0 target fields, got " + targetFields.size() + " target fields");
        }
        return targetFields;
    }

    @Override
    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        Map<FieldName, Association> predictions;
        AssociationModel associationModel = (AssociationModel)this.ensureScorableModel();
        MathContext mathContext = associationModel.getMathContext();
        switch (mathContext) {
            case DOUBLE: {
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)associationModel, (Enum<?>)mathContext);
            }
        }
        MiningFunction miningFunction = associationModel.getMiningFunction();
        switch (miningFunction) {
            case ASSOCIATION_RULES: {
                predictions = this.evaluateAssociationRules(context);
                break;
            }
            case SEQUENCES: 
            case CLASSIFICATION: 
            case REGRESSION: 
            case CLUSTERING: 
            case TIME_SERIES: 
            case MIXED: {
                throw new InvalidAttributeException((PMMLObject)associationModel, (Enum<?>)miningFunction);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)associationModel, (Enum<?>)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, Association> evaluateAssociationRules(EvaluationContext context) {
        AssociationModel associationModel = (AssociationModel)this.getModel();
        Set<String> activeItems = this.getActiveItemIds(context);
        HashMap<String, Boolean> flags = new HashMap<String, Boolean>();
        List itemsets = associationModel.getItemsets();
        for (Itemset itemset : itemsets) {
            flags.put(itemset.getId(), AssociationModelEvaluator.isSubset(activeItems, itemset));
        }
        List associationRules = associationModel.getAssociationRules();
        BitSet antecedentFlags = new BitSet(associationRules.size());
        BitSet consequentFlags = new BitSet(associationRules.size());
        for (int i = 0; i < associationRules.size(); ++i) {
            AssociationRule associationRule = (AssociationRule)associationRules.get(i);
            String antecedent = associationRule.getAntecedent();
            if (antecedent == null) {
                throw new MissingAttributeException((PMMLObject)associationRule, PMMLAttributes.ASSOCIATIONRULE_ANTECEDENT);
            }
            Boolean antecedentFlag = (Boolean)flags.get(antecedent);
            if (antecedentFlag == null) {
                throw new InvalidAttributeException((PMMLObject)associationRule, PMMLAttributes.ASSOCIATIONRULE_ANTECEDENT, antecedent);
            }
            antecedentFlags.set(i, antecedentFlag);
            String consequent = associationRule.getConsequent();
            if (consequent == null) {
                throw new MissingAttributeException((PMMLObject)associationRule, PMMLAttributes.ASSOCIATIONRULE_CONSEQUENT);
            }
            Boolean consequentFlag = (Boolean)flags.get(consequent);
            if (consequentFlag == null) {
                throw new InvalidAttributeException((PMMLObject)associationRule, PMMLAttributes.ASSOCIATIONRULE_CONSEQUENT, consequent);
            }
            consequentFlags.set(i, consequentFlag);
        }
        Association association = new Association(associationRules, antecedentFlags, consequentFlags){

            @Override
            public Map<String, Item> getItems() {
                return AssociationModelEvaluator.this.getItems();
            }

            @Override
            public Map<String, Itemset> getItemsets() {
                return AssociationModelEvaluator.this.getItemsets();
            }

            @Override
            public BiMap<String, AssociationRule> getAssociationRuleRegistry() {
                return AssociationModelEvaluator.this.getEntityRegistry();
            }
        };
        return Collections.singletonMap(this.getTargetFieldName(), association);
    }

    Set<String> getActiveItemIds(EvaluationContext context) {
        AssociationModel associationModel = (AssociationModel)this.getModel();
        List<InputField> activeFields = this.getActiveFields();
        List<InputField> groupFields = this.getGroupFields();
        HashSet<String> result = new HashSet<String>();
        HashMap explodedValues = null;
        List<ItemValue> itemValues = this.getItemValues();
        for (ItemValue itemValue : itemValues) {
            String id = itemValue.getId();
            FieldName name = itemValue.getField();
            String category = itemValue.getCategory();
            FieldValue value = context.evaluate(name);
            if (groupFields.size() == 0) {
                if (value == null) continue;
                if (category == null) {
                    if (FieldValues.CATEGORICAL_BOOLEAN_TRUE.equalsValue(value) || value.equalsString("T")) {
                        result.add(id);
                        continue;
                    }
                    if (FieldValues.CATEGORICAL_BOOLEAN_FALSE.equalsValue(value) || value.equalsString("F")) continue;
                    throw new EvaluationException("Expected " + PMMLException.formatValue(FieldValues.CATEGORICAL_BOOLEAN_FALSE) + " or " + PMMLException.formatValue(FieldValues.CATEGORICAL_BOOLEAN_TRUE) + ", got " + PMMLException.formatValue(value));
                }
                if (!value.equalsString(category)) continue;
                result.add(id);
                continue;
            }
            if (groupFields.size() == 1) {
                HashSet<FieldValue> explodedValue;
                if (value == null) {
                    throw new MissingValueException(name);
                }
                if (explodedValues == null) {
                    explodedValues = new HashMap();
                }
                if ((explodedValue = (HashSet<FieldValue>)explodedValues.get(name)) == null) {
                    explodedValue = new HashSet<FieldValue>();
                    Collection objects = FieldValueUtil.getValue(Collection.class, value);
                    for (Object object : objects) {
                        explodedValue.add(FieldValueUtil.create(value.getDataType(), value.getOpType(), object));
                    }
                }
                if (category == null) {
                    throw new IllegalStateException();
                }
                FieldValue categoryValue = FieldValueUtil.create(value.getDataType(), value.getOpType(), category);
                if (!explodedValue.contains(categoryValue)) continue;
                result.add(id);
                continue;
            }
            throw this.createMiningSchemaException("Expected 0 or 1 group field(s), got " + groupFields.size() + " group fields");
        }
        return result;
    }

    private static boolean isSubset(Set<String> items, Itemset itemset) {
        boolean result = true;
        List itemRefs = itemset.getItemRefs();
        for (ItemRef itemRef : itemRefs) {
            if (result &= items.contains(itemRef.getItemRef())) continue;
            return false;
        }
        return result;
    }

    private Map<String, Item> getItems() {
        if (this.items == null) {
            this.items = this.getValue(itemCache);
        }
        return this.items;
    }

    private Map<String, Itemset> getItemsets() {
        if (this.itemsets == null) {
            this.itemsets = this.getValue(itemsetCache);
        }
        return this.itemsets;
    }

    private List<ItemValue> getItemValues() {
        if (this.itemValues == null) {
            this.itemValues = this.getValue(itemValueCache, AssociationModelEvaluator.createItemValueLoader(this));
        }
        return this.itemValues;
    }

    private static Callable<List<ItemValue>> createItemValueLoader(final AssociationModelEvaluator modelEvaluator) {
        return new Callable<List<ItemValue>>(){

            @Override
            public List<ItemValue> call() {
                return AssociationModelEvaluator.parseItemValues(modelEvaluator);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<ItemValue> parseItemValues(AssociationModelEvaluator modelEvaluator) {
        AssociationModel associationModel = (AssociationModel)modelEvaluator.getModel();
        List<InputField> activeFields = modelEvaluator.getActiveFields();
        List<InputField> groupFields = modelEvaluator.getGroupFields();
        ArrayList<ItemValue> result = new ArrayList<ItemValue>();
        List items = associationModel.getItems();
        for (Item item : items) {
            String id = item.getId();
            if (id == null) {
                throw new MissingAttributeException((PMMLObject)item, PMMLAttributes.ITEM_ID);
            }
            String value = item.getValue();
            if (value == null) {
                throw new MissingAttributeException((PMMLObject)item, PMMLAttributes.ITEM_VALUE);
            }
            FieldName name = item.getField();
            String category = item.getCategory();
            if (name == null) {
                if (groupFields.size() == 0) {
                    if (activeFields.size() < 1) {
                        throw modelEvaluator.createMiningSchemaException("Expected 1 or more active field(s), got " + activeFields.size() + " active fields");
                    }
                    name = FieldName.create((String)value);
                    category = null;
                    TypeDefinitionField field = modelEvaluator.resolveField(name);
                    if (field == null) {
                        int index = value.indexOf(61);
                        if (index <= -1) throw new InvalidAttributeException((PMMLObject)item, PMMLAttributes.ITEM_VALUE, value);
                        name = FieldName.create((String)value.substring(0, index));
                        category = value.substring(index + 1);
                        field = modelEvaluator.resolveField(name);
                        if (field == null) {
                            throw new InvalidAttributeException((PMMLObject)item, PMMLAttributes.ITEM_VALUE, value);
                        }
                    }
                } else {
                    if (groupFields.size() != 1) throw modelEvaluator.createMiningSchemaException("Expected 0 or 1 group field(s), got " + groupFields.size() + " group fields");
                    if (activeFields.size() != 1) {
                        throw modelEvaluator.createMiningSchemaException("Expected 1 active field, got " + activeFields.size() + " active fields");
                    }
                    InputField activeField = activeFields.get(0);
                    name = activeField.getName();
                    category = value;
                }
            } else if ((groupFields.size() != 1 || category == null) && category == null) {
                throw new MissingAttributeException((PMMLObject)item, PMMLAttributes.ITEM_CATEGORY);
            }
            ItemValue itemValue = new ItemValue(id, name, category);
            result.add(itemValue);
        }
        return ImmutableList.copyOf(result);
    }

    private static class ItemValue {
        private String id = null;
        private FieldName field = null;
        private String category = null;

        private ItemValue(String id, FieldName field, String category) {
            this.setId(id);
            this.setField(field);
            this.setCategory(category);
        }

        private String getId() {
            return this.id;
        }

        private void setId(String id) {
            this.id = id;
        }

        private FieldName getField() {
            return this.field;
        }

        private void setField(FieldName field) {
            this.field = field;
        }

        private String getCategory() {
            return this.category;
        }

        private void setCategory(String category) {
            this.category = category;
        }
    }
}

