/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.mining;

import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.mining.Segmentation;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.ProbabilityAggregator;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueAggregator;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.VoteAggregator;
import org.jpmml.evaluator.mining.SegmentResult;

public class MiningModelUtil {
    private MiningModelUtil() {
    }

    public static <V extends Number> Value<V> aggregateValues(ValueFactory<V> valueFactory, List<SegmentResult> segmentResults, Segmentation.MultipleModelMethod multipleModelMethod) {
        ValueAggregator<V> aggregator;
        switch (multipleModelMethod) {
            case AVERAGE: 
            case SUM: {
                aggregator = new ValueAggregator<V>(valueFactory.newVector(0));
                break;
            }
            case MEDIAN: {
                aggregator = new ValueAggregator<V>(valueFactory.newVector(segmentResults.size()));
                break;
            }
            case WEIGHTED_AVERAGE: 
            case WEIGHTED_SUM: {
                aggregator = new ValueAggregator<V>(valueFactory.newVector(0), valueFactory.newVector(0), valueFactory.newVector(0));
                break;
            }
            case WEIGHTED_MEDIAN: {
                aggregator = new ValueAggregator<V>(valueFactory.newVector(segmentResults.size()), valueFactory.newVector(segmentResults.size()));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        block20: for (SegmentResult segmentResult : segmentResults) {
            Number value;
            try {
                Object targetValue = EvaluatorUtil.decode(segmentResult.getTargetValue());
                value = targetValue instanceof Number ? (Number)((Number)targetValue) : (Number)((Double)TypeUtil.cast(DataType.DOUBLE, targetValue));
            }
            catch (TypeCheckException tce) {
                throw tce.ensureContext((PMMLObject)segmentResult.getSegment());
            }
            switch (multipleModelMethod) {
                case AVERAGE: 
                case SUM: 
                case MEDIAN: {
                    aggregator.add(value);
                    continue block20;
                }
                case WEIGHTED_AVERAGE: 
                case WEIGHTED_SUM: 
                case WEIGHTED_MEDIAN: {
                    double weight = segmentResult.getWeight();
                    aggregator.add(value, weight);
                    continue block20;
                }
            }
            throw new IllegalArgumentException();
        }
        switch (multipleModelMethod) {
            case AVERAGE: {
                return aggregator.average();
            }
            case WEIGHTED_AVERAGE: {
                return aggregator.weightedAverage();
            }
            case SUM: {
                return aggregator.sum();
            }
            case WEIGHTED_SUM: {
                return aggregator.weightedSum();
            }
            case MEDIAN: {
                return aggregator.median();
            }
            case WEIGHTED_MEDIAN: {
                return aggregator.weightedMedian();
            }
        }
        throw new IllegalArgumentException();
    }

    public static <V extends Number> ValueMap<String, V> aggregateVotes(final ValueFactory<V> valueFactory, List<SegmentResult> segmentResults, Segmentation.MultipleModelMethod multipleModelMethod) {
        VoteAggregator aggregator = new VoteAggregator<String, V>(){

            @Override
            public ValueFactory<V> getValueFactory() {
                return valueFactory;
            }
        };
        block6: for (SegmentResult segmentResult : segmentResults) {
            String key;
            try {
                Object targetValue = EvaluatorUtil.decode(segmentResult.getTargetValue());
                key = (String)TypeUtil.cast(DataType.STRING, targetValue);
            }
            catch (TypeCheckException tce) {
                throw tce.ensureContext((PMMLObject)segmentResult.getSegment());
            }
            switch (multipleModelMethod) {
                case MAJORITY_VOTE: {
                    aggregator.add(key);
                    continue block6;
                }
                case WEIGHTED_MAJORITY_VOTE: {
                    double weight = segmentResult.getWeight();
                    aggregator.add(key, weight);
                    continue block6;
                }
            }
            throw new IllegalArgumentException();
        }
        return aggregator.sumMap();
    }

    public static <V extends Number> ValueMap<String, V> aggregateProbabilities(final ValueFactory<V> valueFactory, List<SegmentResult> segmentResults, List<String> categories, Segmentation.MultipleModelMethod multipleModelMethod) {
        ProbabilityAggregator aggregator;
        switch (multipleModelMethod) {
            case AVERAGE: {
                aggregator = new ProbabilityAggregator<V>(0){

                    @Override
                    public ValueFactory<V> getValueFactory() {
                        return valueFactory;
                    }
                };
                break;
            }
            case WEIGHTED_AVERAGE: {
                aggregator = new ProbabilityAggregator<V>(0, valueFactory.newVector(0)){

                    @Override
                    public ValueFactory<V> getValueFactory() {
                        return valueFactory;
                    }
                };
                break;
            }
            case MEDIAN: 
            case MAX: {
                aggregator = new ProbabilityAggregator<V>(segmentResults.size()){

                    @Override
                    public ValueFactory<V> getValueFactory() {
                        return valueFactory;
                    }
                };
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        block17: for (SegmentResult segmentResult : segmentResults) {
            HasProbability hasProbability;
            try {
                Object targetValue = segmentResult.getTargetValue();
                hasProbability = TypeUtil.cast(HasProbability.class, targetValue);
            }
            catch (TypeCheckException tce) {
                throw tce.ensureContext((PMMLObject)segmentResult.getSegment());
            }
            switch (multipleModelMethod) {
                case AVERAGE: 
                case MEDIAN: 
                case MAX: {
                    aggregator.add(hasProbability);
                    continue block17;
                }
                case WEIGHTED_AVERAGE: {
                    double weight = segmentResult.getWeight();
                    aggregator.add(hasProbability, weight);
                    continue block17;
                }
            }
            throw new IllegalArgumentException();
        }
        switch (multipleModelMethod) {
            case AVERAGE: {
                return aggregator.averageMap();
            }
            case WEIGHTED_AVERAGE: {
                return aggregator.weightedAverageMap();
            }
            case MEDIAN: {
                return aggregator.medianMap(categories);
            }
            case MAX: {
                return aggregator.maxMap(categories);
            }
        }
        throw new IllegalArgumentException();
    }
}

