/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.tree;

import com.google.common.base.Objects;
import com.google.common.collect.BiMap;
import org.dmg.pmml.tree.Node;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.HasEntityId;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.Regression;
import org.jpmml.evaluator.Value;

public class NodeScore<V extends Number>
extends Regression<V>
implements HasEntityId,
HasEntityRegistry<Node> {
    private BiMap<String, Node> entityRegistry = null;
    private Node node = null;

    NodeScore(Value<V> value, BiMap<String, Node> entityRegistry, Node node) {
        super(value);
        this.setEntityRegistry(entityRegistry);
        this.setNode(node);
    }

    @Override
    protected Objects.ToStringHelper toStringHelper() {
        Objects.ToStringHelper helper = super.toStringHelper().add("entityId", (Object)this.getEntityId());
        return helper;
    }

    @Override
    public String getEntityId() {
        Node node = this.getNode();
        return EntityUtil.getId(node, this);
    }

    @Override
    public BiMap<String, Node> getEntityRegistry() {
        return this.entityRegistry;
    }

    private void setEntityRegistry(BiMap<String, Node> entityRegistry) {
        this.entityRegistry = entityRegistry;
    }

    public Node getNode() {
        return this.node;
    }

    private void setNode(Node node) {
        this.node = node;
    }
}

