/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.tree;

import com.google.common.base.Objects;
import com.google.common.collect.BiMap;
import java.util.Collections;
import java.util.Set;
import org.dmg.pmml.DataType;
import org.dmg.pmml.tree.Node;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EntityClassification;
import org.jpmml.evaluator.HasConfidence;
import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.Numbers;
import org.jpmml.evaluator.Report;
import org.jpmml.evaluator.ReportUtil;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueMap;

public class NodeScoreDistribution<V extends Number>
extends EntityClassification<Node, V>
implements HasProbability,
HasConfidence {
    private ValueMap<String, V> confidences = null;

    NodeScoreDistribution(ValueMap<String, V> probabilities, BiMap<String, Node> entityRegistry, Node node) {
        super(Classification.Type.PROBABILITY, probabilities, entityRegistry);
        this.setEntity(node);
    }

    @Override
    protected void computeResult(DataType dataType) {
        Node node = (Node)this.getEntity();
        if (node.hasScore()) {
            Object result = TypeUtil.parseOrCast(dataType, node.getScore());
            super.setResult(result);
            return;
        }
        super.computeResult(dataType);
    }

    @Override
    protected Objects.ToStringHelper toStringHelper() {
        ValueMap<String, V> confidences = this.getConfidences();
        Objects.ToStringHelper helper = super.toStringHelper().add(Classification.Type.CONFIDENCE.entryKey(), confidences != null ? confidences.entrySet() : Collections.emptySet());
        return helper;
    }

    public boolean isEmpty() {
        ValueMap values = this.getValues();
        return values.isEmpty();
    }

    @Override
    public Set<String> getCategoryValues() {
        if (this.isEmpty()) {
            Node node = (Node)this.getEntity();
            return Collections.singleton(node.getScore());
        }
        return this.keySet();
    }

    @Override
    public Double getProbability(String category) {
        if (this.isEmpty()) {
            Node node = (Node)this.getEntity();
            if (category != null && category.equals(node.getScore())) {
                return Numbers.DOUBLE_ONE;
            }
            return Numbers.DOUBLE_ZERO;
        }
        return this.getValue(category);
    }

    @Override
    public Report getProbabilityReport(String category) {
        if (this.isEmpty()) {
            return null;
        }
        return this.getValueReport(category);
    }

    @Override
    public Double getConfidence(String category) {
        ValueMap<String, V> confidences = this.getConfidences();
        Value confidence = confidences != null ? (Value)confidences.get(category) : null;
        return Classification.Type.CONFIDENCE.getValue(confidence);
    }

    @Override
    public Report getConfidenceReport(String category) {
        ValueMap<String, V> confidences = this.getConfidences();
        Value confidence = confidences != null ? (Value)confidences.get(category) : null;
        return ReportUtil.getReport(confidence);
    }

    void putConfidence(String category, Value<V> confidence) {
        ValueMap<String, Value<V>> confidences = this.getConfidences();
        if (confidences == null) {
            confidences = new ValueMap();
            this.setConfidences(confidences);
        }
        confidences.put(category, confidence);
    }

    private ValueMap<String, V> getConfidences() {
        return this.confidences;
    }

    private void setConfidences(ValueMap<String, V> confidences) {
        if (confidences == null) {
            throw new IllegalArgumentException();
        }
        this.confidences = confidences;
    }
}

