/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Arrays;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;

public class DoubleVector {
    private int size = 0;
    private double sum = 0.0;
    private double max = Double.NaN;
    private double[] values = null;

    public DoubleVector(int capacity) {
        if (capacity > 0) {
            this.values = new double[capacity];
        }
    }

    public int size() {
        return this.size;
    }

    public double get(int index) {
        if (this.values == null) {
            throw new IllegalStateException();
        }
        if (this.size <= index) {
            throw new IndexOutOfBoundsException();
        }
        return this.values[index];
    }

    public void add(double value) {
        this.sum += value;
        this.max = Double.isNaN(this.max) ? value : Math.max(this.max, value);
        if (this.values != null) {
            this.values[this.size] = value;
        }
        ++this.size;
    }

    public double sum() {
        return this.sum;
    }

    public double max() {
        if (Double.isNaN(this.max)) {
            throw new IllegalStateException();
        }
        return this.max;
    }

    public double median() {
        return this.percentile(50);
    }

    public double percentile(int percentile) {
        if (this.values == null) {
            throw new IllegalStateException();
        }
        double[] data = new double[this.size];
        System.arraycopy(this.values, 0, data, 0, data.length);
        Arrays.sort(data);
        Percentile statistic = new Percentile();
        statistic.setData(data);
        return statistic.evaluate((double)percentile);
    }
}

