/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Objects;
import com.google.common.collect.BiMap;
import org.dmg.pmml.Entity;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.HasEntityId;
import org.jpmml.evaluator.HasEntityRegistry;

public abstract class EntityClassification<E extends Entity>
extends Classification
implements HasEntityId,
HasEntityRegistry<E> {
    private BiMap<String, E> entityRegistry = null;
    private E entity = null;
    private Double entityValue = null;

    protected EntityClassification(Classification.Type type, BiMap<String, E> entityRegistry) {
        super(type);
        this.setEntityRegistry(entityRegistry);
    }

    @Override
    public String getEntityId() {
        E entity = this.getEntity();
        return EntityUtil.getId(entity, this);
    }

    @Override
    public BiMap<String, E> getEntityRegistry() {
        return this.entityRegistry;
    }

    private void setEntityRegistry(BiMap<String, E> entityRegistry) {
        this.entityRegistry = entityRegistry;
    }

    @Override
    protected Objects.ToStringHelper toStringHelper() {
        Objects.ToStringHelper helper = super.toStringHelper().add("entityId", (Object)this.getEntityId());
        return helper;
    }

    public Double put(E entity, String key, Double value) {
        Classification.Type type = this.getType();
        if (this.entityValue == null || type.compare(value, this.entityValue) > 0) {
            this.entityValue = value;
            this.setEntity(entity);
        }
        return this.put(key, value);
    }

    public E getEntity() {
        return this.entity;
    }

    protected void setEntity(E entity) {
        this.entity = entity;
    }
}

