/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.HasValue;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TextIndex;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.evaluator.DiscretizationUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.FunctionUtil;
import org.jpmml.evaluator.Functions;
import org.jpmml.evaluator.HasParsedValue;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.JavaExpression;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.NormalizationUtil;
import org.jpmml.evaluator.PMMLException;
import org.jpmml.evaluator.TextUtil;
import org.jpmml.evaluator.TypeAnalysisException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;
import org.jpmml.evaluator.Values;

public class ExpressionUtil {
    private ExpressionUtil() {
    }

    public static FieldValue evaluate(DerivedField derivedField, EvaluationContext context) {
        FieldValue value = ExpressionUtil.evaluate(derivedField.getExpression(), context);
        return FieldValueUtil.refine((Field)derivedField, value);
    }

    public static FieldValue evaluate(Expression expression, EvaluationContext context) {
        try {
            return ExpressionUtil.evaluateExpression(expression, context);
        }
        catch (PMMLException pe) {
            pe.ensureContext((PMMLObject)expression);
            throw pe;
        }
    }

    static FieldValue evaluateExpression(Expression expression, EvaluationContext context) {
        if (expression instanceof Constant) {
            return ExpressionUtil.evaluateConstant((Constant)expression);
        }
        if (expression instanceof FieldRef) {
            return ExpressionUtil.evaluateFieldRef((FieldRef)expression, context);
        }
        if (expression instanceof NormContinuous) {
            return ExpressionUtil.evaluateNormContinuous((NormContinuous)expression, context);
        }
        if (expression instanceof NormDiscrete) {
            return ExpressionUtil.evaluateNormDiscrete((NormDiscrete)expression, context);
        }
        if (expression instanceof Discretize) {
            return ExpressionUtil.evaluateDiscretize((Discretize)expression, context);
        }
        if (expression instanceof MapValues) {
            return ExpressionUtil.evaluateMapValues((MapValues)expression, context);
        }
        if (expression instanceof TextIndex) {
            return ExpressionUtil.evaluateTextIndex((TextIndex)expression, context);
        }
        if (expression instanceof Apply) {
            return ExpressionUtil.evaluateApply((Apply)expression, context);
        }
        if (expression instanceof Aggregate) {
            return ExpressionUtil.evaluateAggregate((Aggregate)expression, context);
        }
        if (expression instanceof JavaExpression) {
            return ExpressionUtil.evaluateJavaExpression((JavaExpression)expression, context);
        }
        throw new UnsupportedFeatureException((PMMLObject)expression);
    }

    public static DataType getDataType(Expression expression, ModelEvaluator<?> modelEvaluator) {
        if (expression instanceof Constant) {
            Constant constant = (Constant)expression;
            return ExpressionUtil.getConstantDataType(constant);
        }
        if (expression instanceof FieldRef) {
            FieldRef fieldRef = (FieldRef)expression;
            FieldName name = fieldRef.getField();
            TypeDefinitionField field = modelEvaluator.resolveField(name);
            if (field == null) {
                throw new MissingFieldException(name, (PMMLObject)expression);
            }
            return field.getDataType();
        }
        if (expression instanceof NormContinuous) {
            return DataType.DOUBLE;
        }
        if (expression instanceof NormDiscrete) {
            return DataType.DOUBLE;
        }
        if (expression instanceof Discretize) {
            Discretize discretize = (Discretize)expression;
            DataType dataType = discretize.getDataType();
            if (dataType == null) {
                dataType = DataType.STRING;
            }
            return dataType;
        }
        if (expression instanceof MapValues) {
            MapValues mapValues = (MapValues)expression;
            DataType dataType = mapValues.getDataType();
            if (dataType == null) {
                dataType = DataType.STRING;
            }
            return dataType;
        }
        if (expression instanceof TextIndex) {
            TextIndex textIndex = (TextIndex)expression;
            return ExpressionUtil.getTextIndexDataType(textIndex);
        }
        if (expression instanceof Apply) {
            throw new TypeAnalysisException((PMMLObject)expression);
        }
        if (expression instanceof Aggregate) {
            throw new TypeAnalysisException((PMMLObject)expression);
        }
        throw new UnsupportedFeatureException((PMMLObject)expression);
    }

    public static DataType getConstantDataType(Constant constant) {
        DataType dataType = constant.getDataType();
        if (dataType == null) {
            dataType = TypeUtil.getConstantDataType(constant.getValue());
        }
        return dataType;
    }

    public static DataType getTextIndexDataType(TextIndex textIndex) {
        TextIndex.LocalTermWeights localTermWeights = textIndex.getLocalTermWeights();
        switch (localTermWeights) {
            case BINARY: 
            case TERM_FREQUENCY: {
                return DataType.INTEGER;
            }
            case LOGARITHMIC: {
                return DataType.DOUBLE;
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)textIndex, (Enum<?>)localTermWeights);
    }

    public static FieldValue evaluateConstant(Constant constant) {
        if (constant instanceof HasParsedValue) {
            HasParsedValue hasParsedValue = (HasParsedValue)constant;
            return hasParsedValue.getValue(null, null);
        }
        return FieldValueUtil.create(ExpressionUtil.getConstantDataType(constant), null, constant.getValue());
    }

    public static FieldValue evaluateFieldRef(FieldRef fieldRef, EvaluationContext context) {
        FieldValue value = context.evaluate(fieldRef.getField());
        if (value == null) {
            return FieldValueUtil.create(DataType.STRING, OpType.CATEGORICAL, fieldRef.getMapMissingTo());
        }
        return value;
    }

    public static FieldValue evaluateNormContinuous(NormContinuous normContinuous, EvaluationContext context) {
        FieldValue value = context.evaluate(normContinuous.getField());
        if (value == null) {
            return FieldValueUtil.create(DataType.DOUBLE, OpType.CONTINUOUS, normContinuous.getMapMissingTo());
        }
        return NormalizationUtil.normalize(normContinuous, value);
    }

    public static FieldValue evaluateNormDiscrete(NormDiscrete normDiscrete, EvaluationContext context) {
        FieldValue value = context.evaluate(normDiscrete.getField());
        if (value == null) {
            return FieldValueUtil.create(DataType.DOUBLE, OpType.CATEGORICAL, normDiscrete.getMapMissingTo());
        }
        NormDiscrete.Method method = normDiscrete.getMethod();
        switch (method) {
            case INDICATOR: {
                boolean equals = value.equals((HasValue<?>)normDiscrete);
                return FieldValueUtil.create(DataType.DOUBLE, OpType.CATEGORICAL, equals ? Values.DOUBLE_ONE : Values.DOUBLE_ZERO);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)normDiscrete, (Enum<?>)method);
    }

    public static FieldValue evaluateDiscretize(Discretize discretize, EvaluationContext context) {
        FieldValue value = context.evaluate(discretize.getField());
        if (value == null) {
            return FieldValueUtil.create(discretize.getDataType(), null, discretize.getMapMissingTo());
        }
        return DiscretizationUtil.discretize(discretize, value);
    }

    public static FieldValue evaluateMapValues(MapValues mapValues, EvaluationContext context) {
        HashMap<String, FieldValue> values = new HashMap<String, FieldValue>();
        List fieldColumnPairs = mapValues.getFieldColumnPairs();
        for (FieldColumnPair fieldColumnPair : fieldColumnPairs) {
            FieldValue value = context.evaluate(fieldColumnPair.getField());
            if (value == null) {
                return FieldValueUtil.create(mapValues.getDataType(), null, mapValues.getMapMissingTo());
            }
            values.put(fieldColumnPair.getColumn(), value);
        }
        return DiscretizationUtil.mapValue(mapValues, values);
    }

    public static FieldValue evaluateTextIndex(TextIndex textIndex, EvaluationContext context) {
        FieldValue textValue = context.evaluate(textIndex.getTextField());
        Expression expression = textIndex.getExpression();
        if (expression == null) {
            throw new InvalidFeatureException((PMMLObject)textIndex);
        }
        FieldValue termValue = ExpressionUtil.evaluate(expression, context);
        if (textValue == null || termValue == null) {
            return null;
        }
        TextUtil.TextProcessor textProcessor = new TextUtil.TextProcessor(textIndex, textValue);
        List<String> textTokens = textProcessor.process();
        TextUtil.TermProcessor termProcessor = new TextUtil.TermProcessor(textIndex, termValue);
        List<String> termTokens = termProcessor.process();
        int termFrequency = TextUtil.termFrequency(textIndex, textTokens, termTokens);
        TextIndex.LocalTermWeights localTermWeights = textIndex.getLocalTermWeights();
        switch (localTermWeights) {
            case BINARY: 
            case TERM_FREQUENCY: {
                return FieldValueUtil.create(DataType.INTEGER, OpType.CONTINUOUS, termFrequency);
            }
            case LOGARITHMIC: {
                return FieldValueUtil.create(DataType.DOUBLE, OpType.CONTINUOUS, Math.log10(1.0 + (double)termFrequency));
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)textIndex, (Enum<?>)localTermWeights);
    }

    public static FieldValue evaluateApply(Apply apply, EvaluationContext context) {
        FieldValue result;
        String mapMissingTo = apply.getMapMissingTo();
        List expressions = apply.getExpressions();
        ArrayList<FieldValue> values = new ArrayList<FieldValue>(expressions.size());
        Iterator arguments = expressions.iterator();
        String function = apply.getFunction();
        if ("if".equals(function) && arguments.hasNext()) {
            FieldValue flag = ExpressionUtil.evaluate((Expression)arguments.next(), context);
            if (flag == null && mapMissingTo != null) {
                return FieldValueUtil.create(DataType.STRING, OpType.CATEGORICAL, mapMissingTo);
            }
            values.add(flag);
            if (flag == null) {
                if (arguments.hasNext()) {
                    arguments.next();
                    values.add(null);
                    if (arguments.hasNext()) {
                        arguments.next();
                        values.add(null);
                    }
                }
            } else if (flag.asBoolean().booleanValue()) {
                if (arguments.hasNext()) {
                    FieldValue trueValue = ExpressionUtil.evaluate((Expression)arguments.next(), context);
                    if (trueValue == null && mapMissingTo != null) {
                        return FieldValueUtil.create(DataType.STRING, OpType.CATEGORICAL, mapMissingTo);
                    }
                    values.add(trueValue);
                    if (arguments.hasNext()) {
                        arguments.next();
                        values.add(null);
                    }
                }
            } else if (arguments.hasNext()) {
                arguments.next();
                values.add(null);
                if (arguments.hasNext()) {
                    FieldValue falseValue = ExpressionUtil.evaluate((Expression)arguments.next(), context);
                    if (falseValue == null && mapMissingTo != null) {
                        return FieldValueUtil.create(DataType.STRING, OpType.CATEGORICAL, mapMissingTo);
                    }
                    values.add(falseValue);
                }
            }
        }
        while (arguments.hasNext()) {
            FieldValue value = ExpressionUtil.evaluate((Expression)arguments.next(), context);
            if (value == null && mapMissingTo != null) {
                return FieldValueUtil.create(DataType.STRING, OpType.CATEGORICAL, mapMissingTo);
            }
            values.add(value);
        }
        String defaultValue = apply.getDefaultValue();
        try {
            result = FunctionUtil.evaluate(apply, values, context);
        }
        catch (InvalidResultException ire) {
            InvalidValueTreatmentMethod invalidValueTreatmentMethod = apply.getInvalidValueTreatment();
            switch (invalidValueTreatmentMethod) {
                case RETURN_INVALID: {
                    throw new InvalidResultException((PMMLObject)apply);
                }
                case AS_IS: {
                    throw ire;
                }
                case AS_MISSING: {
                    return FieldValueUtil.create(DataType.STRING, OpType.CATEGORICAL, defaultValue);
                }
            }
            throw new UnsupportedFeatureException((PMMLObject)apply, (Enum<?>)invalidValueTreatmentMethod);
        }
        if (result == null && defaultValue != null) {
            return FieldValueUtil.create(DataType.STRING, OpType.CATEGORICAL, defaultValue);
        }
        return result;
    }

    public static FieldValue evaluateAggregate(Aggregate aggregate, EvaluationContext context) {
        FieldValue value = context.evaluate(aggregate.getField());
        Collection values = FieldValueUtil.getValue(Collection.class, value);
        FieldName groupName = aggregate.getGroupField();
        if (groupName != null) {
            FieldValue groupValue = context.evaluate(groupName);
            TypeUtil.getDataType(FieldValueUtil.getValue(groupValue));
        }
        values = Lists.newArrayList((Iterable)Iterables.filter((Iterable)values, (Predicate)Predicates.notNull()));
        Aggregate.Function function = aggregate.getFunction();
        switch (function) {
            case COUNT: {
                return FieldValueUtil.create(DataType.INTEGER, OpType.CONTINUOUS, values.size());
            }
            case SUM: {
                return Functions.SUM.evaluate(FieldValueUtil.createAll(null, null, (List)values));
            }
            case AVERAGE: {
                return Functions.AVG.evaluate(FieldValueUtil.createAll(null, null, (List)values));
            }
            case MIN: {
                return FieldValueUtil.create(null, null, Collections.min((List)values));
            }
            case MAX: {
                return FieldValueUtil.create(null, null, Collections.max((List)values));
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)aggregate, (Enum<?>)function);
    }

    public static FieldValue evaluateJavaExpression(JavaExpression javaExpression, EvaluationContext context) {
        FieldValue value = javaExpression.evaluate(context);
        return value;
    }
}

