/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Target;
import org.dmg.pmml.TargetValue;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ProbabilityDistribution;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;

public class TargetUtil {
    private TargetUtil() {
    }

    public static Map<FieldName, ?> evaluateRegressionDefault(ModelEvaluationContext context) {
        return TargetUtil.evaluateRegression(null, context);
    }

    public static Map<FieldName, ?> evaluateRegression(Double value, ModelEvaluationContext context) {
        ModelEvaluator<?> evaluator = context.getModelEvaluator();
        return TargetUtil.evaluateRegression(evaluator.getTargetField(), value, context);
    }

    public static Map<FieldName, ?> evaluateRegression(TargetField targetField, Double value, EvaluationContext context) {
        return Collections.singletonMap(targetField.getName(), TargetUtil.evaluateRegressionInternal(targetField, value, context));
    }

    public static Object evaluateRegressionInternal(TargetField targetField, Object value, EvaluationContext context) {
        DataField dataField = targetField.getDataField();
        MiningField miningField = targetField.getMiningField();
        Target target = targetField.getTarget();
        if (target != null) {
            if (value == null) {
                value = TargetUtil.getDefaultValue(target);
            }
            if (value != null) {
                value = TargetUtil.processValue(target, (Double)value);
            }
        }
        if (value != null) {
            value = TypeUtil.cast(dataField.getDataType(), value);
        }
        return value;
    }

    public static Map<FieldName, ? extends Classification> evaluateClassificationDefault(ModelEvaluationContext context) {
        return TargetUtil.evaluateClassification(null, context);
    }

    public static Map<FieldName, ? extends Classification> evaluateClassification(Classification value, ModelEvaluationContext context) {
        ModelEvaluator<?> evaluator = context.getModelEvaluator();
        return TargetUtil.evaluateClassification(evaluator.getTargetField(), value, context);
    }

    public static Map<FieldName, ? extends Classification> evaluateClassification(TargetField targetField, Classification value, EvaluationContext context) {
        return Collections.singletonMap(targetField.getName(), TargetUtil.evaluateClassificationInternal(targetField, value, context));
    }

    public static Classification evaluateClassificationInternal(TargetField targetField, Classification value, EvaluationContext context) {
        DataField dataField = targetField.getDataField();
        MiningField miningField = targetField.getMiningField();
        Target target = targetField.getTarget();
        if (target != null && value == null) {
            value = TargetUtil.getPriorProbabilities(target);
        }
        if (value != null) {
            value.computeResult(dataField.getDataType());
        }
        return value;
    }

    public static Double processValue(Target target, Double value) {
        Target.CastInteger castInteger;
        Double rescaleConstant;
        Double rescaleFactor;
        Double max;
        double result = value;
        Double min = target.getMin();
        if (min != null) {
            result = Math.max(result, min);
        }
        if ((max = target.getMax()) != null) {
            result = Math.min(result, max);
        }
        if ((rescaleFactor = target.getRescaleFactor()) != null) {
            result *= rescaleFactor.doubleValue();
        }
        if ((rescaleConstant = target.getRescaleConstant()) != null) {
            result += rescaleConstant.doubleValue();
        }
        if ((castInteger = target.getCastInteger()) == null) {
            if (result == value) {
                return value;
            }
            return result;
        }
        switch (castInteger) {
            case ROUND: {
                return Math.round(result);
            }
            case CEILING: {
                return Math.ceil(result);
            }
            case FLOOR: {
                return Math.floor(result);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)target, (Enum<?>)castInteger);
    }

    public static TargetValue getTargetValue(Target target, Object value) {
        DataType dataType = TypeUtil.getDataType(value);
        List targetValues = target.getTargetValues();
        for (TargetValue targetValue : targetValues) {
            if (!TypeUtil.equals(dataType, value, TypeUtil.parseOrCast(dataType, targetValue.getValue()))) continue;
            return targetValue;
        }
        return null;
    }

    private static Double getDefaultValue(Target target) {
        if (!target.hasTargetValues()) {
            return null;
        }
        List targetValues = target.getTargetValues();
        if (targetValues.size() != 1) {
            throw new InvalidFeatureException((PMMLObject)target);
        }
        TargetValue targetValue = (TargetValue)targetValues.get(0);
        if (targetValue.getValue() != null || targetValue.getPriorProbability() != null) {
            throw new InvalidFeatureException((PMMLObject)targetValue);
        }
        return targetValue.getDefaultValue();
    }

    private static ProbabilityDistribution getPriorProbabilities(Target target) {
        if (!target.hasTargetValues()) {
            return null;
        }
        ProbabilityDistribution result = new ProbabilityDistribution();
        List targetValues = target.getTargetValues();
        for (TargetValue targetValue : targetValues) {
            if (targetValue.getDefaultValue() != null) {
                throw new InvalidFeatureException((PMMLObject)targetValue);
            }
            String targetCategory = targetValue.getValue();
            Double probability = targetValue.getPriorProbability();
            if (targetCategory == null || probability == null) continue;
            result.put(targetCategory, probability);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }
}

