/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.mining;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.EmbeddedModel;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.True;
import org.dmg.pmml.TypeDefinitionField;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segment;
import org.dmg.pmml.mining.Segmentation;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.InputField;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.MiningFieldUtil;
import org.jpmml.evaluator.MissingValueException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.evaluator.OutputField;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.PMMLException;
import org.jpmml.evaluator.PredicateUtil;
import org.jpmml.evaluator.ProbabilityAggregator;
import org.jpmml.evaluator.ProbabilityDistribution;
import org.jpmml.evaluator.RegressionAggregator;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;
import org.jpmml.evaluator.VoteAggregator;
import org.jpmml.evaluator.mining.MiningModelEvaluationContext;
import org.jpmml.evaluator.mining.SegmentResult;

public class MiningModelEvaluator
extends ModelEvaluator<MiningModel>
implements HasEntityRegistry<Segment> {
    private ModelEvaluatorFactory evaluatorFactory = null;
    private ConcurrentMap<String, SegmentHandler> segmentHandlers = new ConcurrentHashMap<String, SegmentHandler>();
    private transient BiMap<String, Segment> entityRegistry = null;
    private static final Set<Segmentation.MultipleModelMethod> REGRESSION_METHODS = EnumSet.of(Segmentation.MultipleModelMethod.AVERAGE, new Segmentation.MultipleModelMethod[]{Segmentation.MultipleModelMethod.WEIGHTED_AVERAGE, Segmentation.MultipleModelMethod.MEDIAN, Segmentation.MultipleModelMethod.WEIGHTED_MEDIAN, Segmentation.MultipleModelMethod.SUM, Segmentation.MultipleModelMethod.WEIGHTED_SUM});
    private static final Set<Segmentation.MultipleModelMethod> CLASSIFICATION_METHODS = EnumSet.of(Segmentation.MultipleModelMethod.MAJORITY_VOTE, new Segmentation.MultipleModelMethod[]{Segmentation.MultipleModelMethod.WEIGHTED_MAJORITY_VOTE, Segmentation.MultipleModelMethod.AVERAGE, Segmentation.MultipleModelMethod.WEIGHTED_AVERAGE, Segmentation.MultipleModelMethod.MEDIAN, Segmentation.MultipleModelMethod.MAX});
    private static final Set<Segmentation.MultipleModelMethod> CLUSTERING_METHODS = EnumSet.of(Segmentation.MultipleModelMethod.MAJORITY_VOTE, Segmentation.MultipleModelMethod.WEIGHTED_MAJORITY_VOTE);
    private static final LoadingCache<MiningModel, BiMap<String, Segment>> entityCache = CacheUtil.buildLoadingCache(new CacheLoader<MiningModel, BiMap<String, Segment>>(){

        public BiMap<String, Segment> load(MiningModel miningModel) {
            Segmentation segmentation = miningModel.getSegmentation();
            return EntityUtil.buildBiMap(segmentation.getSegments());
        }
    });

    public MiningModelEvaluator(PMML pmml) {
        this(pmml, MiningModelEvaluator.selectModel(pmml, MiningModel.class));
    }

    public MiningModelEvaluator(PMML pmml, MiningModel miningModel) {
        super(pmml, miningModel);
        if (miningModel.hasEmbeddedModels()) {
            List embeddedModels = miningModel.getEmbeddedModels();
            EmbeddedModel embeddedModel = (EmbeddedModel)embeddedModels.get(0);
            throw new UnsupportedFeatureException((PMMLObject)embeddedModel);
        }
        Segmentation segmentation = miningModel.getSegmentation();
        if (segmentation == null) {
            throw new InvalidFeatureException((PMMLObject)miningModel);
        }
        if (!segmentation.hasSegments()) {
            throw new InvalidFeatureException((PMMLObject)segmentation);
        }
        LocalTransformations localTransformations = segmentation.getLocalTransformations();
        if (localTransformations != null) {
            throw new UnsupportedFeatureException((PMMLObject)localTransformations);
        }
    }

    @Override
    public String getSummary() {
        return "Ensemble model";
    }

    @Override
    protected DataField getDataField() {
        MiningModel miningModel = (MiningModel)this.getModel();
        Segmentation segmentation = miningModel.getSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case SELECT_ALL: 
            case SELECT_FIRST: 
            case MODEL_CHAIN: {
                return null;
            }
        }
        return super.getDataField();
    }

    @Override
    public FieldName getTargetFieldName() {
        List<TargetField> targetFields = super.getTargetFields();
        if (targetFields.size() == 0) {
            return Evaluator.DEFAULT_TARGET_NAME;
        }
        return super.getTargetFieldName();
    }

    @Override
    public BiMap<String, Segment> getEntityRegistry() {
        if (this.entityRegistry == null) {
            this.entityRegistry = this.getValue(entityCache);
        }
        return this.entityRegistry;
    }

    @Override
    protected List<OutputField> createOutputFields() {
        List<OutputField> outputFields = super.createOutputFields();
        List<OutputField> nestedOutputFields = this.createNestedOutputFields();
        if (nestedOutputFields.size() > 0) {
            return ImmutableList.copyOf((Iterable)Iterables.concat(nestedOutputFields, outputFields));
        }
        return outputFields;
    }

    @Override
    public Map<FieldName, ?> evaluate(Map<FieldName, ?> arguments) {
        MiningModelEvaluationContext context = new MiningModelEvaluationContext(this);
        context.setArguments(arguments);
        return this.evaluate(context);
    }

    @Override
    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        return this.evaluate((MiningModelEvaluationContext)context);
    }

    public Map<FieldName, ?> evaluate(MiningModelEvaluationContext context) {
        Map<FieldName, ?> predictions;
        MiningModel miningModel = (MiningModel)this.getModel();
        if (!miningModel.isScorable()) {
            throw new InvalidResultException((PMMLObject)miningModel);
        }
        MiningFunction miningFunction = miningModel.getMiningFunction();
        switch (miningFunction) {
            case REGRESSION: {
                predictions = this.evaluateRegression(context);
                break;
            }
            case CLASSIFICATION: {
                predictions = this.evaluateClassification(context);
                break;
            }
            case CLUSTERING: {
                predictions = this.evaluateClustering(context);
                break;
            }
            default: {
                predictions = this.evaluateAny(context);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, ?> evaluateRegression(MiningModelEvaluationContext context) {
        MiningModel miningModel = (MiningModel)this.getModel();
        List<SegmentResult> segmentResults = this.evaluateSegmentation(context);
        Map<FieldName, ?> predictions = this.getSegmentationResult(REGRESSION_METHODS, segmentResults);
        if (predictions != null) {
            return predictions;
        }
        Segmentation segmentation = miningModel.getSegmentation();
        Double result = MiningModelEvaluator.aggregateValues(segmentation, segmentResults);
        return TargetUtil.evaluateRegression(result, context);
    }

    private Map<FieldName, ?> evaluateClassification(MiningModelEvaluationContext context) {
        ProbabilityDistribution result;
        MiningModel miningModel = (MiningModel)this.getModel();
        List<SegmentResult> segmentResults = this.evaluateSegmentation(context);
        Map<FieldName, ?> predictions = this.getSegmentationResult(CLASSIFICATION_METHODS, segmentResults);
        if (predictions != null) {
            return predictions;
        }
        Segmentation segmentation = miningModel.getSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case MAJORITY_VOTE: 
            case WEIGHTED_MAJORITY_VOTE: {
                result = new ProbabilityDistribution(MiningModelEvaluator.aggregateVotes(segmentation, segmentResults));
                result.normalizeValues();
                break;
            }
            case AVERAGE: 
            case WEIGHTED_AVERAGE: {
                result = new ProbabilityDistribution(MiningModelEvaluator.aggregateProbabilities(segmentation, segmentResults, null));
                break;
            }
            case MEDIAN: 
            case MAX: {
                TargetField targetField = this.getTargetField();
                DataField dataField = targetField.getDataField();
                List<String> categories = FieldValueUtil.getTargetCategories((TypeDefinitionField)dataField);
                result = new ProbabilityDistribution(MiningModelEvaluator.aggregateProbabilities(segmentation, segmentResults, categories));
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
            }
        }
        return TargetUtil.evaluateClassification(result, context);
    }

    private Map<FieldName, ?> evaluateClustering(MiningModelEvaluationContext context) {
        MiningModel miningModel = (MiningModel)this.getModel();
        List<SegmentResult> segmentResults = this.evaluateSegmentation(context);
        Map<FieldName, ?> predictions = this.getSegmentationResult(CLUSTERING_METHODS, segmentResults);
        if (predictions != null) {
            return predictions;
        }
        Segmentation segmentation = miningModel.getSegmentation();
        Classification result = new Classification(Classification.Type.VOTE, MiningModelEvaluator.aggregateVotes(segmentation, segmentResults));
        result.computeResult(DataType.STRING);
        return Collections.singletonMap(this.getTargetFieldName(), result);
    }

    private Map<FieldName, ?> evaluateAny(MiningModelEvaluationContext context) {
        List<SegmentResult> segmentResults = this.evaluateSegmentation(context);
        return this.getSegmentationResult(Collections.emptySet(), segmentResults);
    }

    private List<SegmentResult> evaluateSegmentation(MiningModelEvaluationContext context) {
        MiningModel miningModel = (MiningModel)this.getModel();
        BiMap<String, Segment> entityRegistry = this.getEntityRegistry();
        MiningFunction miningFunction = miningModel.getMiningFunction();
        Segmentation segmentation = miningModel.getSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        Model lastModel = null;
        ModelEvaluationContext miningModelContext = null;
        ModelEvaluationContext modelContext = null;
        List segments = segmentation.getSegments();
        ArrayList<SegmentResult> segmentResults = new ArrayList<SegmentResult>(segments.size());
        int max = segments.size();
        for (int i = 0; i < max; ++i) {
            SegmentResult segmentResult;
            ModelEvaluationContext segmentContext;
            ModelEvaluator segmentEvaluator;
            Segment segment = (Segment)segments.get(i);
            Predicate predicate = segment.getPredicate();
            if (predicate == null) {
                throw new InvalidFeatureException((PMMLObject)segment);
            }
            Boolean status = PredicateUtil.evaluate(predicate, context);
            if (status == null || !status.booleanValue()) continue;
            Model model = segment.getModel();
            if (model == null) {
                throw new InvalidFeatureException((PMMLObject)segment);
            }
            switch (multipleModelMethod) {
                case MODEL_CHAIN: {
                    lastModel = model;
                    break;
                }
                default: {
                    if (miningFunction.equals((Object)model.getMiningFunction())) break;
                    throw new InvalidFeatureException((PMMLObject)model);
                }
            }
            String segmentId = EntityUtil.getId(segment, entityRegistry);
            SegmentHandler segmentHandler = (SegmentHandler)this.segmentHandlers.get(segmentId);
            if (segmentHandler == null) {
                segmentHandler = this.createSegmentHandler(model);
                this.segmentHandlers.putIfAbsent(segmentId, segmentHandler);
            }
            if ((segmentEvaluator = (ModelEvaluator)segmentHandler.getEvaluator()) instanceof MiningModelEvaluator) {
                MiningModelEvaluator segmentMiningEvaluator = (MiningModelEvaluator)segmentEvaluator;
                if (miningModelContext == null) {
                    miningModelContext = new MiningModelEvaluationContext(context, segmentMiningEvaluator);
                } else {
                    miningModelContext.reset(segmentMiningEvaluator);
                }
                segmentContext = miningModelContext;
            } else {
                if (modelContext == null) {
                    modelContext = new ModelEvaluationContext(context, segmentEvaluator);
                } else {
                    modelContext.reset(segmentEvaluator);
                }
                segmentContext = modelContext;
            }
            segmentContext.setCompatible(segmentHandler.isCompatible());
            try {
                Map<FieldName, ?> result = segmentEvaluator.evaluate(segmentContext);
                FieldName segmentTargetFieldName = segmentEvaluator.getTargetFieldName();
                segmentResult = new SegmentResult(segment, segmentId, result, segmentTargetFieldName);
            }
            catch (PMMLException pe) {
                pe.ensureContext((PMMLObject)segment);
                throw pe;
            }
            context.putResult(segmentId, segmentResult);
            switch (multipleModelMethod) {
                case MODEL_CHAIN: {
                    List<OutputField> outputFields = segmentEvaluator.getOutputFields();
                    for (OutputField outputField : outputFields) {
                        FieldName name = outputField.getName();
                        int depth = outputField.getDepth();
                        if (depth > 0) continue;
                        context.putOutputField(outputField.getOutputField());
                        FieldValue value = segmentContext.getField(name);
                        if (value == null) {
                            throw new MissingValueException(name, (PMMLObject)segment);
                        }
                        context.declare(name, value);
                    }
                    break;
                }
            }
            List<String> segmentWarnings = segmentContext.getWarnings();
            for (String segmentWarning : segmentWarnings) {
                context.addWarning(segmentWarning);
            }
            switch (multipleModelMethod) {
                case SELECT_FIRST: {
                    return Collections.singletonList(segmentResult);
                }
            }
            segmentResults.add(segmentResult);
        }
        switch (multipleModelMethod) {
            case MODEL_CHAIN: {
                if (lastModel == null || miningFunction.equals((Object)lastModel.getMiningFunction())) break;
                throw new InvalidFeatureException((PMMLObject)lastModel);
            }
        }
        return segmentResults;
    }

    private Map<FieldName, ?> getSegmentationResult(Set<Segmentation.MultipleModelMethod> multipleModelMethods, List<SegmentResult> segmentResults) {
        MiningModel miningModel = (MiningModel)this.getModel();
        Segmentation segmentation = miningModel.getSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case SELECT_ALL: {
                return MiningModelEvaluator.selectAll(segmentResults);
            }
            case SELECT_FIRST: {
                if (segmentResults.size() <= 0) break;
                return (Map)((Object)segmentResults.get(0));
            }
            case MODEL_CHAIN: {
                if (segmentResults.size() <= 0) break;
                return (Map)((Object)segmentResults.get(segmentResults.size() - 1));
            }
            default: {
                if (multipleModelMethods.contains(multipleModelMethod)) break;
                throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
            }
        }
        if (segmentResults.size() == 0) {
            return Collections.singletonMap(this.getTargetFieldName(), null);
        }
        return null;
    }

    private List<Segment> getActiveHead(List<Segment> segments) {
        int max = segments.size();
        for (int i = 0; i < max; ++i) {
            Segment segment = segments.get(i);
            Predicate predicate = segment.getPredicate();
            if (predicate == null) {
                throw new InvalidFeatureException((PMMLObject)segment);
            }
            if (!(predicate instanceof True)) continue;
            return segments.subList(0, i + 1);
        }
        return segments;
    }

    private List<Segment> getActiveTail(List<Segment> segments) {
        return Lists.reverse(this.getActiveHead(Lists.reverse(segments)));
    }

    private List<OutputField> createNestedOutputFields() {
        MiningModel miningModel = (MiningModel)this.getModel();
        Segmentation segmentation = miningModel.getSegmentation();
        List segments = segmentation.getSegments();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case SELECT_ALL: {
                break;
            }
            case SELECT_FIRST: {
                return this.createNestedOutputFields(this.getActiveHead(segments));
            }
            case MODEL_CHAIN: {
                return this.createNestedOutputFields(this.getActiveTail(segments));
            }
        }
        return Collections.emptyList();
    }

    private List<OutputField> createNestedOutputFields(List<Segment> segments) {
        ArrayList<OutputField> result = new ArrayList<OutputField>();
        BiMap<String, Segment> entityRegistry = this.getEntityRegistry();
        int max = segments.size();
        for (int i = 0; i < max; ++i) {
            Segment segment = segments.get(i);
            Model model = segment.getModel();
            if (model == null) {
                throw new InvalidFeatureException((PMMLObject)segment);
            }
            String segmentId = EntityUtil.getId(segment, entityRegistry);
            SegmentHandler segmentHandler = (SegmentHandler)this.segmentHandlers.get(segmentId);
            if (segmentHandler == null) {
                segmentHandler = this.createSegmentHandler(model);
                this.segmentHandlers.putIfAbsent(segmentId, segmentHandler);
            }
            Evaluator evaluator = segmentHandler.getEvaluator();
            List<OutputField> outputFields = evaluator.getOutputFields();
            for (OutputField outputField : outputFields) {
                OutputField nestedOutputField = new OutputField(outputField);
                result.add(nestedOutputField);
            }
        }
        return ImmutableList.copyOf(result);
    }

    private SegmentHandler createSegmentHandler(Model model) {
        ModelEvaluatorFactory evaluatorFactory = this.getEvaluatorFactory();
        if (evaluatorFactory == null) {
            evaluatorFactory = ModelEvaluatorFactory.newInstance();
        }
        ModelEvaluator<? extends Model> evaluator = evaluatorFactory.newModelEvaluator(this.getPMML(), model);
        boolean compatible = true;
        List<InputField> inputFields = evaluator.getInputFields();
        for (InputField inputField : inputFields) {
            Field field = inputField.getField();
            MiningField miningField = inputField.getMiningField();
            if (!(field instanceof DataField)) continue;
            compatible &= MiningFieldUtil.isDefault(miningField);
        }
        SegmentHandler result = new SegmentHandler(evaluator, compatible);
        return result;
    }

    public ModelEvaluatorFactory getEvaluatorFactory() {
        return this.evaluatorFactory;
    }

    public void setEvaluatorFactory(ModelEvaluatorFactory evaluatorFactory) {
        this.evaluatorFactory = evaluatorFactory;
    }

    private static Double aggregateValues(Segmentation segmentation, List<SegmentResult> segmentResults) {
        RegressionAggregator aggregator;
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case MEDIAN: 
            case WEIGHTED_MEDIAN: {
                aggregator = new RegressionAggregator(segmentResults.size());
                break;
            }
            default: {
                aggregator = new RegressionAggregator();
            }
        }
        block15: for (SegmentResult segmentResult : segmentResults) {
            Double value = (Double)segmentResult.getTargetValue(DataType.DOUBLE);
            switch (multipleModelMethod) {
                case AVERAGE: 
                case MEDIAN: 
                case SUM: {
                    aggregator.add(value);
                    continue block15;
                }
                case WEIGHTED_AVERAGE: 
                case WEIGHTED_MEDIAN: 
                case WEIGHTED_SUM: {
                    double weight = segmentResult.getWeight();
                    aggregator.add(value, weight);
                    continue block15;
                }
            }
            throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
        }
        switch (multipleModelMethod) {
            case AVERAGE: {
                return aggregator.average();
            }
            case WEIGHTED_AVERAGE: {
                return aggregator.weightedAverage();
            }
            case MEDIAN: {
                return aggregator.median();
            }
            case WEIGHTED_MEDIAN: {
                return aggregator.weightedMedian();
            }
            case SUM: {
                return aggregator.sum();
            }
            case WEIGHTED_SUM: {
                return aggregator.weightedSum();
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
    }

    private static Map<String, Double> aggregateVotes(Segmentation segmentation, List<SegmentResult> segmentResults) {
        VoteAggregator<String> aggregator = new VoteAggregator<String>();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        block4: for (SegmentResult segmentResult : segmentResults) {
            String key = (String)segmentResult.getTargetValue(DataType.STRING);
            switch (multipleModelMethod) {
                case MAJORITY_VOTE: {
                    aggregator.add(key, 1.0);
                    continue block4;
                }
                case WEIGHTED_MAJORITY_VOTE: {
                    aggregator.add(key, segmentResult.getWeight());
                    continue block4;
                }
            }
            throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
        }
        return aggregator.sumMap();
    }

    private static Map<String, Double> aggregateProbabilities(Segmentation segmentation, List<SegmentResult> segmentResults, List<String> categories) {
        ProbabilityAggregator aggregator;
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case MEDIAN: 
            case MAX: {
                aggregator = new ProbabilityAggregator(segmentResults.size());
                break;
            }
            default: {
                aggregator = new ProbabilityAggregator();
            }
        }
        block14: for (SegmentResult segmentResult : segmentResults) {
            HasProbability hasProbability = segmentResult.getTargetValue(HasProbability.class);
            switch (multipleModelMethod) {
                case AVERAGE: {
                    aggregator.add(hasProbability);
                    continue block14;
                }
                case WEIGHTED_AVERAGE: {
                    double weight = segmentResult.getWeight();
                    aggregator.add(hasProbability, weight);
                    continue block14;
                }
                case MEDIAN: 
                case MAX: {
                    aggregator.add(hasProbability);
                    continue block14;
                }
            }
            throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
        }
        switch (multipleModelMethod) {
            case AVERAGE: {
                return aggregator.averageMap();
            }
            case WEIGHTED_AVERAGE: {
                return aggregator.weightedAverageMap();
            }
            case MEDIAN: {
                return aggregator.medianMap(categories);
            }
            case MAX: {
                return aggregator.maxMap(categories);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
    }

    private static Map<FieldName, ?> selectAll(List<SegmentResult> segmentResults) {
        ArrayListMultimap result = ArrayListMultimap.create();
        LinkedHashSet keys = null;
        for (SegmentResult segmentResult : segmentResults) {
            if (keys == null) {
                keys = new LinkedHashSet(segmentResult.keySet());
            }
            if (!keys.equals(segmentResult.keySet())) {
                throw new EvaluationException();
            }
            for (FieldName key : keys) {
                result.put((Object)key, segmentResult.get(key));
            }
        }
        return result.asMap();
    }

    private static class SegmentHandler
    implements Serializable {
        private Evaluator evaluator = null;
        private boolean compatible = false;

        private SegmentHandler(Evaluator evaluator, boolean compatible) {
            this.setEvaluator(evaluator);
            this.setCompatible(compatible);
        }

        public Evaluator getEvaluator() {
            return this.evaluator;
        }

        private void setEvaluator(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        public boolean isCompatible() {
            return this.compatible;
        }

        private void setCompatible(boolean compatible) {
            this.compatible = compatible;
        }
    }
}

